/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.runtime;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.arc.Arc;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import xyz.block.ftl.runtime.FTLController;

@Singleton
public class TopicHelper {
    final ObjectMapper mapper;

    public TopicHelper(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public void publish(String topic, String verb, Object message) {
        try {
            FTLController.instance().publishEvent(topic, verb, this.mapper.writeValueAsBytes(message));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static TopicHelper instance() {
        return (TopicHelper)Arc.container().instance(TopicHelper.class, new Annotation[0]).get();
    }
}

