/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.runtime.processor;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.processing.Completion;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import xyz.block.ftl.Config;
import xyz.block.ftl.Enum;
import xyz.block.ftl.Export;
import xyz.block.ftl.Secret;
import xyz.block.ftl.TypeAlias;
import xyz.block.ftl.Verb;

public class AnnotationProcessor
implements Processor {
    private static final Pattern REMOVE_LEADING_SPACE = Pattern.compile("^ ", 8);
    private static final Pattern REMOVE_JAVADOC_TAGS = Pattern.compile("^\\s*@(param|return|throws|exception|see|author)\\b[^\\n]*$\\n*", 8);
    private ProcessingEnvironment processingEnv;
    final Map<String, String> saved = new HashMap<String, String>();

    @Override
    public Set<String> getSupportedOptions() {
        return Set.of();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Set.of(Verb.class.getName(), Enum.class.getName(), Export.class.getName(), TypeAlias.class.getName());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public void init(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        roundEnv.getElementsAnnotatedWithAny(Set.of(Verb.class, Enum.class, Export.class, TypeAlias.class)).forEach(element -> {
            Optional<String> javadoc = this.getJavadoc((Element)element);
            javadoc.ifPresent(doc -> {
                String strippedDownDoc = this.stripJavadocTags((String)doc);
                if (element.getAnnotation(TypeAlias.class) != null) {
                    this.saved.put(element.getAnnotation(TypeAlias.class).name(), strippedDownDoc);
                } else {
                    this.saved.put(element.getSimpleName().toString(), strippedDownDoc);
                }
                if (element.getKind() == ElementKind.METHOD) {
                    ExecutableElement executableElement = (ExecutableElement)element;
                    executableElement.getParameters().forEach(param -> {
                        Secret secret;
                        Config config = param.getAnnotation(Config.class);
                        if (config != null) {
                            this.saved.put(config.value(), this.extractCommentForParam((String)doc, (VariableElement)param));
                        }
                        if ((secret = param.getAnnotation(Secret.class)) != null) {
                            this.saved.put(secret.value(), this.extractCommentForParam((String)doc, (VariableElement)param));
                        }
                    });
                }
            });
        });
        if (roundEnv.processingOver()) {
            this.write("META-INF/ftl-verbs.txt", this.saved.entrySet().stream().map(e -> (String)e.getKey() + "=" + Base64.getEncoder().encodeToString(((String)e.getValue()).getBytes(StandardCharsets.UTF_8))).collect(Collectors.toSet()));
        }
        return false;
    }

    public void write(String filePath, Set<String> set) {
        if (set.isEmpty()) {
            return;
        }
        try {
            FileObject listResource = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", filePath.toString(), new Element[0]);
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(listResource.openOutputStream(), StandardCharsets.UTF_8));){
                for (String className : set) {
                    writer.write(className);
                    writer.newLine();
                }
            }
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to write " + filePath + ": " + e);
            return;
        }
    }

    @Override
    public Iterable<? extends Completion> getCompletions(Element element, AnnotationMirror annotation, ExecutableElement member, String userText) {
        return null;
    }

    public Optional<String> getJavadoc(Element e) {
        String docComment = this.processingEnv.getElementUtils().getDocComment(e);
        if (docComment == null || docComment.isBlank()) {
            return Optional.empty();
        }
        return Optional.of(REMOVE_LEADING_SPACE.matcher(docComment).replaceAll("").trim());
    }

    public String stripJavadocTags(String doc) {
        return REMOVE_JAVADOC_TAGS.matcher(doc).replaceAll("");
    }

    private String extractCommentForParam(String doc, VariableElement param) {
        String variableName = param.getSimpleName().toString();
        int startIdx = doc.indexOf("@param " + variableName + " ");
        if (startIdx != -1) {
            int endIndex = doc.indexOf("\n", startIdx);
            if (endIndex == -1) {
                endIndex = doc.length();
            }
            return doc.substring(startIdx + variableName.length() + 8, endIndex);
        }
        return null;
    }
}

