/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.runtime;

import com.google.protobuf.ByteString;
import com.google.protobuf.Duration;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.stub.StreamObserver;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.logging.Logger;
import xyz.block.ftl.LeaseClient;
import xyz.block.ftl.LeaseFailedException;
import xyz.block.ftl.LeaseHandle;
import xyz.block.ftl.v1.AcquireLeaseRequest;
import xyz.block.ftl.v1.AcquireLeaseResponse;
import xyz.block.ftl.v1.CallRequest;
import xyz.block.ftl.v1.CallResponse;
import xyz.block.ftl.v1.ModuleContextRequest;
import xyz.block.ftl.v1.ModuleContextResponse;
import xyz.block.ftl.v1.ModuleServiceGrpc;
import xyz.block.ftl.v1.PublishEventRequest;
import xyz.block.ftl.v1.PublishEventResponse;
import xyz.block.ftl.v1.VerbServiceGrpc;
import xyz.block.ftl.v1.schema.Ref;

public class FTLController
implements LeaseClient {
    private static final Logger log = Logger.getLogger(FTLController.class);
    final String moduleName;
    private Throwable currentError;
    private volatile ModuleContextResponse moduleContextResponse;
    private boolean waiters = false;
    final VerbServiceGrpc.VerbServiceStub verbService;
    final ModuleServiceGrpc.ModuleServiceStub moduleService;
    final StreamObserver<ModuleContextResponse> moduleObserver = new ModuleObserver();
    private static volatile FTLController controller;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FTLController instance() {
        if (controller != null) return controller;
        Class<FTLController> clazz = FTLController.class;
        synchronized (FTLController.class) {
            if (controller != null) return controller;
            controller = new FTLController();
            // ** MonitorExit[var0] (shouldn't be in output)
            return controller;
        }
    }

    FTLController() {
        String endpoint = System.getenv("FTL_ENDPOINT");
        String testEndpoint = System.getProperty("ftl.test.endpoint");
        if (testEndpoint != null) {
            endpoint = testEndpoint;
        }
        if (endpoint == null) {
            endpoint = "http://localhost:8892";
        }
        URI uri = URI.create(endpoint);
        this.moduleName = System.getProperty("ftl.module.name");
        ManagedChannelBuilder channelBuilder = ManagedChannelBuilder.forAddress((String)uri.getHost(), (int)uri.getPort());
        if (uri.getScheme().equals("http")) {
            channelBuilder.usePlaintext();
        }
        ManagedChannel channel = channelBuilder.build();
        this.moduleService = ModuleServiceGrpc.newStub((Channel)channel);
        this.moduleService.getModuleContext(ModuleContextRequest.newBuilder().setModule(this.moduleName).build(), this.moduleObserver);
        this.verbService = VerbServiceGrpc.newStub((Channel)channel);
    }

    public byte[] getSecret(String secretName) {
        ModuleContextResponse context = this.getModuleContext();
        if (context.containsSecrets(secretName)) {
            return context.getSecretsMap().get(secretName).toByteArray();
        }
        throw new RuntimeException("Secret not found: " + secretName);
    }

    public byte[] getConfig(String secretName) {
        ModuleContextResponse context = this.getModuleContext();
        if (context.containsConfigs(secretName)) {
            return context.getConfigsMap().get(secretName).toByteArray();
        }
        throw new RuntimeException("Config not found: " + secretName);
    }

    public Datasource getDatasource(String name) {
        List<ModuleContextResponse.DSN> databasesList = this.getModuleContext().getDatabasesList();
        for (ModuleContextResponse.DSN i : databasesList) {
            if (!i.getName().equals(name)) continue;
            return Datasource.fromDSN(i.getDsn());
        }
        return null;
    }

    public byte[] callVerb(String name, String module, byte[] payload) {
        final CompletableFuture cf = new CompletableFuture();
        this.verbService.call(CallRequest.newBuilder().setVerb(Ref.newBuilder().setModule(module).setName(name)).setBody(ByteString.copyFrom((byte[])payload)).build(), new StreamObserver<CallResponse>(){

            public void onNext(CallResponse callResponse) {
                if (callResponse.hasError()) {
                    cf.completeExceptionally(new RuntimeException(callResponse.getError().getMessage()));
                } else {
                    cf.complete(callResponse.getBody().toByteArray());
                }
            }

            public void onError(Throwable throwable) {
                cf.completeExceptionally(throwable);
            }

            public void onCompleted() {
            }
        });
        try {
            return (byte[])cf.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void publishEvent(String topic, String callingVerbName, byte[] event) {
        final CompletableFuture cf = new CompletableFuture();
        this.moduleService.publishEvent(PublishEventRequest.newBuilder().setCaller(callingVerbName).setBody(ByteString.copyFrom((byte[])event)).setTopic(Ref.newBuilder().setModule(this.moduleName).setName(topic).build()).build(), new StreamObserver<PublishEventResponse>(){

            public void onNext(PublishEventResponse publishEventResponse) {
                cf.complete(null);
            }

            public void onError(Throwable throwable) {
                cf.completeExceptionally(throwable);
            }

            public void onCompleted() {
                cf.complete(null);
            }
        });
        try {
            cf.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public LeaseHandle acquireLease(java.time.Duration duration, String ... keys) throws LeaseFailedException {
        final CompletableFuture cf = new CompletableFuture();
        final StreamObserver<AcquireLeaseRequest> client = this.moduleService.acquireLease(new StreamObserver<AcquireLeaseResponse>(){

            public void onNext(AcquireLeaseResponse value) {
                cf.complete(null);
            }

            public void onError(Throwable t) {
                cf.completeExceptionally(t);
            }

            public void onCompleted() {
                if (!cf.isDone()) {
                    this.onError(new RuntimeException("stream closed"));
                }
            }
        });
        client.onNext((Object)AcquireLeaseRequest.newBuilder().setModule(this.moduleName).addAllKey(Arrays.asList(keys)).setTtl(Duration.newBuilder().setSeconds(duration.toSeconds())).build());
        try {
            cf.get();
        }
        catch (Exception e) {
            throw new LeaseFailedException("lease already held", e);
        }
        return new LeaseHandle(){

            @Override
            public void close() {
                client.onCompleted();
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ModuleContextResponse getModuleContext() {
        ModuleContextResponse moduleContext = this.moduleContextResponse;
        if (moduleContext != null) {
            return moduleContext;
        }
        StreamObserver<ModuleContextResponse> streamObserver = this.moduleObserver;
        synchronized (streamObserver) {
            while ((moduleContext = this.moduleContextResponse) == null) {
                if (this.currentError != null) {
                    throw new RuntimeException(this.currentError);
                }
                this.waiters = true;
                try {
                    this.moduleObserver.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            return moduleContext;
        }
    }

    private class ModuleObserver
    implements StreamObserver<ModuleContextResponse> {
        final AtomicInteger failCount = new AtomicInteger();

        private ModuleObserver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(ModuleContextResponse moduleContextResponse) {
            ModuleObserver moduleObserver = this;
            synchronized (moduleObserver) {
                FTLController.this.currentError = null;
                FTLController.this.moduleContextResponse = moduleContextResponse;
                if (FTLController.this.waiters) {
                    this.notifyAll();
                    FTLController.this.waiters = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onError(Throwable throwable) {
            log.error((Object)"GRPC connection error", throwable);
            ModuleObserver moduleObserver = this;
            synchronized (moduleObserver) {
                FTLController.this.currentError = throwable;
                if (FTLController.this.waiters) {
                    this.notifyAll();
                    FTLController.this.waiters = false;
                }
            }
            if (this.failCount.incrementAndGet() < 5) {
                FTLController.this.moduleService.getModuleContext(ModuleContextRequest.newBuilder().setModule(FTLController.this.moduleName).build(), FTLController.this.moduleObserver);
            }
        }

        public void onCompleted() {
            this.onError(new RuntimeException("connection closed"));
        }
    }

    public record Datasource(String connectionString, String username, String password) {
        public static Datasource fromDSN(String dsn) {
            try {
                URI uri = new URI(dsn);
                String username = "";
                String password = "";
                String userInfo = uri.getUserInfo();
                if (userInfo != null) {
                    String[] split = userInfo.split(":");
                    username = split[0];
                    password = split[1];
                    return new Datasource(new URI("jdbc:postgresql", null, uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), null).toASCIIString(), username, password);
                }
                Matcher matcher = Pattern.compile("[&?]user=([^?]*)").matcher(dsn);
                if (matcher.find()) {
                    username = matcher.group(1);
                }
                dsn = matcher.replaceAll("");
                matcher = Pattern.compile("[&?]password=([^?]*)").matcher(dsn);
                if (matcher.find()) {
                    password = matcher.group(1);
                }
                dsn = matcher.replaceAll("");
                dsn = dsn.replaceAll("postgresql://", "jdbc:postgresql://");
                dsn = dsn.replaceAll("postgres://", "jdbc:postgresql://");
                return new Datasource(dsn, username, password);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

