/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.runtime;

import com.google.protobuf.ByteString;
import com.google.protobuf.Duration;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.stub.StreamObserver;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.logging.Logger;
import xyz.block.ftl.LeaseClient;
import xyz.block.ftl.LeaseFailedException;
import xyz.block.ftl.LeaseHandle;
import xyz.block.ftl.deployment.v1.DeploymentServiceGrpc;
import xyz.block.ftl.deployment.v1.GetDeploymentContextRequest;
import xyz.block.ftl.deployment.v1.GetDeploymentContextResponse;
import xyz.block.ftl.lease.v1.AcquireLeaseRequest;
import xyz.block.ftl.lease.v1.AcquireLeaseResponse;
import xyz.block.ftl.lease.v1.LeaseServiceGrpc;
import xyz.block.ftl.publish.v1.PublishEventRequest;
import xyz.block.ftl.publish.v1.PublishEventResponse;
import xyz.block.ftl.publish.v1.PublishServiceGrpc;
import xyz.block.ftl.schema.v1.Ref;
import xyz.block.ftl.v1.CallRequest;
import xyz.block.ftl.v1.CallResponse;
import xyz.block.ftl.v1.VerbServiceGrpc;

public class FTLController
implements LeaseClient {
    private static final Logger log = Logger.getLogger(FTLController.class);
    final String moduleName;
    final String deploymentName;
    private Throwable currentError;
    private volatile GetDeploymentContextResponse moduleContextResponse;
    private boolean waiters = false;
    final VerbServiceGrpc.VerbServiceStub verbService;
    final DeploymentServiceGrpc.DeploymentServiceStub deploymentService;
    final LeaseServiceGrpc.LeaseServiceStub leaseService;
    final PublishServiceGrpc.PublishServiceStub publishService;
    final StreamObserver<GetDeploymentContextResponse> moduleObserver = new ModuleObserver();
    private static volatile FTLController controller;
    private final Map<String, GetDeploymentContextResponse.DbType> databases = new ConcurrentHashMap<String, GetDeploymentContextResponse.DbType>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FTLController instance() {
        if (controller != null) return controller;
        Class<FTLController> clazz = FTLController.class;
        synchronized (FTLController.class) {
            if (controller != null) return controller;
            controller = new FTLController();
            // ** MonitorExit[var0] (shouldn't be in output)
            return controller;
        }
    }

    FTLController() {
        String endpoint = System.getenv("FTL_ENDPOINT");
        String ftlDeployment = System.getenv("FTL_DEPLOYMENT");
        String testEndpoint = System.getProperty("ftl.test.endpoint");
        if (testEndpoint != null) {
            endpoint = testEndpoint;
        }
        if (endpoint == null) {
            endpoint = "http://localhost:8892";
        }
        URI uri = URI.create(endpoint);
        this.moduleName = System.getProperty("ftl.module.name");
        this.deploymentName = ftlDeployment == null ? this.moduleName : ftlDeployment;
        ManagedChannelBuilder channelBuilder = ManagedChannelBuilder.forAddress((String)uri.getHost(), (int)uri.getPort());
        if (uri.getScheme().equals("http")) {
            channelBuilder.usePlaintext();
        }
        ManagedChannel channel = channelBuilder.build();
        this.deploymentService = DeploymentServiceGrpc.newStub((Channel)channel);
        this.deploymentService.getDeploymentContext(GetDeploymentContextRequest.newBuilder().setDeployment(this.deploymentName).build(), this.moduleObserver);
        this.verbService = VerbServiceGrpc.newStub((Channel)channel);
        this.publishService = PublishServiceGrpc.newStub((Channel)channel);
        this.leaseService = LeaseServiceGrpc.newStub((Channel)channel);
    }

    public void registerDatabase(String name, GetDeploymentContextResponse.DbType type) {
        this.databases.put(name, type);
    }

    public byte[] getSecret(String secretName) {
        GetDeploymentContextResponse context = this.getDeploymentContext();
        if (context.containsSecrets(secretName)) {
            return context.getSecretsMap().get(secretName).toByteArray();
        }
        throw new RuntimeException("Secret not found: " + secretName);
    }

    public byte[] getConfig(String secretName) {
        GetDeploymentContextResponse context = this.getDeploymentContext();
        if (context.containsConfigs(secretName)) {
            return context.getConfigsMap().get(secretName).toByteArray();
        }
        throw new RuntimeException("Config not found: " + secretName);
    }

    public Datasource getDatasource(String name) {
        if (this.databases.get(name) == GetDeploymentContextResponse.DbType.DB_TYPE_POSTGRES) {
            String proxyAddress = System.getenv("FTL_PROXY_POSTGRES_ADDRESS");
            return new Datasource("jdbc:postgresql://" + proxyAddress + "/" + name, "ftl", "ftl");
        }
        if (this.databases.get(name) == GetDeploymentContextResponse.DbType.DB_TYPE_MYSQL) {
            String proxyAddress = System.getenv("FTL_PROXY_MYSQL_ADDRESS_" + name.toUpperCase());
            return new Datasource("jdbc:mysql://" + proxyAddress + "/" + name, "ftl", "ftl");
        }
        List<GetDeploymentContextResponse.DSN> databasesList = this.getDeploymentContext().getDatabasesList();
        for (GetDeploymentContextResponse.DSN i : databasesList) {
            if (!i.getName().equals(name)) continue;
            return Datasource.fromDSN(i.getDsn(), i.getType());
        }
        return null;
    }

    public byte[] callVerb(String name, String module, byte[] payload) {
        final CompletableFuture cf = new CompletableFuture();
        this.verbService.call(CallRequest.newBuilder().setVerb(Ref.newBuilder().setModule(module).setName(name)).setBody(ByteString.copyFrom((byte[])payload)).build(), new StreamObserver<CallResponse>(){

            public void onNext(CallResponse callResponse) {
                if (callResponse.hasError()) {
                    cf.completeExceptionally(new RuntimeException(callResponse.getError().getMessage()));
                } else {
                    cf.complete(callResponse.getBody().toByteArray());
                }
            }

            public void onError(Throwable throwable) {
                cf.completeExceptionally(throwable);
            }

            public void onCompleted() {
            }
        });
        try {
            return (byte[])cf.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void publishEvent(String topic, String callingVerbName, byte[] event, String key) {
        final CompletableFuture cf = new CompletableFuture();
        this.publishService.publishEvent(PublishEventRequest.newBuilder().setCaller(callingVerbName).setBody(ByteString.copyFrom((byte[])event)).setTopic(Ref.newBuilder().setModule(this.moduleName).setName(topic).build()).setKey(key).build(), new StreamObserver<PublishEventResponse>(){

            public void onNext(PublishEventResponse publishEventResponse) {
                cf.complete(null);
            }

            public void onError(Throwable throwable) {
                cf.completeExceptionally(throwable);
            }

            public void onCompleted() {
                cf.complete(null);
            }
        });
        try {
            cf.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public LeaseHandle acquireLease(java.time.Duration duration, String ... keys) throws LeaseFailedException {
        final CompletableFuture cf = new CompletableFuture();
        final StreamObserver<AcquireLeaseRequest> client = this.leaseService.acquireLease(new StreamObserver<AcquireLeaseResponse>(){

            public void onNext(AcquireLeaseResponse value) {
                cf.complete(null);
            }

            public void onError(Throwable t) {
                cf.completeExceptionally(t);
            }

            public void onCompleted() {
                if (!cf.isDone()) {
                    this.onError(new RuntimeException("stream closed"));
                }
            }
        });
        ArrayList<String> realKeys = new ArrayList<String>();
        realKeys.add("module");
        realKeys.add(this.moduleName);
        realKeys.addAll(Arrays.asList(keys));
        client.onNext((Object)AcquireLeaseRequest.newBuilder().addAllKey(realKeys).setTtl(Duration.newBuilder().setSeconds(duration.toSeconds())).build());
        try {
            cf.get();
        }
        catch (Exception e) {
            throw new LeaseFailedException("lease already held", e);
        }
        return new LeaseHandle(){

            @Override
            public void close() {
                client.onCompleted();
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private GetDeploymentContextResponse getDeploymentContext() {
        GetDeploymentContextResponse moduleContext = this.moduleContextResponse;
        if (moduleContext != null) {
            return moduleContext;
        }
        StreamObserver<GetDeploymentContextResponse> streamObserver = this.moduleObserver;
        synchronized (streamObserver) {
            while ((moduleContext = this.moduleContextResponse) == null) {
                if (this.currentError != null) {
                    throw new RuntimeException(this.currentError);
                }
                this.waiters = true;
                try {
                    this.moduleObserver.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            return moduleContext;
        }
    }

    private class ModuleObserver
    implements StreamObserver<GetDeploymentContextResponse> {
        final AtomicInteger failCount = new AtomicInteger();

        private ModuleObserver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(GetDeploymentContextResponse moduleContextResponse) {
            ModuleObserver moduleObserver = this;
            synchronized (moduleObserver) {
                FTLController.this.currentError = null;
                FTLController.this.moduleContextResponse = moduleContextResponse;
                if (FTLController.this.waiters) {
                    this.notifyAll();
                    FTLController.this.waiters = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onError(Throwable throwable) {
            log.error((Object)"GRPC connection error", throwable);
            ModuleObserver moduleObserver = this;
            synchronized (moduleObserver) {
                FTLController.this.currentError = throwable;
                if (FTLController.this.waiters) {
                    this.notifyAll();
                    FTLController.this.waiters = false;
                }
            }
            if (this.failCount.incrementAndGet() < 5) {
                FTLController.this.deploymentService.getDeploymentContext(GetDeploymentContextRequest.newBuilder().setDeployment(FTLController.this.deploymentName).build(), FTLController.this.moduleObserver);
            }
        }

        public void onCompleted() {
            this.onError(new RuntimeException("connection closed"));
        }
    }

    public record Datasource(String connectionString, String username, String password) {
        public static Datasource fromDSN(String dsn, GetDeploymentContextResponse.DbType type) {
            String prefix = type.equals((Object)GetDeploymentContextResponse.DbType.DB_TYPE_MYSQL) ? "jdbc:mysql" : "jdbc:postgresql";
            try {
                URI uri = new URI((String)dsn);
                String username = "";
                String password = "";
                String userInfo = uri.getUserInfo();
                if (userInfo != null) {
                    String[] split = userInfo.split(":");
                    username = split[0];
                    password = split[1];
                    return new Datasource(new URI(prefix, null, uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), null).toASCIIString(), username, password);
                }
                Matcher matcher = Pattern.compile("[&?]user=([^?&]*)").matcher((CharSequence)dsn);
                if (matcher.find()) {
                    username = matcher.group(1);
                    dsn = matcher.replaceAll("");
                }
                if ((matcher = Pattern.compile("[&?]password=([^?&]*)").matcher((CharSequence)dsn)).find()) {
                    password = matcher.group(1);
                    dsn = matcher.replaceAll("");
                }
                if ((matcher = Pattern.compile("^([^:]+):([^:]+)@").matcher((CharSequence)dsn)).find()) {
                    username = matcher.group(1);
                    password = matcher.group(2);
                    dsn = matcher.replaceAll("");
                }
                if ((matcher = Pattern.compile("tcp\\(([^:)]+):([^:)]+)\\)").matcher((CharSequence)dsn)).find()) {
                    dsn = matcher.replaceAll(matcher.group(1) + ":" + matcher.group(2));
                }
                dsn = ((String)dsn).replaceAll("postgresql://", "");
                dsn = ((String)dsn).replaceAll("postgres://", "");
                dsn = ((String)dsn).replaceAll("mysql://", "");
                dsn = prefix + "://" + (String)dsn;
                return new Datasource((String)dsn, username, password);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

