/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.runtime;

import java.nio.file.Path;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.logging.Logger;
import xyz.block.ftl.LeaseClient;
import xyz.block.ftl.LeaseFailedException;
import xyz.block.ftl.LeaseHandle;
import xyz.block.ftl.deployment.v1.GetDeploymentContextResponse;
import xyz.block.ftl.runtime.DatasourceDetails;
import xyz.block.ftl.runtime.DefaultRunnerDetails;
import xyz.block.ftl.runtime.DevModeRunnerDetails;
import xyz.block.ftl.runtime.FTLRunnerConnection;
import xyz.block.ftl.runtime.RunnerDetails;

public class FTLController
implements LeaseClient {
    private static final Logger log = Logger.getLogger(FTLController.class);
    final String moduleName;
    private volatile FTLRunnerConnection runnerConnection;
    private static volatile FTLController controller;
    private RunnerDetails runnerDetails = DefaultRunnerDetails.INSTANCE;
    private final Map<String, GetDeploymentContextResponse.DbType> databases = new ConcurrentHashMap<String, GetDeploymentContextResponse.DbType>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FTLController instance() {
        if (controller != null) return controller;
        Class<FTLController> clazz = FTLController.class;
        synchronized (FTLController.class) {
            if (controller != null) return controller;
            controller = new FTLController();
            // ** MonitorExit[var0] (shouldn't be in output)
            return controller;
        }
    }

    FTLController() {
        this.moduleName = System.getProperty("ftl.module.name");
    }

    public void registerDatabase(String name, GetDeploymentContextResponse.DbType type) {
        this.databases.put(name, type);
    }

    public byte[] getSecret(String secretName) {
        return this.getRunnerConnection().getSecret(secretName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FTLRunnerConnection getRunnerConnection() {
        if (this.runnerConnection == null) {
            FTLController fTLController = this;
            synchronized (fTLController) {
                if (this.runnerConnection == null) {
                    this.runnerConnection = new FTLRunnerConnection(this.runnerDetails.getProxyAddress(), this.runnerDetails.getDeploymentKey(), this.moduleName);
                }
            }
        }
        return this.runnerConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForDevModeStart(Path runnerInfo) {
        FTLController fTLController = this;
        synchronized (fTLController) {
            if (this.runnerConnection != null) {
                try {
                    this.runnerConnection.close();
                }
                catch (Exception e) {
                    log.error((Object)"Failed to close runner connection", (Throwable)e);
                }
                this.runnerConnection = null;
            }
            this.runnerDetails.close();
            this.runnerDetails = new DevModeRunnerDetails(runnerInfo);
        }
    }

    public byte[] getConfig(String config) {
        return this.getRunnerConnection().getConfig(config);
    }

    public DatasourceDetails getDatasource(String name) {
        Optional<DatasourceDetails> address;
        GetDeploymentContextResponse.DbType type = this.databases.get(name);
        if (type != null && (address = this.runnerDetails.getDatabase(name, type)).isPresent()) {
            return address.get();
        }
        List<GetDeploymentContextResponse.DSN> databasesList = this.getRunnerConnection().getDeploymentContext().getDatabasesList();
        for (GetDeploymentContextResponse.DSN i : databasesList) {
            if (!i.getName().equals(name)) continue;
            return DatasourceDetails.fromDSN(i.getDsn(), i.getType());
        }
        return null;
    }

    public byte[] callVerb(String name, String module, byte[] payload) {
        return this.getRunnerConnection().callVerb(name, module, payload);
    }

    public void publishEvent(String topic, String callingVerbName, byte[] event, String key) {
        this.getRunnerConnection().publishEvent(topic, callingVerbName, event, key);
    }

    @Override
    public LeaseHandle acquireLease(Duration duration, String ... keys) throws LeaseFailedException {
        return this.getRunnerConnection().acquireLease(duration, keys);
    }

    public void loadDeploymentContext() {
        this.getRunnerConnection().getDeploymentContext();
    }
}

