/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.runtime;

import io.quarkus.dev.spi.HotReplacementContext;
import io.quarkus.dev.spi.HotReplacementSetup;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.jboss.logging.Logger;

public class HotReloadSetup
implements HotReplacementSetup {
    static final Set<Path> existingMigrations = Collections.newSetFromMap(new ConcurrentHashMap());
    static volatile HotReplacementContext context;
    private static volatile String errorOutputPath;
    private static final String ERRORS_OUT = "errors.pb";

    public void setupHotDeployment(HotReplacementContext hrc) {
        context = hrc;
        for (Path dir : context.getSourcesDir()) {
            Path migrations = dir.resolve("db");
            if (!Files.isDirectory(migrations, new LinkOption[0])) continue;
            try {
                Stream<Path> stream = Files.walk(migrations, new FileVisitOption[0]);
                try {
                    stream.forEach(p -> existingMigrations.add((Path)p));
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static void doScan(boolean force) {
        if (context != null) {
            try {
                AtomicBoolean newForce = new AtomicBoolean();
                for (Path dir : context.getSourcesDir()) {
                    Path migrations = dir.resolve("db");
                    if (!Files.isDirectory(migrations, new LinkOption[0])) continue;
                    Stream<Path> stream = Files.walk(migrations, new FileVisitOption[0]);
                    try {
                        stream.forEach(p -> {
                            if (p.getFileName().toString().endsWith(".sql") && existingMigrations.add((Path)p)) {
                                newForce.set(true);
                            }
                        });
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
                context.doScan(force || newForce.get());
            }
            catch (Exception e) {
                Logger.getLogger(HotReloadSetup.class).error((Object)"Failed to scan for changes", (Throwable)e);
            }
        }
    }
}

