/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.runtime;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import xyz.block.ftl.deployment.v1.GetDeploymentContextResponse;
import xyz.block.ftl.runtime.DatasourceDetails;
import xyz.block.ftl.runtime.RunnerDetails;

public class DevModeRunnerDetails
implements RunnerDetails {
    private final Path path;
    private volatile Map<String, String> databases;
    private volatile String proxyAddress;
    private volatile String deployment;
    private volatile boolean closed;
    private static final Pattern dbNames = Pattern.compile("database\\.([a-zA-Z0-9]+).url");
    private volatile boolean loaded = false;

    public DevModeRunnerDetails(Path path) {
        this.path = path;
        this.startWatchThread();
    }

    void startWatchThread() {
        Thread watchThread = new Thread(() -> {
            while (!this.closed) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                if (!Files.exists(this.path, new LinkOption[0])) continue;
                Properties p = new Properties();
                try (InputStream stream = Files.newInputStream(this.path, new OpenOption[0]);){
                    p.load(stream);
                    DevModeRunnerDetails devModeRunnerDetails = this;
                    synchronized (devModeRunnerDetails) {
                        this.proxyAddress = p.getProperty("proxy.bind.address");
                        this.deployment = p.getProperty("deployment");
                        HashMap<String, String> dbs = new HashMap<String, String>();
                        for (String addr : p.stringPropertyNames()) {
                            Matcher m = dbNames.matcher(addr);
                            if (!m.matches()) continue;
                            dbs.put(m.group(1), p.getProperty(addr));
                        }
                        this.databases = dbs;
                        this.loaded = true;
                        this.notifyAll();
                        return;
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        watchThread.setDaemon(true);
        watchThread.start();
    }

    @Override
    public String getProxyAddress() {
        this.waitForLoad();
        if (this.closed) {
            return null;
        }
        return this.proxyAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForLoad() {
        while (this.proxyAddress == null && !this.closed) {
            DevModeRunnerDetails devModeRunnerDetails = this;
            synchronized (devModeRunnerDetails) {
                if (this.proxyAddress == null && !this.closed) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    }

    @Override
    public Optional<DatasourceDetails> getDatabase(String database, GetDeploymentContextResponse.DbType type) {
        this.waitForLoad();
        if (this.closed) {
            return Optional.empty();
        }
        String address = this.databases.get(database);
        if (address == null) {
            return Optional.empty();
        }
        switch (type) {
            case DB_TYPE_POSTGRES: {
                return Optional.of(new DatasourceDetails("jdbc:postgresql://" + address + "/" + database, "ftl", "ftl"));
            }
            case DB_TYPE_MYSQL: {
                return Optional.of(new DatasourceDetails("jdbc:mysql://" + address + "/" + database, "ftl", "ftl"));
            }
        }
        return Optional.empty();
    }

    @Override
    public String getDeploymentKey() {
        this.waitForLoad();
        if (this.closed) {
            return null;
        }
        return this.deployment;
    }

    @Override
    public void close() {
        this.closed = true;
    }
}

