/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.core.parameters.ParameterExtractor;
import xyz.block.ftl.deployment.v1.GetDeploymentContextResponse;
import xyz.block.ftl.runtime.FTLController;
import xyz.block.ftl.runtime.HotReloadSetup;
import xyz.block.ftl.runtime.JsonSerializationConfig;
import xyz.block.ftl.runtime.VerbRegistry;
import xyz.block.ftl.runtime.http.FTLHttpHandler;
import xyz.block.ftl.runtime.http.HTTPVerbInvoker;
import xyz.block.ftl.v1.CallRequest;

@Recorder
public class FTLRecorder {
    public static final String X_FTL_VERB = "X-ftl-verb";
    public static final String DEV_MODE_RUNNER_INFO_PATH = "ftl.dev.runner.info";

    public void registerVerb(String module, String verbName, String methodName, List<Class<?>> parameterTypes, Class<?> verbHandlerClass, List<VerbRegistry.ParameterSupplier> paramMappers, boolean allowNullReturn) {
        try {
            Method method = verbHandlerClass.getDeclaredMethod(methodName, parameterTypes.toArray(new Class[0]));
            method.setAccessible(true);
            InstanceHandle handlerInstance = Arc.container().instance(verbHandlerClass, new Annotation[0]);
            ((VerbRegistry)Arc.container().instance(VerbRegistry.class, new Annotation[0]).get()).register(module, verbName, handlerInstance, method, paramMappers, allowNullReturn);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void registerHttpIngress(String module, String verbName, boolean base64Encoded) {
        try {
            FTLHttpHandler ftlHttpHandler = (FTLHttpHandler)Arc.container().instance(FTLHttpHandler.class, new Annotation[0]).get();
            VerbRegistry verbRegistry = (VerbRegistry)Arc.container().instance(VerbRegistry.class, new Annotation[0]).get();
            verbRegistry.register(module, verbName, new HTTPVerbInvoker(base64Encoded, ftlHttpHandler));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void registerEnum(Class<?> ennum) {
        try {
            ((JsonSerializationConfig)Arc.container().instance(JsonSerializationConfig.class, new Annotation[0]).get()).registerValueEnum(ennum);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void registerEnum(Class<?> ennum, List<Class<?>> variants) {
        try {
            ((JsonSerializationConfig)Arc.container().instance(JsonSerializationConfig.class, new Annotation[0]).get()).registerTypeEnum(ennum, variants);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public VerbRegistry.ParameterSupplier topicSupplier(String className, String callingVerb) {
        try {
            Class<?> cls = Thread.currentThread().getContextClassLoader().loadClass(className.replace("/", "."));
            final Object topic = cls.getDeclaredConstructor(String.class).newInstance(callingVerb);
            return new VerbRegistry.ParameterSupplier(){

                @Override
                public Object apply(ObjectMapper mapper, CallRequest callRequest) {
                    return topic;
                }
            };
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public VerbRegistry.ParameterSupplier verbClientSupplier(String className) {
        try {
            Class<?> cls = Thread.currentThread().getContextClassLoader().loadClass(className.replace("/", "."));
            final Object client = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return new VerbRegistry.ParameterSupplier(){

                @Override
                public Object apply(ObjectMapper mapper, CallRequest callRequest) {
                    return client;
                }
            };
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public VerbRegistry.ParameterSupplier leaseClientSupplier() {
        return new VerbRegistry.ParameterSupplier(){

            @Override
            public Object apply(ObjectMapper mapper, CallRequest callRequest) {
                return FTLController.instance();
            }
        };
    }

    public ParameterExtractor topicParamExtractor(String className) {
        try {
            Class<?> cls = Thread.currentThread().getContextClassLoader().loadClass(className.replace("/", "."));
            final Constructor<?> ctor = cls.getDeclaredConstructor(String.class);
            return new ParameterExtractor(){

                public Object extractParameter(ResteasyReactiveRequestContext context) {
                    try {
                        Object topic = ctor.newInstance(context.getHeader(FTLRecorder.X_FTL_VERB, true));
                        return topic;
                    }
                    catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ParameterExtractor verbParamExtractor(String className) {
        try {
            Class<?> cls = Thread.currentThread().getContextClassLoader().loadClass(className.replace("/", "."));
            final Object client = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return new ParameterExtractor(){

                public Object extractParameter(ResteasyReactiveRequestContext context) {
                    return client;
                }
            };
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ParameterExtractor leaseClientExtractor() {
        try {
            return new ParameterExtractor(){

                public Object extractParameter(ResteasyReactiveRequestContext context) {
                    return FTLController.instance();
                }
            };
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void startReloadTimer(ShutdownContext shutdownContext) {
        final Timer t = new Timer("FTL Hot Reload Timer", true);
        t.schedule(new TimerTask(){

            @Override
            public void run() {
                HotReloadSetup.doScan(false);
            }
        }, 1000L, 1000L);
        shutdownContext.addShutdownTask(new Runnable(){

            @Override
            public void run() {
                t.cancel();
            }
        });
    }

    public void registerDatabase(String dbKind, GetDeploymentContextResponse.DbType name) {
        FTLController.instance().registerDatabase(dbKind, name);
    }

    public void handleDevModeRunnerStart(ShutdownContext shutdownContext) {
        FTLController.instance().readDevModeRunnerInfo();
        shutdownContext.addShutdownTask(new Runnable(){

            @Override
            public void run() {
                FTLController.instance().devModeShutdown();
            }
        });
    }

    public void loadModuleContextOnStartup() {
        FTLController.instance().loadDeploymentContext();
    }
}

