/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.runtime;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.arc.Arc;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import xyz.block.ftl.TopicPartitionMapper;
import xyz.block.ftl.runtime.FTLController;

@Singleton
public class TopicHelper {
    final ObjectMapper mapper;

    public TopicHelper(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public void publish(String topic, String verb, Object message, Class<? extends TopicPartitionMapper<Object>> partitionMapperType) {
        try {
            TopicPartitionMapper partitionMapper = (TopicPartitionMapper)Arc.container().instance(partitionMapperType, new Annotation[0]).get();
            String key = partitionMapper.getPartitionKey(message);
            FTLController.instance().publishEvent(topic, verb, this.mapper.writeValueAsBytes(message), key);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static TopicHelper instance() {
        return (TopicHelper)Arc.container().instance(TopicHelper.class, new Annotation[0]).get();
    }
}

