/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.runtime;

import com.google.protobuf.ByteString;
import com.google.protobuf.Duration;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ConnectivityState;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.stub.StreamObserver;
import java.io.Closeable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.logging.Logger;
import xyz.block.ftl.LeaseFailedException;
import xyz.block.ftl.LeaseHandle;
import xyz.block.ftl.deployment.v1.DeploymentServiceGrpc;
import xyz.block.ftl.deployment.v1.GetDeploymentContextRequest;
import xyz.block.ftl.deployment.v1.GetDeploymentContextResponse;
import xyz.block.ftl.lease.v1.AcquireLeaseRequest;
import xyz.block.ftl.lease.v1.AcquireLeaseResponse;
import xyz.block.ftl.lease.v1.LeaseServiceGrpc;
import xyz.block.ftl.pubsub.v1.PublishEventRequest;
import xyz.block.ftl.pubsub.v1.PublishEventResponse;
import xyz.block.ftl.pubsub.v1.PublishServiceGrpc;
import xyz.block.ftl.runtime.CurrentRequestClientInterceptor;
import xyz.block.ftl.schema.v1.Ref;
import xyz.block.ftl.v1.CallRequest;
import xyz.block.ftl.v1.CallResponse;
import xyz.block.ftl.v1.VerbServiceGrpc;

class FTLRunnerConnection
implements Closeable {
    private static final Logger log = Logger.getLogger(FTLRunnerConnection.class);
    final String moduleName;
    final String deploymentName;
    private final ManagedChannel channel;
    private final String endpoint;
    private Throwable currentError;
    private volatile GetDeploymentContextResponse moduleContextResponse;
    private boolean waiters = false;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final Runnable closeHandler;
    final VerbServiceGrpc.VerbServiceStub verbService;
    final DeploymentServiceGrpc.DeploymentServiceStub deploymentService;
    final LeaseServiceGrpc.LeaseServiceStub leaseService;
    final PublishServiceGrpc.PublishServiceStub publishService;
    final StreamObserver<GetDeploymentContextResponse> moduleObserver = new ModuleObserver();

    FTLRunnerConnection(String endpoint, String deploymentName, String moduleName, Runnable closeHandler) {
        URI uri = URI.create(endpoint);
        this.closeHandler = closeHandler;
        this.moduleName = moduleName;
        ManagedChannelBuilder channelBuilder = ManagedChannelBuilder.forAddress((String)uri.getHost(), (int)uri.getPort());
        if (uri.getScheme().equals("http")) {
            channelBuilder.usePlaintext();
        }
        this.channel = channelBuilder.build();
        this.channel.notifyWhenStateChanged(ConnectivityState.READY, () -> {
            if ((this.channel.isShutdown() || this.channel.isTerminated()) && this.closed.compareAndSet(false, true)) {
                log.debug((Object)"Channel state changed to SHUTDOWN, closing connection");
                this.channel.shutdown();
                closeHandler.run();
            }
        });
        this.deploymentName = deploymentName;
        this.deploymentService = DeploymentServiceGrpc.newStub((Channel)this.channel);
        this.deploymentService.getDeploymentContext(GetDeploymentContextRequest.newBuilder().setDeployment(deploymentName).build(), this.moduleObserver);
        this.verbService = (VerbServiceGrpc.VerbServiceStub)VerbServiceGrpc.newStub((Channel)this.channel).withInterceptors(new ClientInterceptor[]{new CurrentRequestClientInterceptor()});
        this.publishService = (PublishServiceGrpc.PublishServiceStub)PublishServiceGrpc.newStub((Channel)this.channel).withInterceptors(new ClientInterceptor[]{new CurrentRequestClientInterceptor()});
        this.leaseService = (LeaseServiceGrpc.LeaseServiceStub)LeaseServiceGrpc.newStub((Channel)this.channel).withInterceptors(new ClientInterceptor[]{new CurrentRequestClientInterceptor()});
        this.endpoint = endpoint;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    byte[] getSecret(String secretName) {
        GetDeploymentContextResponse context = this.getDeploymentContext();
        if (context.containsSecrets(secretName)) {
            return context.getSecretsMap().get(secretName).toByteArray();
        }
        throw new RuntimeException("Secret not found: " + secretName);
    }

    byte[] getConfig(String secretName) {
        GetDeploymentContextResponse context = this.getDeploymentContext();
        if (context.containsConfigs(secretName)) {
            return context.getConfigsMap().get(secretName).toByteArray();
        }
        throw new RuntimeException("Config not found: " + secretName);
    }

    byte[] callVerb(String name, String module, byte[] payload) {
        final CompletableFuture cf = new CompletableFuture();
        this.verbService.call(CallRequest.newBuilder().setVerb(Ref.newBuilder().setModule(module).setName(name)).setBody(ByteString.copyFrom((byte[])payload)).build(), new StreamObserver<CallResponse>(){

            public void onNext(CallResponse callResponse) {
                if (callResponse.hasError()) {
                    cf.completeExceptionally(new RuntimeException(callResponse.getError().getMessage()));
                } else {
                    cf.complete(callResponse.getBody().toByteArray());
                }
            }

            public void onError(Throwable throwable) {
                cf.completeExceptionally(throwable);
            }

            public void onCompleted() {
            }
        });
        try {
            return (byte[])cf.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    void publishEvent(String topic, String callingVerbName, byte[] event, String key) {
        final CompletableFuture cf = new CompletableFuture();
        this.publishService.publishEvent(PublishEventRequest.newBuilder().setCaller(callingVerbName).setBody(ByteString.copyFrom((byte[])event)).setTopic(Ref.newBuilder().setModule(this.moduleName).setName(topic).build()).setKey(key).build(), new StreamObserver<PublishEventResponse>(){

            public void onNext(PublishEventResponse publishEventResponse) {
                cf.complete(null);
            }

            public void onError(Throwable throwable) {
                cf.completeExceptionally(throwable);
            }

            public void onCompleted() {
                cf.complete(null);
            }
        });
        try {
            cf.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public LeaseHandle acquireLease(java.time.Duration duration, String ... keys) throws LeaseFailedException {
        final CompletableFuture cf = new CompletableFuture();
        final StreamObserver<AcquireLeaseRequest> client = this.leaseService.acquireLease(new StreamObserver<AcquireLeaseResponse>(){

            public void onNext(AcquireLeaseResponse value) {
                cf.complete(null);
            }

            public void onError(Throwable t) {
                cf.completeExceptionally(t);
            }

            public void onCompleted() {
                if (!cf.isDone()) {
                    this.onError(new RuntimeException("stream closed"));
                }
            }
        });
        ArrayList<String> realKeys = new ArrayList<String>();
        realKeys.add("module");
        realKeys.add(this.moduleName);
        realKeys.addAll(Arrays.asList(keys));
        client.onNext((Object)AcquireLeaseRequest.newBuilder().addAllKey(realKeys).setTtl(Duration.newBuilder().setSeconds(duration.toSeconds())).build());
        try {
            cf.get();
        }
        catch (Exception e) {
            throw new LeaseFailedException("lease already held", e);
        }
        return new LeaseHandle(){

            @Override
            public void close() {
                client.onCompleted();
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    GetDeploymentContextResponse getDeploymentContext() {
        GetDeploymentContextResponse moduleContext = this.moduleContextResponse;
        if (moduleContext != null) {
            return moduleContext;
        }
        StreamObserver<GetDeploymentContextResponse> streamObserver = this.moduleObserver;
        synchronized (streamObserver) {
            while ((moduleContext = this.moduleContextResponse) == null) {
                if (this.currentError != null) {
                    throw new RuntimeException(this.currentError);
                }
                this.waiters = true;
                try {
                    this.moduleObserver.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            return moduleContext;
        }
    }

    @Override
    public void close() {
        this.channel.shutdown();
    }

    private class ModuleObserver
    implements StreamObserver<GetDeploymentContextResponse> {
        final AtomicInteger failCount = new AtomicInteger();

        private ModuleObserver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(GetDeploymentContextResponse moduleContextResponse) {
            ModuleObserver moduleObserver = this;
            synchronized (moduleObserver) {
                FTLRunnerConnection.this.currentError = null;
                FTLRunnerConnection.this.moduleContextResponse = moduleContextResponse;
                if (FTLRunnerConnection.this.waiters) {
                    this.notifyAll();
                    FTLRunnerConnection.this.waiters = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onError(Throwable throwable) {
            log.debug((Object)"GRPC connection error", throwable);
            ModuleObserver moduleObserver = this;
            synchronized (moduleObserver) {
                FTLRunnerConnection.this.currentError = throwable;
                if (FTLRunnerConnection.this.waiters) {
                    this.notifyAll();
                    FTLRunnerConnection.this.waiters = false;
                }
            }
            if (this.failCount.incrementAndGet() < 5) {
                FTLRunnerConnection.this.deploymentService.getDeploymentContext(GetDeploymentContextRequest.newBuilder().setDeployment(FTLRunnerConnection.this.deploymentName).build(), FTLRunnerConnection.this.moduleObserver);
            }
        }

        public void onCompleted() {
            this.onError(new RuntimeException("connection closed"));
        }
    }
}

