/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.runtime;

import java.util.Map;
import java.util.Optional;
import xyz.block.ftl.hotreload.RunnerInfo;
import xyz.block.ftl.hotreload.RunnerNotification;
import xyz.block.ftl.runtime.DatasourceDetails;
import xyz.block.ftl.runtime.RunnerDetails;
import xyz.block.ftl.v1.GetDeploymentContextResponse;

public class DevModeRunnerDetails
implements RunnerDetails {
    private volatile Map<String, String> databases;
    private volatile String proxyAddress;
    private volatile String deployment;
    private volatile boolean closed;

    public DevModeRunnerDetails() {
        RunnerNotification.setCallback(this::setRunnerInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRunnerInfo(RunnerInfo runnerInfo) {
        DevModeRunnerDetails devModeRunnerDetails = this;
        synchronized (devModeRunnerDetails) {
            this.proxyAddress = runnerInfo.address();
            this.deployment = runnerInfo.deployment();
            this.databases = runnerInfo.databases();
            this.notifyAll();
        }
    }

    @Override
    public String getProxyAddress() {
        this.waitForLoad();
        if (this.closed) {
            return null;
        }
        return this.proxyAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForLoad() {
        while (this.proxyAddress == null && !this.closed) {
            DevModeRunnerDetails devModeRunnerDetails = this;
            synchronized (devModeRunnerDetails) {
                if (this.proxyAddress == null && !this.closed) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    }

    @Override
    public Optional<DatasourceDetails> getDatabase(String database, GetDeploymentContextResponse.DbType type) {
        this.waitForLoad();
        if (this.closed) {
            return Optional.empty();
        }
        String address = this.databases.get(database);
        if (address == null) {
            return Optional.empty();
        }
        switch (type) {
            case DB_TYPE_POSTGRES: {
                return Optional.of(new DatasourceDetails("jdbc:postgresql://" + address + "/" + database, "ftl", "ftl"));
            }
            case DB_TYPE_MYSQL: {
                return Optional.of(new DatasourceDetails("jdbc:mysql://" + address + "/" + database, "ftl", "ftl"));
            }
        }
        return Optional.empty();
    }

    @Override
    public String getDeploymentKey() {
        this.waitForLoad();
        if (this.closed) {
            return null;
        }
        return this.deployment;
    }

    @Override
    public void close() {
        this.closed = true;
    }
}

