/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.runtime;

import io.quarkus.runtime.LaunchMode;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.logging.Logger;
import xyz.block.ftl.LeaseClient;
import xyz.block.ftl.LeaseFailedException;
import xyz.block.ftl.LeaseHandle;
import xyz.block.ftl.hotreload.RunnerInfo;
import xyz.block.ftl.hotreload.RunnerNotification;
import xyz.block.ftl.runtime.DatasourceDetails;
import xyz.block.ftl.runtime.DefaultRunnerDetails;
import xyz.block.ftl.runtime.DevModeRunnerDetails;
import xyz.block.ftl.runtime.FTLRunnerConnection;
import xyz.block.ftl.runtime.GitVersion;
import xyz.block.ftl.runtime.RunnerDetails;
import xyz.block.ftl.v1.GetDeploymentContextResponse;

public class FTLController
implements LeaseClient,
RunnerNotification.RunnerCallback {
    private static final Logger log = Logger.getLogger(FTLController.class);
    public static final RuntimeException RESTART_EXCEPTION = new RuntimeException("Failed to get runner details due to restart");
    private final List<AtomicBoolean> waiters = new ArrayList<AtomicBoolean>();
    final String moduleName;
    private static volatile FTLController controller;
    private volatile FTLRunnerConnection runnerConnection;
    private volatile RunnerDetails runnerDetails;
    private final Map<String, GetDeploymentContextResponse.DbType> databases = new ConcurrentHashMap<String, GetDeploymentContextResponse.DbType>();
    private long runnerVersion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FTLController instance() {
        if (controller != null) return controller;
        Class<FTLController> clazz = FTLController.class;
        synchronized (FTLController.class) {
            if (controller != null) return controller;
            GitVersion.logVersion();
            controller = new FTLController();
            // ** MonitorExit[var0] (shouldn't be in output)
            return controller;
        }
    }

    FTLController() {
        this.moduleName = System.getProperty("ftl.module.name");
        if (LaunchMode.current() != LaunchMode.DEVELOPMENT) {
            this.runnerDetails = DefaultRunnerDetails.INSTANCE;
        } else {
            RunnerNotification.setCallback((RunnerNotification.RunnerCallback)this);
        }
    }

    public void registerDatabase(String name, GetDeploymentContextResponse.DbType type) {
        this.databases.put(name, type);
    }

    public byte[] getSecret(String secretName) {
        return this.getRunnerConnection().getSecret(secretName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FTLRunnerConnection getRunnerConnection() {
        FTLRunnerConnection rc = this.runnerConnection;
        if (rc == null) {
            FTLController fTLController = this;
            synchronized (fTLController) {
                if (this.runnerConnection != null) {
                    return this.runnerConnection;
                }
                if (this.runnerDetails == null) {
                    this.waitForRunner();
                    if (this.runnerDetails == null) {
                        throw RESTART_EXCEPTION;
                    }
                }
                this.runnerConnection = new FTLRunnerConnection(this.runnerDetails.getProxyAddress(), this.runnerDetails.getDeploymentKey(), this.moduleName, new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        FTLController fTLController = FTLController.this;
                        synchronized (fTLController) {
                            FTLController.this.runnerConnection = null;
                        }
                    }
                });
                return this.runnerConnection;
            }
        }
        return rc;
    }

    public byte[] getConfig(String config) {
        return this.getRunnerConnection().getConfig(config);
    }

    public DatasourceDetails getDatasource(String name) {
        Optional<DatasourceDetails> address;
        GetDeploymentContextResponse.DbType type = this.databases.get(name);
        if (type != null && (address = this.runnerDetails.getDatabase(name, type)).isPresent()) {
            return address.get();
        }
        List<GetDeploymentContextResponse.DSN> databasesList = this.getRunnerConnection().getDeploymentContext().getDatabasesList();
        for (GetDeploymentContextResponse.DSN i : databasesList) {
            if (!i.getName().equals(name)) continue;
            return DatasourceDetails.fromDSN(i.getDsn(), i.getType());
        }
        return null;
    }

    public byte[] callVerb(String name, String module, byte[] payload) {
        return this.getRunnerConnection().callVerb(name, module, payload);
    }

    public void publishEvent(String topic, String callingVerbName, byte[] event, String key) {
        this.getRunnerConnection().publishEvent(topic, callingVerbName, event, key);
    }

    @Override
    public LeaseHandle acquireLease(Duration duration, String ... keys) throws LeaseFailedException {
        return this.getRunnerConnection().acquireLease(duration, keys);
    }

    public void loadDeploymentContext() {
        this.getRunnerConnection().getDeploymentContext();
    }

    public synchronized void runnerDetails(RunnerInfo info) {
        if (info.version() != this.runnerVersion) {
            return;
        }
        if (this.runnerConnection != null) {
            this.runnerConnection.close();
            this.runnerConnection = null;
        }
        this.runnerDetails = new DevModeRunnerDetails(info.databases(), info.address(), info.deployment());
        for (AtomicBoolean waiter : this.waiters) {
            waiter.set(true);
        }
        this.waiters.clear();
        this.notifyAll();
    }

    public synchronized void reloadStarted() {
        for (AtomicBoolean waiter : this.waiters) {
            waiter.set(true);
        }
        this.waiters.clear();
        this.notifyAll();
    }

    public synchronized void newRunnerVersion(long version) {
        this.runnerVersion = version;
        if (this.runnerConnection != null) {
            this.runnerConnection.close();
            this.runnerConnection = null;
        }
        this.runnerDetails = null;
    }

    private synchronized void waitForRunner() {
        if (this.runnerDetails != null) {
            return;
        }
        AtomicBoolean gate = new AtomicBoolean();
        this.waiters.add(gate);
        while (!gate.get()) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
    }
}

