/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.runtime;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.arc.Arc;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.Map;
import xyz.block.ftl.runtime.FTLController;

@Singleton
public class VerbClientHelper {
    final ObjectMapper mapper;

    public VerbClientHelper(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public Object call(String verb, String module, Object message, Class<?> returnType, boolean listReturnType, boolean mapReturnType) {
        try {
            byte[] result;
            if (message == null) {
                message = Map.of();
            }
            if ((result = FTLController.instance().callVerb(verb, module, this.mapper.writeValueAsBytes(message))) == null) {
                return null;
            }
            if (listReturnType) {
                return this.mapper.readerForArrayOf(returnType).readValue(result);
            }
            if (mapReturnType) {
                return this.mapper.readerForMapOf(returnType).readValue(result);
            }
            if (returnType == JsonNode.class) {
                return this.mapper.readTree(result);
            }
            return this.mapper.readerFor(returnType).readValue(result);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static VerbClientHelper instance() {
        return (VerbClientHelper)Arc.container().instance(VerbClientHelper.class, new Annotation[0]).get();
    }
}

