package xyz.block.ftl.hotreload.v1;

import static io.grpc.MethodDescriptor.generateFullMethodName;

/**
 * <pre>
 * HotReloadService is for communication between a language plugin a language runtime that can perform a hot reload
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.65.1)",
    comments = "Source: xyz/block/ftl/hotreload/v1/hotreload.proto")
@io.grpc.stub.annotations.GrpcGenerated
public final class HotReloadServiceGrpc {

  private HotReloadServiceGrpc() {}

  public static final java.lang.String SERVICE_NAME = "xyz.block.ftl.hotreload.v1.HotReloadService";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<xyz.block.ftl.v1.PingRequest,
      xyz.block.ftl.v1.PingResponse> getPingMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Ping",
      requestType = xyz.block.ftl.v1.PingRequest.class,
      responseType = xyz.block.ftl.v1.PingResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<xyz.block.ftl.v1.PingRequest,
      xyz.block.ftl.v1.PingResponse> getPingMethod() {
    io.grpc.MethodDescriptor<xyz.block.ftl.v1.PingRequest, xyz.block.ftl.v1.PingResponse> getPingMethod;
    if ((getPingMethod = HotReloadServiceGrpc.getPingMethod) == null) {
      synchronized (HotReloadServiceGrpc.class) {
        if ((getPingMethod = HotReloadServiceGrpc.getPingMethod) == null) {
          HotReloadServiceGrpc.getPingMethod = getPingMethod =
              io.grpc.MethodDescriptor.<xyz.block.ftl.v1.PingRequest, xyz.block.ftl.v1.PingResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "Ping"))
              .setSafe(true)
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  xyz.block.ftl.v1.PingRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  xyz.block.ftl.v1.PingResponse.getDefaultInstance()))
              .setSchemaDescriptor(new HotReloadServiceMethodDescriptorSupplier("Ping"))
              .build();
        }
      }
    }
    return getPingMethod;
  }

  private static volatile io.grpc.MethodDescriptor<xyz.block.ftl.hotreload.v1.ReloadRequest,
      xyz.block.ftl.hotreload.v1.ReloadResponse> getReloadMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Reload",
      requestType = xyz.block.ftl.hotreload.v1.ReloadRequest.class,
      responseType = xyz.block.ftl.hotreload.v1.ReloadResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<xyz.block.ftl.hotreload.v1.ReloadRequest,
      xyz.block.ftl.hotreload.v1.ReloadResponse> getReloadMethod() {
    io.grpc.MethodDescriptor<xyz.block.ftl.hotreload.v1.ReloadRequest, xyz.block.ftl.hotreload.v1.ReloadResponse> getReloadMethod;
    if ((getReloadMethod = HotReloadServiceGrpc.getReloadMethod) == null) {
      synchronized (HotReloadServiceGrpc.class) {
        if ((getReloadMethod = HotReloadServiceGrpc.getReloadMethod) == null) {
          HotReloadServiceGrpc.getReloadMethod = getReloadMethod =
              io.grpc.MethodDescriptor.<xyz.block.ftl.hotreload.v1.ReloadRequest, xyz.block.ftl.hotreload.v1.ReloadResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "Reload"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  xyz.block.ftl.hotreload.v1.ReloadRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  xyz.block.ftl.hotreload.v1.ReloadResponse.getDefaultInstance()))
              .setSchemaDescriptor(new HotReloadServiceMethodDescriptorSupplier("Reload"))
              .build();
        }
      }
    }
    return getReloadMethod;
  }

  private static volatile io.grpc.MethodDescriptor<xyz.block.ftl.hotreload.v1.WatchRequest,
      xyz.block.ftl.hotreload.v1.WatchResponse> getWatchMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Watch",
      requestType = xyz.block.ftl.hotreload.v1.WatchRequest.class,
      responseType = xyz.block.ftl.hotreload.v1.WatchResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
  public static io.grpc.MethodDescriptor<xyz.block.ftl.hotreload.v1.WatchRequest,
      xyz.block.ftl.hotreload.v1.WatchResponse> getWatchMethod() {
    io.grpc.MethodDescriptor<xyz.block.ftl.hotreload.v1.WatchRequest, xyz.block.ftl.hotreload.v1.WatchResponse> getWatchMethod;
    if ((getWatchMethod = HotReloadServiceGrpc.getWatchMethod) == null) {
      synchronized (HotReloadServiceGrpc.class) {
        if ((getWatchMethod = HotReloadServiceGrpc.getWatchMethod) == null) {
          HotReloadServiceGrpc.getWatchMethod = getWatchMethod =
              io.grpc.MethodDescriptor.<xyz.block.ftl.hotreload.v1.WatchRequest, xyz.block.ftl.hotreload.v1.WatchResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "Watch"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  xyz.block.ftl.hotreload.v1.WatchRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  xyz.block.ftl.hotreload.v1.WatchResponse.getDefaultInstance()))
              .setSchemaDescriptor(new HotReloadServiceMethodDescriptorSupplier("Watch"))
              .build();
        }
      }
    }
    return getWatchMethod;
  }

  private static volatile io.grpc.MethodDescriptor<xyz.block.ftl.hotreload.v1.RunnerInfoRequest,
      xyz.block.ftl.hotreload.v1.RunnerInfoResponse> getRunnerInfoMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "RunnerInfo",
      requestType = xyz.block.ftl.hotreload.v1.RunnerInfoRequest.class,
      responseType = xyz.block.ftl.hotreload.v1.RunnerInfoResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<xyz.block.ftl.hotreload.v1.RunnerInfoRequest,
      xyz.block.ftl.hotreload.v1.RunnerInfoResponse> getRunnerInfoMethod() {
    io.grpc.MethodDescriptor<xyz.block.ftl.hotreload.v1.RunnerInfoRequest, xyz.block.ftl.hotreload.v1.RunnerInfoResponse> getRunnerInfoMethod;
    if ((getRunnerInfoMethod = HotReloadServiceGrpc.getRunnerInfoMethod) == null) {
      synchronized (HotReloadServiceGrpc.class) {
        if ((getRunnerInfoMethod = HotReloadServiceGrpc.getRunnerInfoMethod) == null) {
          HotReloadServiceGrpc.getRunnerInfoMethod = getRunnerInfoMethod =
              io.grpc.MethodDescriptor.<xyz.block.ftl.hotreload.v1.RunnerInfoRequest, xyz.block.ftl.hotreload.v1.RunnerInfoResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "RunnerInfo"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  xyz.block.ftl.hotreload.v1.RunnerInfoRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  xyz.block.ftl.hotreload.v1.RunnerInfoResponse.getDefaultInstance()))
              .setSchemaDescriptor(new HotReloadServiceMethodDescriptorSupplier("RunnerInfo"))
              .build();
        }
      }
    }
    return getRunnerInfoMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static HotReloadServiceStub newStub(io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<HotReloadServiceStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<HotReloadServiceStub>() {
        @java.lang.Override
        public HotReloadServiceStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new HotReloadServiceStub(channel, callOptions);
        }
      };
    return HotReloadServiceStub.newStub(factory, channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static HotReloadServiceBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<HotReloadServiceBlockingStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<HotReloadServiceBlockingStub>() {
        @java.lang.Override
        public HotReloadServiceBlockingStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new HotReloadServiceBlockingStub(channel, callOptions);
        }
      };
    return HotReloadServiceBlockingStub.newStub(factory, channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static HotReloadServiceFutureStub newFutureStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<HotReloadServiceFutureStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<HotReloadServiceFutureStub>() {
        @java.lang.Override
        public HotReloadServiceFutureStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new HotReloadServiceFutureStub(channel, callOptions);
        }
      };
    return HotReloadServiceFutureStub.newStub(factory, channel);
  }

  /**
   * <pre>
   * HotReloadService is for communication between a language plugin a language runtime that can perform a hot reload
   * </pre>
   */
  public interface AsyncService {

    /**
     * <pre>
     * Ping service for readiness.
     * </pre>
     */
    default void ping(xyz.block.ftl.v1.PingRequest request,
        io.grpc.stub.StreamObserver<xyz.block.ftl.v1.PingResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getPingMethod(), responseObserver);
    }

    /**
     * <pre>
     * Forces an explicit Reload from the plugin. This is useful for when the plugin needs to trigger a Reload,
     * such as when the Reload context changes.
     * </pre>
     */
    default void reload(xyz.block.ftl.hotreload.v1.ReloadRequest request,
        io.grpc.stub.StreamObserver<xyz.block.ftl.hotreload.v1.ReloadResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getReloadMethod(), responseObserver);
    }

    /**
     * <pre>
     * Watch for hot reloads not initiated by an explicit Reload call.
     * </pre>
     */
    default void watch(xyz.block.ftl.hotreload.v1.WatchRequest request,
        io.grpc.stub.StreamObserver<xyz.block.ftl.hotreload.v1.WatchResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getWatchMethod(), responseObserver);
    }

    /**
     * <pre>
     * Invoked by the runner to provide runner information to the plugin.
     * </pre>
     */
    default void runnerInfo(xyz.block.ftl.hotreload.v1.RunnerInfoRequest request,
        io.grpc.stub.StreamObserver<xyz.block.ftl.hotreload.v1.RunnerInfoResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getRunnerInfoMethod(), responseObserver);
    }
  }

  /**
   * Base class for the server implementation of the service HotReloadService.
   * <pre>
   * HotReloadService is for communication between a language plugin a language runtime that can perform a hot reload
   * </pre>
   */
  public static abstract class HotReloadServiceImplBase
      implements io.grpc.BindableService, AsyncService {

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return HotReloadServiceGrpc.bindService(this);
    }
  }

  /**
   * A stub to allow clients to do asynchronous rpc calls to service HotReloadService.
   * <pre>
   * HotReloadService is for communication between a language plugin a language runtime that can perform a hot reload
   * </pre>
   */
  public static final class HotReloadServiceStub
      extends io.grpc.stub.AbstractAsyncStub<HotReloadServiceStub> {
    private HotReloadServiceStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected HotReloadServiceStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new HotReloadServiceStub(channel, callOptions);
    }

    /**
     * <pre>
     * Ping service for readiness.
     * </pre>
     */
    public void ping(xyz.block.ftl.v1.PingRequest request,
        io.grpc.stub.StreamObserver<xyz.block.ftl.v1.PingResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getPingMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Forces an explicit Reload from the plugin. This is useful for when the plugin needs to trigger a Reload,
     * such as when the Reload context changes.
     * </pre>
     */
    public void reload(xyz.block.ftl.hotreload.v1.ReloadRequest request,
        io.grpc.stub.StreamObserver<xyz.block.ftl.hotreload.v1.ReloadResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getReloadMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Watch for hot reloads not initiated by an explicit Reload call.
     * </pre>
     */
    public void watch(xyz.block.ftl.hotreload.v1.WatchRequest request,
        io.grpc.stub.StreamObserver<xyz.block.ftl.hotreload.v1.WatchResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncServerStreamingCall(
          getChannel().newCall(getWatchMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Invoked by the runner to provide runner information to the plugin.
     * </pre>
     */
    public void runnerInfo(xyz.block.ftl.hotreload.v1.RunnerInfoRequest request,
        io.grpc.stub.StreamObserver<xyz.block.ftl.hotreload.v1.RunnerInfoResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getRunnerInfoMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * A stub to allow clients to do synchronous rpc calls to service HotReloadService.
   * <pre>
   * HotReloadService is for communication between a language plugin a language runtime that can perform a hot reload
   * </pre>
   */
  public static final class HotReloadServiceBlockingStub
      extends io.grpc.stub.AbstractBlockingStub<HotReloadServiceBlockingStub> {
    private HotReloadServiceBlockingStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected HotReloadServiceBlockingStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new HotReloadServiceBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * Ping service for readiness.
     * </pre>
     */
    public xyz.block.ftl.v1.PingResponse ping(xyz.block.ftl.v1.PingRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getPingMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Forces an explicit Reload from the plugin. This is useful for when the plugin needs to trigger a Reload,
     * such as when the Reload context changes.
     * </pre>
     */
    public xyz.block.ftl.hotreload.v1.ReloadResponse reload(xyz.block.ftl.hotreload.v1.ReloadRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getReloadMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Watch for hot reloads not initiated by an explicit Reload call.
     * </pre>
     */
    public java.util.Iterator<xyz.block.ftl.hotreload.v1.WatchResponse> watch(
        xyz.block.ftl.hotreload.v1.WatchRequest request) {
      return io.grpc.stub.ClientCalls.blockingServerStreamingCall(
          getChannel(), getWatchMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Invoked by the runner to provide runner information to the plugin.
     * </pre>
     */
    public xyz.block.ftl.hotreload.v1.RunnerInfoResponse runnerInfo(xyz.block.ftl.hotreload.v1.RunnerInfoRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getRunnerInfoMethod(), getCallOptions(), request);
    }
  }

  /**
   * A stub to allow clients to do ListenableFuture-style rpc calls to service HotReloadService.
   * <pre>
   * HotReloadService is for communication between a language plugin a language runtime that can perform a hot reload
   * </pre>
   */
  public static final class HotReloadServiceFutureStub
      extends io.grpc.stub.AbstractFutureStub<HotReloadServiceFutureStub> {
    private HotReloadServiceFutureStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected HotReloadServiceFutureStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new HotReloadServiceFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * Ping service for readiness.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<xyz.block.ftl.v1.PingResponse> ping(
        xyz.block.ftl.v1.PingRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getPingMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Forces an explicit Reload from the plugin. This is useful for when the plugin needs to trigger a Reload,
     * such as when the Reload context changes.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<xyz.block.ftl.hotreload.v1.ReloadResponse> reload(
        xyz.block.ftl.hotreload.v1.ReloadRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getReloadMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Invoked by the runner to provide runner information to the plugin.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<xyz.block.ftl.hotreload.v1.RunnerInfoResponse> runnerInfo(
        xyz.block.ftl.hotreload.v1.RunnerInfoRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getRunnerInfoMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_PING = 0;
  private static final int METHODID_RELOAD = 1;
  private static final int METHODID_WATCH = 2;
  private static final int METHODID_RUNNER_INFO = 3;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final AsyncService serviceImpl;
    private final int methodId;

    MethodHandlers(AsyncService serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_PING:
          serviceImpl.ping((xyz.block.ftl.v1.PingRequest) request,
              (io.grpc.stub.StreamObserver<xyz.block.ftl.v1.PingResponse>) responseObserver);
          break;
        case METHODID_RELOAD:
          serviceImpl.reload((xyz.block.ftl.hotreload.v1.ReloadRequest) request,
              (io.grpc.stub.StreamObserver<xyz.block.ftl.hotreload.v1.ReloadResponse>) responseObserver);
          break;
        case METHODID_WATCH:
          serviceImpl.watch((xyz.block.ftl.hotreload.v1.WatchRequest) request,
              (io.grpc.stub.StreamObserver<xyz.block.ftl.hotreload.v1.WatchResponse>) responseObserver);
          break;
        case METHODID_RUNNER_INFO:
          serviceImpl.runnerInfo((xyz.block.ftl.hotreload.v1.RunnerInfoRequest) request,
              (io.grpc.stub.StreamObserver<xyz.block.ftl.hotreload.v1.RunnerInfoResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  public static final io.grpc.ServerServiceDefinition bindService(AsyncService service) {
    return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
        .addMethod(
          getPingMethod(),
          io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              xyz.block.ftl.v1.PingRequest,
              xyz.block.ftl.v1.PingResponse>(
                service, METHODID_PING)))
        .addMethod(
          getReloadMethod(),
          io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              xyz.block.ftl.hotreload.v1.ReloadRequest,
              xyz.block.ftl.hotreload.v1.ReloadResponse>(
                service, METHODID_RELOAD)))
        .addMethod(
          getWatchMethod(),
          io.grpc.stub.ServerCalls.asyncServerStreamingCall(
            new MethodHandlers<
              xyz.block.ftl.hotreload.v1.WatchRequest,
              xyz.block.ftl.hotreload.v1.WatchResponse>(
                service, METHODID_WATCH)))
        .addMethod(
          getRunnerInfoMethod(),
          io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              xyz.block.ftl.hotreload.v1.RunnerInfoRequest,
              xyz.block.ftl.hotreload.v1.RunnerInfoResponse>(
                service, METHODID_RUNNER_INFO)))
        .build();
  }

  private static abstract class HotReloadServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    HotReloadServiceBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return xyz.block.ftl.hotreload.v1.Hotreload.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("HotReloadService");
    }
  }

  private static final class HotReloadServiceFileDescriptorSupplier
      extends HotReloadServiceBaseDescriptorSupplier {
    HotReloadServiceFileDescriptorSupplier() {}
  }

  private static final class HotReloadServiceMethodDescriptorSupplier
      extends HotReloadServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final java.lang.String methodName;

    HotReloadServiceMethodDescriptorSupplier(java.lang.String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (HotReloadServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new HotReloadServiceFileDescriptorSupplier())
              .addMethod(getPingMethod())
              .addMethod(getReloadMethod())
              .addMethod(getWatchMethod())
              .addMethod(getRunnerInfoMethod())
              .build();
        }
      }
    }
    return result;
  }
}
