/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.runtime;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import xyz.block.ftl.runtime.DatasourceDetails;
import xyz.block.ftl.runtime.RunnerDetails;
import xyz.block.ftl.v1.GetDeploymentContextResponse;

public class DefaultRunnerDetails
implements RunnerDetails {
    static final DefaultRunnerDetails INSTANCE = new DefaultRunnerDetails();
    private final Map<String, GetDeploymentContextResponse.DbType> databases = new ConcurrentHashMap<String, GetDeploymentContextResponse.DbType>();

    @Override
    public String getProxyAddress() {
        String endpoint = System.getenv("FTL_CONTROLLER_ENDPOINT");
        String testEndpoint = System.getProperty("ftl.test.endpoint");
        if (testEndpoint != null) {
            endpoint = testEndpoint;
        }
        if (endpoint == null) {
            endpoint = "http://localhost:8893";
        }
        return endpoint;
    }

    @Override
    public Optional<DatasourceDetails> getDatabase(String name, GetDeploymentContextResponse.DbType type) {
        if (type == GetDeploymentContextResponse.DbType.DB_TYPE_POSTGRES) {
            String proxyAddress = System.getenv("FTL_PROXY_POSTGRES_ADDRESS");
            return Optional.of(new DatasourceDetails("jdbc:postgresql://" + proxyAddress + "/" + name, "ftl", "ftl"));
        }
        if (type == GetDeploymentContextResponse.DbType.DB_TYPE_MYSQL) {
            String proxyAddress = System.getenv("FTL_PROXY_MYSQL_ADDRESS_" + name.toUpperCase());
            return Optional.of(new DatasourceDetails("jdbc:mysql://" + proxyAddress + "/" + name, "ftl", "ftl"));
        }
        return Optional.empty();
    }

    @Override
    public String getDeploymentKey() {
        return System.getenv("FTL_DEPLOYMENT");
    }
}

