/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.ByteString;
import io.quarkus.arc.Arc;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import xyz.block.ftl.runtime.VerbClientHelper;
import xyz.block.ftl.runtime.VerbInvoker;
import xyz.block.ftl.v1.CallRequest;
import xyz.block.ftl.v1.CallResponse;
import xyz.block.ftl.v1.Metadata;

public class SQLQueryVerbInvoker
implements VerbInvoker {
    final ObjectMapper mapper;
    private final String dbName;
    private final String command;
    private final String rawSQL;
    private final String[] fields;
    private final String[] colToFieldName;
    private final Class<?> returnType;
    private volatile VerbClientHelper verbClientHelper;

    public SQLQueryVerbInvoker(String dbName, String command, String rawSQL, String[] fields, String[] colToFieldName, Class<?> returnType) {
        this.dbName = dbName;
        this.command = command;
        this.rawSQL = rawSQL;
        this.fields = fields;
        this.colToFieldName = colToFieldName;
        this.returnType = returnType;
        this.mapper = new ObjectMapper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VerbClientHelper getVerbClientHelper() {
        if (this.verbClientHelper == null) {
            SQLQueryVerbInvoker sQLQueryVerbInvoker = this;
            synchronized (sQLQueryVerbInvoker) {
                if (this.verbClientHelper == null) {
                    if (Arc.container() == null) {
                        throw new IllegalStateException("Arc container is not initialized");
                    }
                    this.verbClientHelper = VerbClientHelper.instance();
                }
            }
        }
        return this.verbClientHelper;
    }

    @Override
    public CallResponse handle(CallRequest request) {
        try {
            String transactionId = null;
            for (Metadata.Pair pair : request.getMetadata().getValuesList()) {
                if (!pair.getKey().equals("ftl-transaction")) continue;
                transactionId = pair.getValue();
            }
            Object result = this.getVerbClientHelper().executeQuery(request.getBody().toByteArray(), this.dbName, this.command, this.rawSQL, this.fields, this.colToFieldName, this.returnType, transactionId);
            if (result == null) {
                if (this.command.equals("exec")) {
                    return CallResponse.newBuilder().setBody(ByteString.copyFrom((String)"{}", (Charset)StandardCharsets.UTF_8)).build();
                }
                return CallResponse.newBuilder().setError(CallResponse.Error.newBuilder().setMessage("No results found").build()).build();
            }
            byte[] mappedResponse = this.getVerbClientHelper().mapper.writer().writeValueAsBytes(result);
            return CallResponse.newBuilder().setBody(ByteString.copyFrom((byte[])mappedResponse)).build();
        }
        catch (Exception e) {
            return CallResponse.newBuilder().setError(CallResponse.Error.newBuilder().setMessage("Error executing SQL query: " + e.getMessage()).build()).build();
        }
    }

    public String toString() {
        return "SQLQueryVerbInvoker{dbName='" + this.dbName + "', command='" + this.command + "', rawSQL='" + this.rawSQL + "', fields=" + Arrays.toString(this.fields) + ", colToFieldName=" + Arrays.toString(this.colToFieldName) + ", returnType=" + String.valueOf(this.returnType) + "}";
    }
}

