/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.google.protobuf.ByteString;
import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.core.parameters.ParameterExtractor;
import xyz.block.ftl.runtime.CurrentTransaction;
import xyz.block.ftl.runtime.FTLController;
import xyz.block.ftl.runtime.VerbClientHelper;
import xyz.block.ftl.runtime.VerbInvoker;
import xyz.block.ftl.v1.CallRequest;
import xyz.block.ftl.v1.CallResponse;

@Singleton
public class VerbRegistry {
    private static final Logger log = Logger.getLogger(VerbRegistry.class);
    final ObjectMapper mapper;
    private final Map<Key, VerbInvoker> verbs = new ConcurrentHashMap<Key, VerbInvoker>();

    public VerbRegistry(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public void register(String module, String name, InstanceHandle<?> verbHandlerClass, Method method, List<ParameterSupplier> paramMappers, boolean allowNullReturn, boolean isTransaction) {
        this.verbs.put(new Key(module, name), new AnnotatedEndpointHandler(verbHandlerClass, method, paramMappers, allowNullReturn, isTransaction));
    }

    public void register(String module, String name, VerbInvoker verbInvoker) {
        this.verbs.put(new Key(module, name), verbInvoker);
    }

    public void registerTransactionDbAccess(String module, String name, List<String> databaseUses) {
        VerbInvoker registeredVerb = this.verbs.get(new Key(module, name));
        if (registeredVerb == null) {
            throw new RuntimeException("Transaction verb " + module + "." + name + " not registered; cannot register database uses");
        }
        ((AnnotatedEndpointHandler)registeredVerb).addDatasource(databaseUses.get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CallResponse invoke(CallRequest request) {
        VerbInvoker handler = this.verbs.get(new Key(request.getVerb().getModule(), request.getVerb().getName()));
        if (handler == null) {
            return CallResponse.newBuilder().setError(CallResponse.Error.newBuilder().setMessage("Verb not found").build()).build();
        }
        try {
            if (request.hasMetadata()) {
                CurrentTransaction.setCurrentIdFromMetadata(request.getMetadata());
            }
            CallResponse callResponse = handler.handle(request);
            return callResponse;
        }
        finally {
            CurrentTransaction.clearCurrent();
        }
    }

    private record Key(String module, String name) {
    }

    private class AnnotatedEndpointHandler
    implements VerbInvoker {
        final InstanceHandle<?> verbHandlerClass;
        final Method method;
        final List<ParameterSupplier> parameterSuppliers;
        final boolean allowNull;
        final boolean isTransaction;
        private volatile VerbClientHelper verbClientHelper;
        private volatile String datasourceName;

        private AnnotatedEndpointHandler(InstanceHandle<?> verbHandlerClass, Method method, List<ParameterSupplier> parameterSuppliers, boolean allowNull, boolean isTransaction) {
            this.verbHandlerClass = verbHandlerClass;
            this.method = method;
            this.parameterSuppliers = parameterSuppliers;
            this.allowNull = allowNull;
            this.isTransaction = isTransaction;
            for (ParameterSupplier parameterSupplier : parameterSuppliers) {
                parameterSupplier.init(method);
            }
        }

        @Override
        public CallResponse handle(CallRequest in) {
            String transactionId = null;
            try {
                if (this.isTransaction) {
                    transactionId = this.getVerbClientHelper().beginTransaction(this.datasourceName);
                    CurrentTransaction.setCurrentId(transactionId);
                }
                Object[] params = new Object[this.parameterSuppliers.size()];
                for (int i = 0; i < this.parameterSuppliers.size(); ++i) {
                    params[i] = this.parameterSuppliers.get(i).apply(VerbRegistry.this.mapper, in);
                }
                Object ret = this.method.invoke(this.verbHandlerClass.get(), params);
                if (this.isTransaction) {
                    this.getVerbClientHelper().commitTransaction(this.datasourceName, transactionId);
                }
                if (ret == null) {
                    if (this.allowNull) {
                        return CallResponse.newBuilder().setBody(ByteString.copyFrom((String)"{}", (Charset)StandardCharsets.UTF_8)).build();
                    }
                    return CallResponse.newBuilder().setError(CallResponse.Error.newBuilder().setMessage("Verb returned an unexpected null response").build()).build();
                }
                byte[] mappedResponse = VerbRegistry.this.mapper.writer().writeValueAsBytes(ret);
                return CallResponse.newBuilder().setBody(ByteString.copyFrom((byte[])mappedResponse)).build();
            }
            catch (Throwable e) {
                if (this.isTransaction) {
                    this.getVerbClientHelper().rollbackTransaction(this.datasourceName, transactionId);
                }
                if (e.getClass() == InvocationTargetException.class) {
                    e = e.getCause();
                }
                String message = String.format("Failed to invoke verb %s.%s", in.getVerb().getModule(), in.getVerb().getName());
                log.error((Object)message, e);
                return CallResponse.newBuilder().setError(CallResponse.Error.newBuilder().setStack(e.toString()).setMessage(message + " " + e.getMessage()).build()).build();
            }
        }

        public void addDatasource(String datasourceName) {
            this.datasourceName = datasourceName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private VerbClientHelper getVerbClientHelper() {
            if (this.verbClientHelper == null) {
                AnnotatedEndpointHandler annotatedEndpointHandler = this;
                synchronized (annotatedEndpointHandler) {
                    if (this.verbClientHelper == null) {
                        if (Arc.container() == null) {
                            throw new IllegalStateException("Arc container is not initialized");
                        }
                        this.verbClientHelper = VerbClientHelper.instance();
                    }
                }
            }
            return this.verbClientHelper;
        }
    }

    public static interface ParameterSupplier
    extends BiFunction<ObjectMapper, CallRequest, Object> {
        default public void init(Method method) {
        }
    }

    public static class EgressSupplier
    implements ParameterSupplier,
    ParameterExtractor {
        final String name;
        final Class<?> inputClass;

        public EgressSupplier(String name, Class<?> inputClass) {
            this.name = name;
            this.inputClass = inputClass;
        }

        @Override
        public Object apply(ObjectMapper mapper, CallRequest in) {
            String egress = FTLController.instance().getEgress(this.name);
            if (this.inputClass == String.class) {
                return egress;
            }
            if (this.inputClass == URI.class) {
                return URI.create(egress);
            }
            if (this.inputClass == URL.class) {
                try {
                    return new URL(egress);
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
            throw new RuntimeException("Unsupported input type: " + String.valueOf(this.inputClass));
        }

        public Object extractParameter(ResteasyReactiveRequestContext context) {
            return this.apply((ObjectMapper)Arc.container().instance(ObjectMapper.class, new Annotation[0]).get(), null);
        }

        public Class<?> getInputClass() {
            return this.inputClass;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class ConfigSupplier
    implements ParameterSupplier,
    ParameterExtractor {
        final String name;
        final Class<?> inputClass;

        public ConfigSupplier(String name, Class<?> inputClass) {
            this.name = name;
            this.inputClass = inputClass;
        }

        @Override
        public Object apply(ObjectMapper mapper, CallRequest in) {
            byte[] secret = FTLController.instance().getConfig(this.name);
            try {
                return mapper.createParser(secret).readValueAs(this.inputClass);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public Object extractParameter(ResteasyReactiveRequestContext context) {
            return this.apply((ObjectMapper)Arc.container().instance(ObjectMapper.class, new Annotation[0]).get(), null);
        }

        public Class<?> getInputClass() {
            return this.inputClass;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class SecretSupplier
    implements ParameterSupplier,
    ParameterExtractor {
        final String name;
        final Class<?> inputClass;

        public SecretSupplier(String name, Class<?> inputClass) {
            this.name = name;
            this.inputClass = inputClass;
        }

        @Override
        public Object apply(ObjectMapper mapper, CallRequest in) {
            byte[] secret = FTLController.instance().getSecret(this.name);
            try {
                return mapper.createParser(secret).readValueAs(this.inputClass);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String getName() {
            return this.name;
        }

        public Class<?> getInputClass() {
            return this.inputClass;
        }

        public Object extractParameter(ResteasyReactiveRequestContext context) {
            return this.apply((ObjectMapper)Arc.container().instance(ObjectMapper.class, new Annotation[0]).get(), null);
        }
    }

    public static class BodySupplier
    implements ParameterSupplier {
        final int parameterIndex;
        volatile Type inputClass;

        public BodySupplier(int parameterIndex) {
            this.parameterIndex = parameterIndex;
        }

        @Override
        public void init(Method method) {
            this.inputClass = method.getGenericParameterTypes()[this.parameterIndex];
        }

        @Override
        public Object apply(ObjectMapper mapper, CallRequest in) {
            try {
                ObjectReader reader = mapper.reader();
                return reader.forType(reader.getTypeFactory().constructType(this.inputClass)).readValue(in.getBody().newInput());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public int getParameterIndex() {
            return this.parameterIndex;
        }
    }
}

