/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.runtime;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import xyz.block.ftl.v1.GetDeploymentContextResponse;

public record DatasourceDetails(String connectionString, String username, String password) {
    public static DatasourceDetails fromDSN(String dsn, GetDeploymentContextResponse.DbType type) {
        String prefix = type.equals((Object)GetDeploymentContextResponse.DbType.DB_TYPE_MYSQL) ? "jdbc:mysql" : "jdbc:postgresql";
        try {
            URI uri = new URI((String)dsn);
            String username = "";
            String password = "";
            String userInfo = uri.getUserInfo();
            if (userInfo != null) {
                String[] split = userInfo.split(":");
                username = split[0];
                password = split[1];
                return new DatasourceDetails(new URI(prefix, null, uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), null).toASCIIString(), username, password);
            }
            Matcher matcher = Pattern.compile("[&?]user=([^?&]*)").matcher((CharSequence)dsn);
            if (matcher.find()) {
                username = matcher.group(1);
                dsn = matcher.replaceAll("");
            }
            if ((matcher = Pattern.compile("[&?]password=([^?&]*)").matcher((CharSequence)dsn)).find()) {
                password = matcher.group(1);
                dsn = matcher.replaceAll("");
            }
            if ((matcher = Pattern.compile("^([^:]+):([^:]+)@").matcher((CharSequence)dsn)).find()) {
                username = matcher.group(1);
                password = matcher.group(2);
                dsn = matcher.replaceAll("");
            }
            if ((matcher = Pattern.compile("tcp\\(([^:)]+):([^:)]+)\\)").matcher((CharSequence)dsn)).find()) {
                dsn = matcher.replaceAll(matcher.group(1) + ":" + matcher.group(2));
            }
            dsn = ((String)dsn).replaceAll("postgresql://", "");
            dsn = ((String)dsn).replaceAll("postgres://", "");
            dsn = ((String)dsn).replaceAll("mysql://", "");
            dsn = prefix + "://" + (String)dsn;
            return new DatasourceDetails((String)dsn, username, password);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

