/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.runtime.config;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.microprofile.config.spi.ConfigSource;
import xyz.block.ftl.runtime.FTLController;

public class FTLConfigSource
implements ConfigSource {
    static final String SEPARATE_SERVER = "quarkus.grpc.server.use-separate-server";
    static final String PORT = "quarkus.http.port";
    static final String HOST = "quarkus.http.host";
    static final String OTEL_ENDPOINT = "quarkus.otel.exporter.otlp.endpoint";
    static final String FTL_BIND = "FTL_BIND";
    private static final String OTEL_ENV_VAR = "OTEL_EXPORTER_OTLP_ENDPOINT";
    public static final String QUARKUS_LOG_LEVEL = "quarkus.log.level";
    final FTLController controller;
    private static final String OTEL_METRICS_DISABLED = "quarkus.otel.sdk.disabled";
    final Set<String> propertyNames;

    public FTLConfigSource(FTLController controller) {
        this.controller = controller;
        this.propertyNames = new HashSet<String>(List.of(SEPARATE_SERVER, PORT, HOST, QUARKUS_LOG_LEVEL));
    }

    public Set<String> getPropertyNames() {
        return this.propertyNames;
    }

    public int getOrdinal() {
        return 400;
    }

    public String getValue(String s) {
        switch (s) {
            case "quarkus.log.level": {
                return "DEBUG";
            }
            case "quarkus.otel.sdk.disabled": {
                String v = System.getenv(OTEL_ENV_VAR);
                return Boolean.toString(v == null || Objects.equals(v, "false") || Objects.equals(v, "0") || Objects.equals(v, "no") || Objects.equals(v, ""));
            }
            case "quarkus.otel.exporter.otlp.endpoint": {
                return System.getenv(OTEL_ENV_VAR);
            }
            case "quarkus.grpc.server.use-separate-server": {
                return "false";
            }
            case "quarkus.http.port": {
                String bind = System.getenv(FTL_BIND);
                if (bind == null) {
                    return null;
                }
                try {
                    URI uri = new URI(bind);
                    return Integer.toString(uri.getPort());
                }
                catch (URISyntaxException e) {
                    return null;
                }
            }
            case "quarkus.http.host": {
                String bind = System.getenv(FTL_BIND);
                if (bind == null) {
                    return null;
                }
                try {
                    URI uri = new URI(bind);
                    return uri.getHost();
                }
                catch (URISyntaxException e) {
                    return null;
                }
            }
        }
        return null;
    }

    public String getName() {
        return "FTL Config";
    }
}

