/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.runtime.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.ByteString;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.FileRegion;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.ReferenceCountUtil;
import io.quarkus.netty.runtime.virtual.VirtualAddress;
import io.quarkus.netty.runtime.virtual.VirtualClientConnection;
import io.quarkus.netty.runtime.virtual.VirtualResponseHandler;
import io.quarkus.vertx.http.runtime.QuarkusHttpHeaders;
import io.quarkus.vertx.http.runtime.VertxHttpRecorder;
import jakarta.inject.Singleton;
import java.io.ByteArrayOutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.jboss.logging.Logger;
import xyz.block.ftl.runtime.builtin.HttpRequest;
import xyz.block.ftl.runtime.builtin.HttpResponse;
import xyz.block.ftl.v1.CallRequest;
import xyz.block.ftl.v1.CallResponse;

@Singleton
public class FTLHttpHandler {
    public static final String CONTENT_TYPE = "Content-Type";
    final ObjectMapper mapper;
    private static final Logger log = Logger.getLogger((String)"quarkus.amazon.lambda.http");
    private static final int BUFFER_SIZE = 8096;
    private static final Map<String, List<String>> ERROR_HEADERS = Map.of();
    private static final String COOKIE_HEADER = "Cookie";
    private static final Set<String> COMMA_HEADERS = Set.of("access-control-request-headers");

    public FTLHttpHandler(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public CallResponse handle(CallRequest in, boolean base64Encoded) {
        try {
            HttpRequest body = (HttpRequest)this.mapper.createParser(in.getBody().newInput()).readValueAs(HttpRequest.class);
            body.getHeaders().put("X-ftl-verb", List.of(in.getVerb().getName()));
            HttpResponse ret = this.handleRequest(body, base64Encoded);
            if (ret.getBody() == null) {
                ret.setBody("{}");
            }
            ret.setHeaders(new HashMap<String, List<String>>(ret.getHeaders()));
            ret.getHeaders().remove("content-length");
            byte[] mappedResponse = this.mapper.writer().writeValueAsBytes((Object)ret);
            return CallResponse.newBuilder().setBody(ByteString.copyFrom((byte[])mappedResponse)).build();
        }
        catch (Exception e) {
            return CallResponse.newBuilder().setError(CallResponse.Error.newBuilder().setMessage(e.getMessage() == null ? e.toString() : e.getMessage()).build()).build();
        }
    }

    public HttpResponse handleRequest(HttpRequest request, boolean base64Encoded) {
        InetSocketAddress clientAddress = null;
        try {
            return this.nettyDispatch(clientAddress, request, base64Encoded);
        }
        catch (Exception e) {
            log.error((Object)"Request Failure", (Throwable)e);
            HttpResponse res = new HttpResponse();
            res.setStatus(500L);
            res.setError(e);
            res.setHeaders(ERROR_HEADERS);
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse nettyDispatch(InetSocketAddress clientAddress, HttpRequest request, boolean base64Encoded) throws Exception {
        QuarkusHttpHeaders quarkusHeaders = new QuarkusHttpHeaders();
        quarkusHeaders.setContextObject(HttpRequest.class, (Object)request);
        HttpMethod httpMethod = HttpMethod.valueOf((String)request.getMethod());
        if (httpMethod == null) {
            throw new IllegalStateException("Missing HTTP method in request event");
        }
        StringBuilder path = new StringBuilder(request.getPath());
        if (request.getQuery() != null && !request.getQuery().isEmpty()) {
            path.append("?");
            boolean first = true;
            for (Map.Entry<String, List<String>> entry : request.getQuery().entrySet()) {
                for (String val : entry.getValue()) {
                    if (first) {
                        first = false;
                    } else {
                        path.append("&");
                    }
                    path.append(entry.getKey()).append("=").append(val);
                }
            }
        }
        DefaultHttpRequest nettyRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_1, httpMethod, path.toString(), (HttpHeaders)quarkusHeaders);
        if (request.getHeaders() != null) {
            for (Map.Entry<String, List<String>> header : request.getHeaders().entrySet()) {
                if (header.getValue() == null) continue;
                for (String val : header.getValue()) {
                    nettyRequest.headers().add(header.getKey(), (Object)val);
                }
            }
        }
        nettyRequest.headers().add(CONTENT_TYPE, (Object)"application/json");
        if (!nettyRequest.headers().contains((CharSequence)HttpHeaderNames.HOST)) {
            nettyRequest.headers().add((CharSequence)HttpHeaderNames.HOST, (Object)"localhost");
        }
        LastHttpContent requestContent = LastHttpContent.EMPTY_LAST_CONTENT;
        if (request.getBody() != null) {
            nettyRequest.headers().add((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)"chunked");
            if (base64Encoded) {
                requestContent = new DefaultLastHttpContent(Unpooled.copiedBuffer((byte[])Base64.getDecoder().decode(request.getBody().asText())));
            } else if (request.getBody().isTextual()) {
                requestContent = new DefaultLastHttpContent(Unpooled.copiedBuffer((CharSequence)request.getBody().asText(), (Charset)StandardCharsets.UTF_8));
            } else if (request.getBody().isBigDecimal() || request.getBody().isDouble() || request.getBody().isFloat() || request.getBody().isInt() || request.getBody().isBigInteger()) {
                requestContent = new DefaultLastHttpContent(Unpooled.copiedBuffer((CharSequence)request.getBody().toString(), (Charset)StandardCharsets.UTF_8));
            } else {
                ByteBuf body = Unpooled.copiedBuffer((CharSequence)request.getBody().toString(), (Charset)StandardCharsets.UTF_8);
                requestContent = new DefaultLastHttpContent(body);
            }
        }
        NettyResponseHandler handler = new NettyResponseHandler(base64Encoded, request);
        VirtualClientConnection connection = VirtualClientConnection.connect((VirtualResponseHandler)handler, (VirtualAddress)VertxHttpRecorder.VIRTUAL_HTTP, (SocketAddress)clientAddress);
        connection.sendMessage((Object)nettyRequest);
        connection.sendMessage((Object)requestContent);
        try {
            HttpResponse httpResponse = handler.getFuture().get();
            return httpResponse;
        }
        finally {
            connection.close();
        }
    }

    private ByteArrayOutputStream createByteStream() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(8096);
        return baos;
    }

    private boolean isBinary(String contentType) {
        if (contentType != null) {
            String ct = contentType.toLowerCase(Locale.ROOT);
            return !ct.startsWith("text") && !ct.contains("json") && !ct.contains("xml") && !ct.contains("yaml");
        }
        return false;
    }

    private class NettyResponseHandler
    implements VirtualResponseHandler {
        HttpResponse responseBuilder = new HttpResponse();
        final boolean base64Encoded;
        ByteArrayOutputStream baos;
        WritableByteChannel byteChannel;
        final HttpRequest request;
        CompletableFuture<HttpResponse> future = new CompletableFuture();
        boolean json = false;

        public NettyResponseHandler(boolean base64Encoded, HttpRequest request) {
            this.base64Encoded = base64Encoded;
            this.request = request;
        }

        public CompletableFuture<HttpResponse> getFuture() {
            return this.future;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Object msg) {
            try {
                FileRegion file;
                if (msg instanceof io.netty.handler.codec.http.HttpResponse) {
                    String contentType;
                    io.netty.handler.codec.http.HttpResponse res = (io.netty.handler.codec.http.HttpResponse)msg;
                    this.responseBuilder.setStatus(res.status().code());
                    HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
                    this.responseBuilder.setHeaders(headers);
                    for (String name : res.headers().names()) {
                        List allForName = res.headers().getAll(name);
                        if (allForName == null || allForName.isEmpty()) continue;
                        headers.put(name, allForName);
                    }
                    if (res.headers().contains(FTLHttpHandler.CONTENT_TYPE) && (contentType = res.headers().get(FTLHttpHandler.CONTENT_TYPE)) != null && !contentType.isEmpty()) {
                        this.json = contentType.toLowerCase(Locale.ROOT).contains("application/json");
                    }
                }
                if (msg instanceof HttpContent) {
                    HttpContent content = (HttpContent)msg;
                    int readable = content.content().readableBytes();
                    if (this.baos == null && readable > 0) {
                        this.baos = FTLHttpHandler.this.createByteStream();
                    }
                    for (int i = 0; i < readable; ++i) {
                        this.baos.write(content.content().readByte());
                    }
                }
                if (msg instanceof FileRegion && (file = (FileRegion)msg).count() > 0L && file.transferred() < file.count()) {
                    if (this.baos == null) {
                        this.baos = FTLHttpHandler.this.createByteStream();
                    }
                    if (this.byteChannel == null) {
                        this.byteChannel = Channels.newChannel(this.baos);
                    }
                    file.transferTo(this.byteChannel, file.transferred());
                }
                if (msg instanceof LastHttpContent) {
                    if (this.baos != null) {
                        if (this.json) {
                            this.responseBuilder.setBody(this.baos.toString(StandardCharsets.UTF_8));
                        } else if (this.base64Encoded) {
                            this.responseBuilder.setBody(FTLHttpHandler.this.mapper.writer().writeValueAsString((Object)Base64.getEncoder().encodeToString(this.baos.toByteArray())));
                        } else {
                            this.responseBuilder.setBody(FTLHttpHandler.this.mapper.writer().writeValueAsString((Object)this.baos.toString(StandardCharsets.UTF_8)));
                        }
                        List<String> ct = this.responseBuilder.getHeaders().get(FTLHttpHandler.CONTENT_TYPE);
                        if (ct == null || ct.isEmpty()) {
                            this.responseBuilder.setBody(this.baos.toString(StandardCharsets.UTF_8));
                        } else if (ct.get(0).contains("text/plain")) {
                            // empty if block
                        }
                    }
                    this.future.complete(this.responseBuilder);
                }
            }
            catch (Throwable ex) {
                this.future.completeExceptionally(ex);
            }
            finally {
                if (msg != null) {
                    ReferenceCountUtil.release((Object)msg);
                }
            }
        }

        public void close() {
            if (!this.future.isDone()) {
                this.future.completeExceptionally(new RuntimeException("Connection closed"));
            }
        }
    }
}

