/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.runtime;

import io.quarkus.arc.Arc;
import jakarta.enterprise.context.RequestScoped;
import java.lang.annotation.Annotation;
import xyz.block.ftl.v1.Metadata;

@RequestScoped
public class CurrentTransaction {
    private static final String METADATA_KEY = "ftl-transaction";
    private String id;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void clear() {
        this.id = null;
    }

    public static CurrentTransaction current() {
        return (CurrentTransaction)Arc.container().select(CurrentTransaction.class, new Annotation[0]).get();
    }

    public static void setCurrentId(String id) {
        CurrentTransaction ctx;
        if (id != null && (ctx = CurrentTransaction.current()) != null) {
            ctx.setId(id);
        }
    }

    public static String getCurrentId() {
        CurrentTransaction ctx = CurrentTransaction.current();
        return ctx != null ? ctx.getId() : null;
    }

    public static void clearCurrent() {
        CurrentTransaction ctx = CurrentTransaction.current();
        if (ctx != null) {
            ctx.clear();
        }
    }

    public static void setCurrentIdFromMetadata(Metadata metadata) {
        if (metadata != null) {
            for (Metadata.Pair pair : metadata.getValuesList()) {
                if (!pair.getKey().equals(METADATA_KEY)) continue;
                CurrentTransaction.setCurrentId(pair.getValue());
            }
        }
    }

    public static Metadata getMetadataWithCurrentId() {
        Metadata.Builder builder = Metadata.newBuilder();
        if (CurrentTransaction.getCurrentId() != null) {
            builder.addValues(Metadata.Pair.newBuilder().setKey(METADATA_KEY).setValue(CurrentTransaction.getCurrentId()).build());
        }
        return builder.build();
    }
}

