/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.core.parameters.ParameterExtractor;
import xyz.block.ftl.runtime.FTLController;
import xyz.block.ftl.runtime.JsonSerializationConfig;
import xyz.block.ftl.runtime.SQLQueryVerbInvoker;
import xyz.block.ftl.runtime.VerbRegistry;
import xyz.block.ftl.runtime.WorkloadIdentityImpl;
import xyz.block.ftl.runtime.http.FTLHttpHandler;
import xyz.block.ftl.runtime.http.HTTPVerbInvoker;
import xyz.block.ftl.v1.CallRequest;
import xyz.block.ftl.v1.GetDeploymentContextResponse;

@Recorder
public class FTLRecorder {
    public static final String X_FTL_VERB = "X-ftl-verb";

    public void registerVerb(String module, String verbName, String methodName, List<Class<?>> parameterTypes, Class<?> verbHandlerClass, List<VerbRegistry.ParameterSupplier> paramMappers, boolean allowNullReturn, boolean isTransaction) {
        try {
            Method method = verbHandlerClass.getDeclaredMethod(methodName, parameterTypes.toArray(new Class[0]));
            method.setAccessible(true);
            InstanceHandle handlerInstance = Arc.container().instance(verbHandlerClass, new Annotation[0]);
            ((VerbRegistry)Arc.container().instance(VerbRegistry.class, new Annotation[0]).get()).register(module, verbName, handlerInstance, method, paramMappers, allowNullReturn, isTransaction);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void registerTypeVerb(String module, String verbName, String methodName, Class<?> verbHandlerClass, List<Class<?>> parameterTypes, List<VerbRegistry.ParameterSupplier> paramMappers, List<Class<?>> ctorTypes, List<VerbRegistry.ParameterSupplier> ctorParamMappers, boolean allowNullReturn, boolean isTransaction) {
        try {
            Method method = verbHandlerClass.getDeclaredMethod(methodName, parameterTypes.toArray(new Class[0]));
            method.setAccessible(true);
            ObjectMapper obj = (ObjectMapper)Arc.container().instance(ObjectMapper.class, new Annotation[0]).get();
            Constructor<?> ctor = verbHandlerClass.getDeclaredConstructor(ctorTypes.toArray(new Class[0]));
            final Object instance = ctor.newInstance(ctorParamMappers.stream().map(s -> s.apply(obj, null)).toArray());
            ((VerbRegistry)Arc.container().instance(VerbRegistry.class, new Annotation[0]).get()).register(module, verbName, new InstanceHandle<Object>(){

                public Object get() {
                    return instance;
                }
            }, method, paramMappers, allowNullReturn, isTransaction);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void registerTransactionDbAccess(String module, String verbName, List<String> databaseUses) {
        ((VerbRegistry)Arc.container().instance(VerbRegistry.class, new Annotation[0]).get()).registerTransactionDbAccess(module, verbName, databaseUses);
    }

    public void registerSqlQueryVerb(String module, String verbName, Class<?> sqlQueryClientClass, Class<?> returnType, String dbName, String command, String rawSQL, String[] fields, String[] colToFieldName) {
        try {
            VerbRegistry verbRegistry = (VerbRegistry)Arc.container().instance(VerbRegistry.class, new Annotation[0]).get();
            SQLQueryVerbInvoker invoker = new SQLQueryVerbInvoker(dbName, command, rawSQL, fields, colToFieldName, returnType);
            verbRegistry.register(module, verbName, invoker);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void registerHttpIngress(String module, String verbName, boolean base64Encoded) {
        try {
            FTLHttpHandler ftlHttpHandler = (FTLHttpHandler)Arc.container().instance(FTLHttpHandler.class, new Annotation[0]).get();
            VerbRegistry verbRegistry = (VerbRegistry)Arc.container().instance(VerbRegistry.class, new Annotation[0]).get();
            verbRegistry.register(module, verbName, new HTTPVerbInvoker(base64Encoded, ftlHttpHandler));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void registerEnum(Class<?> ennum) {
        try {
            ((JsonSerializationConfig)Arc.container().instance(JsonSerializationConfig.class, new Annotation[0]).get()).registerValueEnum(ennum);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void registerEnumHolder(Class<?> ennum) {
        try {
            ((JsonSerializationConfig)Arc.container().instance(JsonSerializationConfig.class, new Annotation[0]).get()).registerEnumHolder(ennum);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void registerEnum(Class<?> ennum, Map<String, Class<?>> variants) {
        try {
            ((JsonSerializationConfig)Arc.container().instance(JsonSerializationConfig.class, new Annotation[0]).get()).registerTypeEnum(ennum, variants);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public VerbRegistry.ParameterSupplier topicSupplier(String className, String callingVerb) {
        try {
            Class<?> cls = Thread.currentThread().getContextClassLoader().loadClass(className.replace("/", "."));
            final Object topic = cls.getDeclaredConstructor(String.class).newInstance(callingVerb);
            return new VerbRegistry.ParameterSupplier(){

                @Override
                public Object apply(ObjectMapper mapper, CallRequest callRequest) {
                    return topic;
                }
            };
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public VerbRegistry.ParameterSupplier verbClientSupplier(String className) {
        try {
            Class<?> cls = Thread.currentThread().getContextClassLoader().loadClass(className.replace("/", "."));
            final Object client = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return new VerbRegistry.ParameterSupplier(){

                @Override
                public Object apply(ObjectMapper mapper, CallRequest callRequest) {
                    return client;
                }
            };
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public VerbRegistry.ParameterSupplier leaseClientSupplier() {
        return new VerbRegistry.ParameterSupplier(this){

            @Override
            public Object apply(ObjectMapper mapper, CallRequest callRequest) {
                return FTLController.instance();
            }
        };
    }

    public ParameterExtractor topicParamExtractor(String className) {
        try {
            Class<?> cls = Thread.currentThread().getContextClassLoader().loadClass(className.replace("/", "."));
            final Constructor<?> ctor = cls.getDeclaredConstructor(String.class);
            return new ParameterExtractor(){

                public Object extractParameter(ResteasyReactiveRequestContext context) {
                    try {
                        Object topic = ctor.newInstance(context.getHeader(FTLRecorder.X_FTL_VERB, true));
                        return topic;
                    }
                    catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ParameterExtractor verbParamExtractor(String className) {
        try {
            Class<?> cls = Thread.currentThread().getContextClassLoader().loadClass(className.replace("/", "."));
            final Object client = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return new ParameterExtractor(){

                public Object extractParameter(ResteasyReactiveRequestContext context) {
                    return client;
                }
            };
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ParameterExtractor leaseClientExtractor() {
        try {
            return new ParameterExtractor(this){

                public Object extractParameter(ResteasyReactiveRequestContext context) {
                    return FTLController.instance();
                }
            };
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void registerDatabase(String dbKind, GetDeploymentContextResponse.DbType name) {
        FTLController.instance().registerDatabase(dbKind, name);
    }

    public void loadModuleContextOnStartup() {
        FTLController.instance().loadDeploymentContext();
    }

    public void failStartup(String message) {
        throw new RuntimeException(message);
    }

    public VerbRegistry.ParameterSupplier workloadIdentitySupplier() {
        return new VerbRegistry.ParameterSupplier(this){

            @Override
            public Object apply(ObjectMapper mapper, CallRequest callRequest) {
                return WorkloadIdentityImpl.create();
            }
        };
    }
}

