/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.runtime;

import com.google.protobuf.ByteString;
import com.google.protobuf.Duration;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ConnectivityState;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.stub.StreamObserver;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.jboss.logging.Logger;
import xyz.block.ftl.LeaseFailedException;
import xyz.block.ftl.LeaseHandle;
import xyz.block.ftl.lease.v1.AcquireLeaseRequest;
import xyz.block.ftl.lease.v1.AcquireLeaseResponse;
import xyz.block.ftl.lease.v1.LeaseServiceGrpc;
import xyz.block.ftl.pubsub.v1.PublishEventRequest;
import xyz.block.ftl.pubsub.v1.PublishEventResponse;
import xyz.block.ftl.pubsub.v1.PublishServiceGrpc;
import xyz.block.ftl.query.v1.BeginTransactionRequest;
import xyz.block.ftl.query.v1.BeginTransactionResponse;
import xyz.block.ftl.query.v1.CommandType;
import xyz.block.ftl.query.v1.CommitTransactionRequest;
import xyz.block.ftl.query.v1.CommitTransactionResponse;
import xyz.block.ftl.query.v1.ExecuteQueryRequest;
import xyz.block.ftl.query.v1.ExecuteQueryResponse;
import xyz.block.ftl.query.v1.QueryServiceGrpc;
import xyz.block.ftl.query.v1.ResultColumn;
import xyz.block.ftl.query.v1.RollbackTransactionRequest;
import xyz.block.ftl.query.v1.RollbackTransactionResponse;
import xyz.block.ftl.query.v1.TransactionStatus;
import xyz.block.ftl.runtime.CurrentRequestClientInterceptor;
import xyz.block.ftl.runtime.CurrentTransaction;
import xyz.block.ftl.runtime.FTLRunnerConnection;
import xyz.block.ftl.schema.v1.Ref;
import xyz.block.ftl.v1.CallRequest;
import xyz.block.ftl.v1.CallResponse;
import xyz.block.ftl.v1.DeploymentContextServiceGrpc;
import xyz.block.ftl.v1.GetDeploymentContextRequest;
import xyz.block.ftl.v1.GetDeploymentContextResponse;
import xyz.block.ftl.v1.VerbServiceGrpc;

class FTLRunnerConnectionImpl
implements FTLRunnerConnection {
    private static final Logger log = Logger.getLogger(FTLRunnerConnectionImpl.class);
    final String moduleName;
    final String deploymentName;
    private final ManagedChannel channel;
    private final String endpoint;
    private Throwable currentError;
    private volatile GetDeploymentContextResponse moduleContextResponse;
    private boolean waiters = false;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    final VerbServiceGrpc.VerbServiceStub verbService;
    final DeploymentContextServiceGrpc.DeploymentContextServiceStub deploymentService;
    final LeaseServiceGrpc.LeaseServiceStub leaseService;
    final PublishServiceGrpc.PublishServiceStub publishService;
    final QueryServiceGrpc.QueryServiceStub queryService;
    final StreamObserver<GetDeploymentContextResponse> moduleObserver = new ModuleObserver();

    FTLRunnerConnectionImpl(String endpoint, String deploymentName, String moduleName, Consumer<FTLRunnerConnection> closeHandler) {
        URI uri = URI.create(endpoint);
        this.moduleName = moduleName;
        ManagedChannelBuilder channelBuilder = ManagedChannelBuilder.forAddress((String)uri.getHost(), (int)uri.getPort());
        if (uri.getScheme().equals("http")) {
            channelBuilder.usePlaintext();
        }
        this.channel = channelBuilder.build();
        this.channel.notifyWhenStateChanged(ConnectivityState.READY, () -> {
            if ((this.channel.isShutdown() || this.channel.isTerminated()) && this.closed.compareAndSet(false, true)) {
                log.debug((Object)"Channel state changed to SHUTDOWN, closing connection");
                this.channel.shutdown();
                closeHandler.accept(this);
            }
        });
        this.deploymentName = deploymentName;
        this.deploymentService = DeploymentContextServiceGrpc.newStub((Channel)this.channel);
        this.deploymentService.getDeploymentContext(GetDeploymentContextRequest.newBuilder().setDeployment(deploymentName).build(), this.moduleObserver);
        this.verbService = (VerbServiceGrpc.VerbServiceStub)VerbServiceGrpc.newStub((Channel)this.channel).withInterceptors(new ClientInterceptor[]{new CurrentRequestClientInterceptor()});
        this.publishService = (PublishServiceGrpc.PublishServiceStub)PublishServiceGrpc.newStub((Channel)this.channel).withInterceptors(new ClientInterceptor[]{new CurrentRequestClientInterceptor()});
        this.leaseService = (LeaseServiceGrpc.LeaseServiceStub)LeaseServiceGrpc.newStub((Channel)this.channel).withInterceptors(new ClientInterceptor[]{new CurrentRequestClientInterceptor()});
        this.queryService = (QueryServiceGrpc.QueryServiceStub)QueryServiceGrpc.newStub((Channel)this.channel).withInterceptors(new ClientInterceptor[]{new CurrentRequestClientInterceptor()});
        this.endpoint = endpoint;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public byte[] getSecret(String secretName) {
        GetDeploymentContextResponse context = this.getDeploymentContext();
        if (context.containsSecrets(secretName)) {
            return context.getSecretsMap().get(secretName).toByteArray();
        }
        throw new RuntimeException("Secret not found: " + secretName);
    }

    @Override
    public byte[] getConfig(String secretName) {
        GetDeploymentContextResponse context = this.getDeploymentContext();
        if (context.containsConfigs(secretName)) {
            return context.getConfigsMap().get(secretName).toByteArray();
        }
        throw new RuntimeException("Config not found: " + secretName);
    }

    @Override
    public byte[] callVerb(String name, String module, byte[] payload) {
        final CompletableFuture cf = new CompletableFuture();
        CallRequest.Builder requestBuilder = CallRequest.newBuilder().setVerb(Ref.newBuilder().setModule(module).setName(name)).setBody(ByteString.copyFrom((byte[])payload));
        String currentTransactionId = CurrentTransaction.getCurrentId();
        if (currentTransactionId != null) {
            requestBuilder.setMetadata(CurrentTransaction.getMetadataWithCurrentId());
        }
        this.verbService.call(requestBuilder.build(), new StreamObserver<CallResponse>(this){

            public void onNext(CallResponse callResponse) {
                if (callResponse.hasError()) {
                    cf.completeExceptionally(new RuntimeException(callResponse.getError().getMessage()));
                } else {
                    cf.complete(callResponse.getBody().toByteArray());
                }
            }

            public void onError(Throwable throwable) {
                cf.completeExceptionally(throwable);
            }

            public void onCompleted() {
            }
        });
        try {
            byte[] byArray = (byte[])cf.get();
            return byArray;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            CurrentTransaction.clearCurrent();
        }
    }

    @Override
    public void publishEvent(String topic, String callingVerbName, byte[] event, String key) {
        final CompletableFuture cf = new CompletableFuture();
        this.publishService.publishEvent(PublishEventRequest.newBuilder().setCaller(callingVerbName).setBody(ByteString.copyFrom((byte[])event)).setTopic(Ref.newBuilder().setModule(this.moduleName).setName(topic).build()).setKey(key).build(), new StreamObserver<PublishEventResponse>(){

            public void onNext(PublishEventResponse publishEventResponse) {
                cf.complete(null);
            }

            public void onError(Throwable throwable) {
                cf.completeExceptionally(throwable);
            }

            public void onCompleted() {
                cf.complete(null);
            }
        });
        try {
            cf.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public LeaseHandle acquireLease(java.time.Duration duration, String ... keys) throws LeaseFailedException {
        final CompletableFuture cf = new CompletableFuture();
        final StreamObserver<AcquireLeaseRequest> client = this.leaseService.acquireLease(new StreamObserver<AcquireLeaseResponse>(){

            public void onNext(AcquireLeaseResponse value) {
                cf.complete(null);
            }

            public void onError(Throwable t) {
                cf.completeExceptionally(t);
            }

            public void onCompleted() {
                if (!cf.isDone()) {
                    this.onError(new RuntimeException("stream closed"));
                }
            }
        });
        ArrayList<String> realKeys = new ArrayList<String>();
        realKeys.add("module");
        realKeys.add(this.moduleName);
        realKeys.addAll(Arrays.asList(keys));
        client.onNext((Object)AcquireLeaseRequest.newBuilder().addAllKey(realKeys).setTtl(Duration.newBuilder().setSeconds(duration.toSeconds())).build());
        try {
            cf.get();
        }
        catch (Exception e) {
            throw new LeaseFailedException("lease already held", e);
        }
        return new LeaseHandle(){

            @Override
            public void close() {
                client.onCompleted();
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public GetDeploymentContextResponse getDeploymentContext() {
        GetDeploymentContextResponse moduleContext = this.moduleContextResponse;
        if (moduleContext != null) {
            return moduleContext;
        }
        StreamObserver<GetDeploymentContextResponse> streamObserver = this.moduleObserver;
        synchronized (streamObserver) {
            while ((moduleContext = this.moduleContextResponse) == null) {
                if (this.currentError != null) {
                    throw new RuntimeException(this.currentError);
                }
                this.waiters = true;
                try {
                    this.moduleObserver.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            return moduleContext;
        }
    }

    @Override
    public void close() {
        this.channel.shutdown();
    }

    @Override
    public String getEgress(String name) {
        return this.getDeploymentContext().getEgressMap().get(name);
    }

    @Override
    public String beginTransaction(String databaseName) {
        final CompletableFuture cf = new CompletableFuture();
        this.queryService.beginTransaction(BeginTransactionRequest.newBuilder().setDatabaseName(databaseName).build(), new StreamObserver<BeginTransactionResponse>(){

            public void onNext(BeginTransactionResponse response) {
                cf.complete(response.getTransactionId());
            }

            public void onError(Throwable throwable) {
                cf.completeExceptionally(throwable);
            }

            public void onCompleted() {
                cf.complete(null);
            }
        });
        try {
            return (String)cf.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void commitTransaction(String databaseName, String transactionId) {
        final CompletableFuture cf = new CompletableFuture();
        this.queryService.commitTransaction(CommitTransactionRequest.newBuilder().setTransactionId(transactionId).setDatabaseName(databaseName).build(), new StreamObserver<CommitTransactionResponse>(){

            public void onNext(CommitTransactionResponse response) {
                if (response.getStatus() != TransactionStatus.TRANSACTION_STATUS_SUCCESS) {
                    cf.completeExceptionally(new RuntimeException("failed to commit transaction"));
                } else {
                    cf.complete(null);
                }
            }

            public void onError(Throwable throwable) {
                cf.completeExceptionally(throwable);
            }

            public void onCompleted() {
                cf.complete(null);
            }
        });
        try {
            cf.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void rollbackTransaction(String databaseName, String transactionId) {
        final CompletableFuture cf = new CompletableFuture();
        this.queryService.rollbackTransaction(RollbackTransactionRequest.newBuilder().setTransactionId(transactionId).setDatabaseName(databaseName).build(), new StreamObserver<RollbackTransactionResponse>(){

            public void onNext(RollbackTransactionResponse response) {
                if (response.getStatus() != TransactionStatus.TRANSACTION_STATUS_SUCCESS) {
                    cf.completeExceptionally(new RuntimeException("failed to rollback transaction"));
                } else {
                    cf.complete(null);
                }
            }

            public void onError(Throwable throwable) {
                cf.completeExceptionally(throwable);
            }

            public void onCompleted() {
                cf.complete(null);
            }
        });
        try {
            cf.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String executeQueryOne(String dbName, String sql, String paramsJson, String[] colToFieldName, String transactionId) {
        ExecuteQueryRequest request = this.createQueryRequest(dbName, sql, paramsJson, colToFieldName, transactionId).setCommandType(CommandType.COMMAND_TYPE_ONE).build();
        List<ExecuteQueryResponse> responses = this.executeQuery(request);
        if (responses.isEmpty()) {
            return null;
        }
        if (responses.size() > 1) {
            throw new RuntimeException("expected 1 response, got " + responses.size());
        }
        ExecuteQueryResponse response = responses.get(0);
        if (!response.hasRowResults() || response.getRowResults().getJsonRows() == null || response.getRowResults().getJsonRows().isEmpty()) {
            return null;
        }
        return response.getRowResults().getJsonRows();
    }

    @Override
    public List<String> executeQueryMany(String dbName, String sql, String paramsJson, String[] colToFieldName, String transactionId) {
        ExecuteQueryRequest request = this.createQueryRequest(dbName, sql, paramsJson, colToFieldName, transactionId).setCommandType(CommandType.COMMAND_TYPE_MANY).build();
        List<ExecuteQueryResponse> responses = this.executeQuery(request);
        ArrayList<String> results = new ArrayList<String>();
        for (ExecuteQueryResponse response : responses) {
            if (!response.hasRowResults() || response.getRowResults().getJsonRows() == null || response.getRowResults().getJsonRows().isEmpty()) continue;
            results.add(response.getRowResults().getJsonRows());
        }
        return results;
    }

    @Override
    public void executeQueryExec(String dbName, String sql, String paramsJson, String transactionId) {
        ExecuteQueryRequest request = this.createQueryRequest(dbName, sql, paramsJson, null, transactionId).setCommandType(CommandType.COMMAND_TYPE_EXEC).build();
        this.executeQuery(request);
    }

    private List<ExecuteQueryResponse> executeQuery(ExecuteQueryRequest request) {
        final CompletableFuture cf = new CompletableFuture();
        final ArrayList responses = new ArrayList();
        this.queryService.executeQuery(request, new StreamObserver<ExecuteQueryResponse>(){

            public void onNext(ExecuteQueryResponse response) {
                responses.add(response);
            }

            public void onError(Throwable throwable) {
                cf.completeExceptionally(throwable);
            }

            public void onCompleted() {
                cf.complete(responses);
            }
        });
        try {
            return (List)cf.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private ExecuteQueryRequest.Builder createQueryRequest(String dbName, String sql, String paramsJson, String[] colToFieldName, String transactionId) {
        ExecuteQueryRequest.Builder requestBuilder = ExecuteQueryRequest.newBuilder().setRawSql(sql).setDatabaseName(dbName);
        if (transactionId != null && !transactionId.isEmpty()) {
            requestBuilder.setTransactionId(transactionId);
        }
        if (paramsJson != null && !paramsJson.isEmpty()) {
            requestBuilder.setParametersJson(paramsJson);
        }
        if (colToFieldName != null && colToFieldName.length > 0) {
            for (String mapping : colToFieldName) {
                String[] parts = mapping.split(",", 2);
                if (parts.length != 2) continue;
                ResultColumn column = ResultColumn.newBuilder().setSqlName(parts[0]).setTypeName(parts[1]).build();
                requestBuilder.addResultColumns(column);
            }
        }
        return requestBuilder;
    }

    private class ModuleObserver
    implements StreamObserver<GetDeploymentContextResponse> {
        final AtomicInteger failCount = new AtomicInteger();

        private ModuleObserver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(GetDeploymentContextResponse moduleContextResponse) {
            ModuleObserver moduleObserver = this;
            synchronized (moduleObserver) {
                FTLRunnerConnectionImpl.this.currentError = null;
                FTLRunnerConnectionImpl.this.moduleContextResponse = moduleContextResponse;
                if (FTLRunnerConnectionImpl.this.waiters) {
                    this.notifyAll();
                    FTLRunnerConnectionImpl.this.waiters = false;
                }
            }
        }

        public void onError(Throwable throwable) {
            log.debug((Object)"GRPC connection error", throwable);
            FTLRunnerConnectionImpl.this.currentError = throwable;
            this.onCompleted();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCompleted() {
            ModuleObserver moduleObserver = this;
            synchronized (moduleObserver) {
                if (FTLRunnerConnectionImpl.this.waiters) {
                    this.notifyAll();
                    FTLRunnerConnectionImpl.this.waiters = false;
                }
            }
            if (this.failCount.incrementAndGet() < 5) {
                FTLRunnerConnectionImpl.this.deploymentService.getDeploymentContext(GetDeploymentContextRequest.newBuilder().setDeployment(FTLRunnerConnectionImpl.this.deploymentName).build(), FTLRunnerConnectionImpl.this.moduleObserver);
            }
        }
    }
}

