/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.runtime;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.quarkus.arc.Unremovable;
import io.quarkus.jackson.ObjectMapperCustomizer;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import xyz.block.ftl.TypeAliasMapper;

@Singleton
@Unremovable
public class JsonSerializationConfig
implements ObjectMapperCustomizer {
    final Iterable<TypeAliasMapper<?, ?>> instances;
    final List<Class> valueEnums = new ArrayList<Class>();
    final List<Class> holderTypes = new ArrayList<Class>();
    final List<TypeEnumDefn> typeEnums = new ArrayList<TypeEnumDefn>();
    private volatile boolean initialized = false;

    @Inject
    public JsonSerializationConfig(Instance<TypeAliasMapper<?, ?>> instances) {
        this.instances = instances;
    }

    JsonSerializationConfig() {
        this.instances = List.of();
    }

    public void customize(ObjectMapper mapper) {
        this.initialized = true;
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        SimpleModule module = new SimpleModule("ByteArraySerializer", new Version(1, 0, 0, ""));
        SimpleModule variantModule = new SimpleModule("VariantModule", new Version(1, 0, 0, ""));
        module.addSerializer(byte[].class, (JsonSerializer)new ByteArraySerializer());
        module.addDeserializer(byte[].class, (JsonDeserializer)new ByteArrayDeserializer());
        mapper.disable(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE);
        for (TypeAliasMapper<?, ?> typeAliasMapper : this.instances) {
            Class<?> clazz = JsonSerializationConfig.extractTypeAliasParam(typeAliasMapper.getClass(), 0);
            Class<?> serialized = JsonSerializationConfig.extractTypeAliasParam(typeAliasMapper.getClass(), 1);
            module.addSerializer(clazz, new TypeAliasSerializer(clazz, serialized, typeAliasMapper));
            module.addDeserializer(clazz, new TypeAliasDeSerializer(clazz, serialized, typeAliasMapper));
        }
        for (Class clazz : this.valueEnums) {
            module.addSerializer(clazz, new ValueEnumSerializer(clazz));
            module.addDeserializer(clazz, new ValueEnumDeserializer(clazz));
        }
        ObjectMapper cleanMapper = mapper.copy();
        for (Class clazz : this.holderTypes) {
            module.addDeserializer(clazz, new HolderEnumDeserializer(clazz));
            variantModule.addSerializer(clazz, new ValueEnumSerializer(clazz));
        }
        for (TypeEnumDefn typeEnumDefn : this.typeEnums) {
            module.addSerializer(typeEnumDefn.type, new TypeEnumSerializer(typeEnumDefn.type, cleanMapper, typeEnumDefn.variants));
            module.addDeserializer(typeEnumDefn.type, new TypeEnumDeserializer(typeEnumDefn.type, typeEnumDefn.variants));
        }
        mapper.registerModule((Module)module);
        cleanMapper.registerModule((Module)variantModule);
    }

    public <T extends Enum<T>> void registerValueEnum(Class enumClass) {
        if (this.initialized) {
            throw new RuntimeException("Cannot register type enum after mapper is created");
        }
        this.valueEnums.add(enumClass);
    }

    public <T> void registerTypeEnum(Class<?> type, Map<String, Class<?>> variants) {
        if (this.initialized) {
            throw new RuntimeException("Cannot register type enum after mapper is created");
        }
        this.typeEnums.add(new TypeEnumDefn(type, variants));
    }

    public <T> void registerEnumHolder(Class<?> type) {
        if (this.initialized) {
            throw new RuntimeException("Cannot register type enum after mapper is created");
        }
        this.holderTypes.add(type);
    }

    static Class<?> extractTypeAliasParam(Class<?> target, int no) {
        return (Class)JsonSerializationConfig.extractTypeAliasParamImpl(target, no);
    }

    static Type extractTypeAliasParamImpl(Class<?> target, int no) {
        for (Type i : target.getGenericInterfaces()) {
            if (i instanceof ParameterizedType) {
                ParameterizedType p = (ParameterizedType)i;
                if (p.getRawType().equals(TypeAliasMapper.class)) {
                    return p.getActualTypeArguments()[no];
                }
                Type result = JsonSerializationConfig.extractTypeAliasParamImpl((Class)p.getRawType(), no);
                if (result instanceof Class) {
                    return result;
                }
                if (!(result instanceof TypeVariable)) continue;
                TypeVariable<Class<T>>[] params = ((Class)p.getRawType()).getTypeParameters();
                TypeVariable tv = (TypeVariable)result;
                for (int j = 0; j < params.length; ++j) {
                    if (!params[j].getName().equals(tv.getName())) continue;
                    return p.getActualTypeArguments()[j];
                }
                return tv;
            }
            if (!(i instanceof Class)) continue;
            return JsonSerializationConfig.extractTypeAliasParamImpl((Class)i, no);
        }
        throw new RuntimeException("Could not extract type params from " + String.valueOf(target));
    }

    public static class ByteArraySerializer
    extends StdSerializer<byte[]> {
        public ByteArraySerializer() {
            super(byte[].class);
        }

        public void serialize(byte[] value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeString(Base64.getEncoder().encodeToString(value));
        }
    }

    public static class ByteArrayDeserializer
    extends StdDeserializer<byte[]> {
        public ByteArrayDeserializer() {
            super(byte[].class);
        }

        public byte[] deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            String base64 = node.asText();
            return Base64.getDecoder().decode(base64);
        }
    }

    public static class TypeAliasSerializer<T, S>
    extends StdSerializer<T> {
        final TypeAliasMapper<T, S> mapper;
        final Class<S> serializedType;

        public TypeAliasSerializer(Class<T> type, Class<S> serializedType, TypeAliasMapper<T, S> mapper) {
            super(type);
            this.mapper = mapper;
            this.serializedType = serializedType;
        }

        public void serialize(T value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            S s = this.mapper.encode(value);
            gen.writeObject(s);
        }
    }

    public static class TypeAliasDeSerializer<T, S>
    extends StdDeserializer<T> {
        final TypeAliasMapper<T, S> mapper;
        final Class<S> serializedType;

        public TypeAliasDeSerializer(Class<T> type, Class<S> serializedType, TypeAliasMapper<T, S> mapper) {
            super(type);
            this.mapper = mapper;
            this.serializedType = serializedType;
        }

        public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            Object s = ctxt.readValue(p, this.serializedType);
            return this.mapper.decode(s);
        }
    }

    public static class ValueEnumSerializer<T>
    extends StdSerializer<T> {
        private final Field valueField;

        public ValueEnumSerializer(Class<T> type) {
            super(type);
            try {
                this.valueField = type.getDeclaredField("value");
                this.valueField.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }

        public void serialize(T value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            try {
                gen.writeObject(this.valueField.get(value));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class ValueEnumDeserializer<T>
    extends StdDeserializer<T> {
        private final Map<Object, T> wireToEnum = new HashMap<Object, T>();
        private final Class<?> valueClass;

        public ValueEnumDeserializer(Class<T> type) {
            super(type);
            try {
                Field valueField = type.getDeclaredField("value");
                valueField.setAccessible(true);
                this.valueClass = valueField.getType();
                for (T ennum : type.getEnumConstants()) {
                    this.wireToEnum.put(valueField.get(ennum), ennum);
                }
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }

        public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            Object wireVal = ctxt.readValue(p, this.valueClass);
            return this.wireToEnum.get(wireVal);
        }
    }

    public static class HolderEnumDeserializer<T>
    extends StdDeserializer<T> {
        private final Class<?> valueClass;
        private final Constructor<?> ctor;
        private final Field valueField;

        public HolderEnumDeserializer(Class<T> type) {
            super(type);
            try {
                Constructor<T> ctor;
                this.valueField = type.getDeclaredField("value");
                this.valueField.setAccessible(true);
                this.valueClass = this.valueField.getType();
                try {
                    ctor = type.getDeclaredConstructor(this.valueClass);
                }
                catch (NoSuchMethodException e) {
                    ctor = type.getDeclaredConstructor(new Class[0]);
                }
                ctor.setAccessible(true);
                this.ctor = ctor;
            }
            catch (NoSuchFieldException | NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }

        public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            Object wireVal = ctxt.readValue(p, this.valueClass);
            try {
                if (this.ctor.getParameterCount() == 0) {
                    Object ret = this.ctor.newInstance(new Object[0]);
                    this.valueField.set(ret, wireVal);
                    return (T)ret;
                }
                return (T)this.ctor.newInstance(wireVal);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private record TypeEnumDefn<T>(Class<T> type, Map<String, Class<?>> variants) {
    }

    public static class TypeEnumSerializer<T>
    extends StdSerializer<T> {
        private final ObjectMapper defaultMapper;
        private final Map<String, String> classToName = new HashMap<String, String>();

        public TypeEnumSerializer(Class<T> type, ObjectMapper mapper, Map<String, Class<?>> variants) {
            super(type);
            this.defaultMapper = mapper;
            for (Map.Entry<String, Class<?>> variant : variants.entrySet()) {
                this.classToName.put(variant.getValue().getName(), variant.getKey());
            }
        }

        public void serialize(T value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            gen.writeStringField("name", this.classToName.getOrDefault(value.getClass().getName(), value.getClass().getSimpleName()));
            gen.writeFieldName("value");
            this.defaultMapper.writeValue(gen, value);
            gen.writeEndObject();
        }
    }

    public static class TypeEnumDeserializer<T>
    extends StdDeserializer<T> {
        private final Map<String, Class<?>> nameToVariant = new HashMap();

        public TypeEnumDeserializer(Class<T> type, Map<String, Class<?>> variants) {
            super(type);
            for (Map.Entry<String, Class<?>> variant : variants.entrySet()) {
                this.nameToVariant.put(variant.getKey(), variant.getValue());
            }
        }

        public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            ObjectNode wireValue = (ObjectNode)p.readValueAsTree();
            if (!wireValue.has("name") || !wireValue.has("value")) {
                throw new RuntimeException("Enum missing 'name' or 'value' fields");
            }
            String name = wireValue.get("name").asText();
            Class<?> variant = this.nameToVariant.get(name);
            if (variant == null) {
                throw new RuntimeException("Unknown variant " + name);
            }
            return (T)wireValue.get("value").traverse(p.getCodec()).readValueAs(variant);
        }
    }
}

