/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.runtime;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import java.util.Locale;
import java.util.Set;
import org.jboss.resteasy.reactive.server.core.CurrentRequestManager;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import xyz.block.ftl.runtime.CurrentRequestServerInterceptor;

public class CurrentRequestClientInterceptor
implements ClientInterceptor {
    public static final Set<String> PROTOCOL_HEADERS = Set.of("content-type", "content-length", "user-agent", "host", "transfer-encoding", "te", "trailer", "accept-encoding", "accept", "accept-language", "connection");
    public static final Metadata.Key<String> FTL_REQUEST_ID = Metadata.Key.of((String)"ftl-request-id", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(this, next.newCall(method, callOptions)){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                String req;
                ResteasyReactiveRequestContext c;
                Metadata current = (Metadata)CurrentRequestServerInterceptor.METADATA.get();
                if (current == null && (c = CurrentRequestManager.get()) != null && (req = c.getRequestHeaders().getHeaderString("ftl-request-id")) != null) {
                    headers.put(FTL_REQUEST_ID, (Object)req);
                }
                if (current != null) {
                    for (String entry : current.keys()) {
                        if (PROTOCOL_HEADERS.contains(entry.toLowerCase(Locale.ENGLISH))) continue;
                        Metadata.Key key = Metadata.Key.of((String)entry, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
                        headers.put(key, (Object)((String)current.get(key)));
                    }
                }
                super.start((ClientCall.Listener)new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(this, responseListener){

                    public void onHeaders(Metadata headers) {
                        super.onHeaders(headers);
                    }
                }, headers);
            }
        };
    }
}

