/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.grpc.stub.StreamObserver;
import io.quarkus.grpc.GrpcService;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Singleton;
import org.jboss.logging.Logger;
import xyz.block.ftl.runtime.VerbRegistry;
import xyz.block.ftl.v1.CallRequest;
import xyz.block.ftl.v1.CallResponse;
import xyz.block.ftl.v1.PingRequest;
import xyz.block.ftl.v1.PingResponse;
import xyz.block.ftl.v1.VerbServiceGrpc;

@Singleton
@GrpcService
public class VerbHandler
extends VerbServiceGrpc.VerbServiceImplBase {
    private static final Logger log = Logger.getLogger(VerbHandler.class);
    final VerbRegistry registry;
    final Instance<ObjectMapper> mapper;

    public VerbHandler(VerbRegistry registry, Instance<ObjectMapper> mapper) {
        this.registry = registry;
        this.mapper = mapper;
    }

    @Override
    public void call(CallRequest request, StreamObserver<CallResponse> responseObserver) {
        try {
            CallResponse response = this.registry.invoke(request, (ObjectMapper)this.mapper.get());
            responseObserver.onNext((Object)response);
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            log.errorf((Throwable)e, "Verb invocation failed: %s.%s", (Object)request.getVerb().getModule(), (Object)request.getVerb().getName());
            responseObserver.onError((Throwable)e);
        }
    }

    @Override
    public void ping(PingRequest request, StreamObserver<PingResponse> responseObserver) {
        responseObserver.onNext((Object)PingResponse.newBuilder().build());
        responseObserver.onCompleted();
    }
}

