/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.runtime;

import java.util.Map;
import java.util.Optional;
import org.jboss.logging.Logger;
import xyz.block.ftl.runtime.DatasourceDetails;
import xyz.block.ftl.runtime.RunnerDetails;
import xyz.block.ftl.v1.GetDeploymentContextResponse;

public class DevModeRunnerDetails
implements RunnerDetails {
    private static final Logger LOG = Logger.getLogger(DevModeRunnerDetails.class);
    private static RuntimeException CLOSED = new RuntimeException("FTL Runner is closed");
    private final Map<String, String> databases;
    private final String proxyAddress;
    private final String deployment;
    private volatile boolean closed;

    public DevModeRunnerDetails(Map<String, String> databases, String proxyAddress, String deployment) {
        this.databases = databases;
        this.proxyAddress = proxyAddress;
        this.deployment = deployment;
    }

    @Override
    public String getProxyAddress() {
        if (this.closed) {
            return null;
        }
        return this.proxyAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForLoad() {
        while (this.proxyAddress == null && !this.closed) {
            DevModeRunnerDetails devModeRunnerDetails = this;
            synchronized (devModeRunnerDetails) {
                if (this.proxyAddress == null && !this.closed) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        if (this.closed) {
            throw CLOSED;
        }
    }

    @Override
    public Optional<DatasourceDetails> getDatabase(String database, GetDeploymentContextResponse.DbType type) {
        this.waitForLoad();
        String address = this.databases.get(database);
        if (address == null) {
            return Optional.empty();
        }
        switch (type) {
            case DB_TYPE_POSTGRES: {
                return Optional.of(new DatasourceDetails("jdbc:postgresql://" + address + "/" + database, "ftl", "ftl"));
            }
            case DB_TYPE_MYSQL: {
                return Optional.of(new DatasourceDetails("jdbc:mysql://" + address + "/" + database, "ftl", "ftl"));
            }
        }
        return Optional.empty();
    }

    @Override
    public String getDeploymentKey() {
        this.waitForLoad();
        return this.deployment;
    }

    @Override
    public synchronized void close() {
        this.closed = true;
        this.notifyAll();
    }
}

