/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.runtime;

import io.quarkus.runtime.LaunchMode;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.jboss.logging.Logger;
import org.jetbrains.annotations.Nullable;
import xyz.block.ftl.LeaseClient;
import xyz.block.ftl.LeaseFailedException;
import xyz.block.ftl.LeaseHandle;
import xyz.block.ftl.hotreload.RunnerInfo;
import xyz.block.ftl.hotreload.RunnerNotification;
import xyz.block.ftl.runtime.DatasourceDetails;
import xyz.block.ftl.runtime.DefaultRunnerDetails;
import xyz.block.ftl.runtime.DevModeRunnerDetails;
import xyz.block.ftl.runtime.FTLRunnerConnection;
import xyz.block.ftl.runtime.FTLRunnerConnectionImpl;
import xyz.block.ftl.runtime.GitVersion;
import xyz.block.ftl.runtime.MockRunnerConnection;
import xyz.block.ftl.runtime.RunnerDetails;
import xyz.block.ftl.v1.GetDeploymentContextResponse;

public class FTLController
implements LeaseClient,
RunnerNotification.RunnerCallback {
    public static final String USE_MOCK_CONNECTION = "ftl.controller.use-mock-connection";
    private static final Logger log = Logger.getLogger(FTLController.class);
    private final List<AtomicBoolean> waiters = new ArrayList<AtomicBoolean>();
    final String moduleName;
    private static volatile FTLController controller;
    private volatile FTLRunnerConnection runnerConnection;
    private volatile RunnerDetails runnerDetails;
    private final Map<String, GetDeploymentContextResponse.DbType> databases = new ConcurrentHashMap<String, GetDeploymentContextResponse.DbType>();
    private long requiredSchemaNumber = -1L;
    private long runnerNumber = -1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FTLController instance() {
        if (controller != null) return controller;
        Class<FTLController> clazz = FTLController.class;
        synchronized (FTLController.class) {
            if (controller != null) return controller;
            GitVersion.logVersion();
            controller = new FTLController();
            // ** MonitorExit[var0] (shouldn't be in output)
            return controller;
        }
    }

    FTLController() {
        this.moduleName = System.getProperty("ftl.module.name");
        if (LaunchMode.current() == LaunchMode.NORMAL) {
            this.runnerDetails = DefaultRunnerDetails.INSTANCE;
        } else if (LaunchMode.current() == LaunchMode.TEST && (this.getClass().getClassLoader().toString().contains("(QuarkusUnitTest)") || Boolean.getBoolean(USE_MOCK_CONNECTION))) {
            this.runnerDetails = DefaultRunnerDetails.INSTANCE;
            this.runnerConnection = new MockRunnerConnection();
        } else {
            RunnerNotification.setCallback((RunnerNotification.RunnerCallback)this);
        }
    }

    public void registerDatabase(String name, GetDeploymentContextResponse.DbType type) {
        this.databases.put(name, type);
    }

    public byte[] getSecret(String secretName) {
        return this.getRunnerConnection().getSecret(secretName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FTLRunnerConnection getRunnerConnection() {
        FTLRunnerConnection rc = this.runnerConnection;
        if (rc == null) {
            FTLController fTLController = this;
            synchronized (fTLController) {
                if (this.runnerDetails == null) {
                    this.waitForRunner();
                    if (this.runnerDetails == null) {
                        log.debugf("Failed to get runner details", new Object[0]);
                        this.runnerConnection = new MockRunnerConnection();
                        return this.runnerConnection;
                    }
                }
                if (this.runnerConnection != null) {
                    return this.runnerConnection;
                }
                this.runnerConnection = new FTLRunnerConnectionImpl(this.runnerDetails.getProxyAddress(), this.runnerDetails.getDeploymentKey(), this.moduleName, new Consumer<FTLRunnerConnection>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void accept(FTLRunnerConnection c) {
                        FTLController fTLController = FTLController.this;
                        synchronized (fTLController) {
                            if (FTLController.this.runnerConnection == c) {
                                FTLController.this.runnerConnection = null;
                                c.close();
                            }
                        }
                    }
                });
                return this.runnerConnection;
            }
        }
        return rc;
    }

    public byte[] getConfig(String config) {
        return this.getRunnerConnection().getConfig(config);
    }

    public DatasourceDetails getDatasource(String name) {
        Optional<DatasourceDetails> address;
        GetDeploymentContextResponse.DbType type;
        if (this.runnerDetails == null) {
            this.waitForRunner();
            if (this.runnerDetails == null) {
                log.debugf("Failed to get runner details", new Object[0]);
                return null;
            }
        }
        if ((type = this.databases.get(name)) != null && (address = this.runnerDetails.getDatabase(name, type)).isPresent()) {
            return address.get();
        }
        List<GetDeploymentContextResponse.DSN> databasesList = this.getRunnerConnection().getDeploymentContext().getDatabasesList();
        for (GetDeploymentContextResponse.DSN i : databasesList) {
            if (!i.getName().equals(name)) continue;
            return DatasourceDetails.fromDSN(i.getDsn(), i.getType());
        }
        return null;
    }

    public byte[] callVerb(String name, String module, byte[] payload) {
        return this.getRunnerConnection().callVerb(name, module, payload);
    }

    public void publishEvent(String topic, String callingVerbName, byte[] event, String key) {
        this.getRunnerConnection().publishEvent(topic, callingVerbName, event, key);
    }

    public String beginTransaction(String databaseName) {
        return this.getRunnerConnection().beginTransaction(databaseName);
    }

    public void commitTransaction(String databaseName, String transactionId) {
        this.getRunnerConnection().commitTransaction(databaseName, transactionId);
    }

    public void rollbackTransaction(String databaseName, String transactionId) {
        this.getRunnerConnection().rollbackTransaction(databaseName, transactionId);
    }

    public String executeQueryOne(String dbName, String sql, String paramsJson, String[] colToFieldName, @Nullable String transactionId) {
        return this.getRunnerConnection().executeQueryOne(dbName, sql, paramsJson, colToFieldName, transactionId);
    }

    public List<String> executeQueryMany(String dbName, String sql, String paramsJson, String[] colToFieldName, @Nullable String transactionId) {
        return this.getRunnerConnection().executeQueryMany(dbName, sql, paramsJson, colToFieldName, transactionId);
    }

    public void executeQueryExec(String dbName, String sql, String paramsJson, @Nullable String transactionId) {
        this.getRunnerConnection().executeQueryExec(dbName, sql, paramsJson, transactionId);
    }

    @Override
    public LeaseHandle acquireLease(Duration duration, String ... keys) throws LeaseFailedException {
        return this.getRunnerConnection().acquireLease(duration, keys);
    }

    public void loadDeploymentContext() {
        this.getRunnerConnection().getDeploymentContext();
    }

    public synchronized boolean runnerDetails(RunnerInfo info) {
        if (info.runnerSeq() < this.runnerNumber) {
            return true;
        }
        if (info.runnerSeq() == this.runnerNumber) {
            return false;
        }
        log.infof("Runner details: runner no: %s schema no: %s address: %s", (Object)info.runnerSeq(), (Object)info.schemaSeq(), (Object)info.address());
        this.runnerNumber = info.runnerSeq();
        this.runnerDetails = new DevModeRunnerDetails(info.databases(), info.address(), info.deployment());
        if (this.runnerConnection != null) {
            this.runnerConnection.close();
            this.runnerConnection = null;
        }
        for (AtomicBoolean waiter : this.waiters) {
            waiter.set(true);
        }
        this.waiters.clear();
        this.notifyAll();
        this.getRunnerConnection();
        return false;
    }

    public synchronized void reloadStarted() {
        for (AtomicBoolean waiter : this.waiters) {
            waiter.set(true);
        }
        this.waiters.clear();
        this.notifyAll();
    }

    public synchronized void newSchemaNumber(long seq) {
        if (seq <= this.requiredSchemaNumber) {
            log.debugf("Received outdated required runner number %s", seq);
            return;
        }
        log.debugf("Expecting new schema seq %s", seq);
        this.requiredSchemaNumber = seq;
    }

    private synchronized void waitForRunner() {
        if (this.runnerDetails != null) {
            return;
        }
        AtomicBoolean gate = new AtomicBoolean();
        this.waiters.add(gate);
        while (!gate.get()) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
    }

    public String getEgress(String name) {
        return this.getRunnerConnection().getEgress(name);
    }
}

