/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.runtime;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.arc.Arc;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import xyz.block.ftl.runtime.CurrentTransaction;
import xyz.block.ftl.runtime.FTLController;

@Singleton
public class VerbClientHelper {
    final ObjectMapper mapper;

    public VerbClientHelper(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public static VerbClientHelper instance() {
        return (VerbClientHelper)Arc.container().instance(VerbClientHelper.class, new Annotation[0]).get();
    }

    public Object call(String verb, String module, Object message, Class<?> returnType, boolean listReturnType, boolean mapReturnType) {
        try {
            byte[] result;
            if (message == null) {
                message = Map.of();
            }
            if ((result = FTLController.instance().callVerb(verb, module, this.mapper.writeValueAsBytes(message))) == null) {
                return null;
            }
            if (listReturnType) {
                return this.mapper.readerForListOf(returnType).readValue(result);
            }
            if (mapReturnType) {
                return this.mapper.readerForMapOf(returnType).readValue(result);
            }
            if (returnType == JsonNode.class) {
                return this.mapper.readTree(result);
            }
            return this.mapper.readerFor(returnType).readValue(result);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String beginTransaction(String databaseName) {
        return FTLController.instance().beginTransaction(databaseName);
    }

    public void commitTransaction(String databaseName, String transactionId) {
        if (transactionId == null) {
            return;
        }
        FTLController.instance().commitTransaction(databaseName, transactionId);
    }

    public void rollbackTransaction(String databaseName, String transactionId) {
        if (transactionId == null) {
            return;
        }
        FTLController.instance().rollbackTransaction(databaseName, transactionId);
    }

    public Object executeQuery(Object message, String dbName, String command, String rawSQL, String[] fields, String[] colToFieldName, Class<?> returnType) throws Exception {
        return this.executeQuery(this.mapper.writeValueAsBytes(message), dbName, command, rawSQL, fields, colToFieldName, returnType, CurrentTransaction.getCurrentId());
    }

    public Object executeQuery(byte[] request, String dbName, String command, String rawSQL, String[] fields, String[] colToFieldName, Class<?> returnType, @Nullable String transactionId) throws Exception {
        if (dbName == null || dbName.isEmpty()) {
            throw new IllegalArgumentException("Database name must be provided in the SQLQueryClient annotation");
        }
        String paramsJson = this.getParamsJson(request, fields);
        String cmd = command.toLowerCase();
        if (cmd.equals("exec")) {
            this.executeExec(dbName, rawSQL, paramsJson, transactionId);
            return null;
        }
        Object result = switch (cmd) {
            case "many" -> this.executeMany(dbName, rawSQL, paramsJson, colToFieldName, returnType, transactionId);
            case "one" -> this.executeOne(dbName, rawSQL, paramsJson, colToFieldName, returnType, transactionId);
            default -> throw new IllegalArgumentException("Unknown command type: " + command);
        };
        return result;
    }

    private Object executeOne(String dbName, String query, String paramsJson, String[] colToFieldName, Class<?> returnType, @Nullable String transactionId) throws Exception {
        String jsonResult = FTLController.instance().executeQueryOne(dbName, query, paramsJson, colToFieldName, transactionId);
        if (jsonResult == null || jsonResult.isEmpty()) {
            return null;
        }
        return this.mapper.readValue(jsonResult, returnType);
    }

    private List<Object> executeMany(String dbName, String query, String paramsJson, String[] colToFieldName, Class<?> returnType, @Nullable String transactionId) throws Exception {
        List<String> results = FTLController.instance().executeQueryMany(dbName, query, paramsJson, colToFieldName, transactionId);
        ArrayList<Object> resultList = new ArrayList<Object>();
        for (String result : results) {
            Object r = this.mapper.readValue(result, returnType);
            resultList.add(r);
        }
        return resultList;
    }

    private void executeExec(String dbName, String query, String paramsJson, @Nullable String transactionId) throws Exception {
        FTLController.instance().executeQueryExec(dbName, query, paramsJson, transactionId);
    }

    private String getParamsJson(byte[] request, String[] fields) throws Exception {
        if (request == null || request.length == 0) {
            return "[]";
        }
        if (fields == null || fields.length == 0) {
            JsonNode jsonNode = this.mapper.readTree(request);
            if (jsonNode.isNull() || jsonNode.isArray() && jsonNode.isEmpty() || jsonNode.isObject() && jsonNode.isEmpty()) {
                return "[]";
            }
            return this.mapper.writeValueAsString(List.of(jsonNode));
        }
        Map requestJsonMap = (Map)this.mapper.readValue(request, (TypeReference)new TypeReference<Map<String, Object>>(this){});
        ArrayList params = new ArrayList();
        for (String field : fields) {
            if (requestJsonMap.containsKey(field)) {
                params.add(requestJsonMap.get(field));
                continue;
            }
            params.add(null);
        }
        return this.mapper.writeValueAsString(params);
    }
}

