/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.runtime;

import io.grpc.Metadata;
import java.net.URI;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import xyz.block.ftl.WorkloadIdentity;
import xyz.block.ftl.runtime.CurrentRequestServerInterceptor;

class WorkloadIdentityImpl
implements WorkloadIdentity {
    public static final String X_FORWARDED_CLIENT_CERT = "x-forwarded-client-cert";
    private final URI uri;
    private final String appID;

    static WorkloadIdentityImpl create() {
        Metadata current = (Metadata)CurrentRequestServerInterceptor.METADATA.get();
        String header = (String)current.get(Metadata.Key.of((String)X_FORWARDED_CLIENT_CERT, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
        if (header == null) {
            return new WorkloadIdentityImpl(null, null);
        }
        Map<String, String> parts = WorkloadIdentityImpl.parseHeader(header);
        String uri = parts.get("uri");
        if (uri == null) {
            return new WorkloadIdentityImpl(null, null);
        }
        URI spiffe = URI.create(uri);
        String[] pathParts = spiffe.getPath().split("/");
        if (pathParts.length >= 4 && pathParts[pathParts.length - 4].equals("ns") && pathParts[pathParts.length - 2].equals("sa")) {
            return new WorkloadIdentityImpl(spiffe, pathParts[pathParts.length - 1]);
        }
        return new WorkloadIdentityImpl(spiffe, null);
    }

    WorkloadIdentityImpl(URI uri, String appID) {
        this.uri = uri;
        this.appID = appID;
    }

    @Override
    public URI spiffeID() {
        if (this.uri == null) {
            throw new RuntimeException("Workload identity is not available");
        }
        return this.uri;
    }

    @Override
    public String appID() {
        if (this.appID == null) {
            throw new RuntimeException("Application identity is not available");
        }
        return this.appID;
    }

    static Map<String, String> parseHeader(String header) {
        String[] pairs;
        HashMap<String, String> parsedValues = new HashMap<String, String>();
        for (String pair : pairs = header.split(";")) {
            String[] keyValue = pair.split("=", 2);
            if (keyValue.length != 2) continue;
            parsedValues.put(keyValue[0].trim().toLowerCase(Locale.ROOT), keyValue[1].trim());
        }
        return parsedValues;
    }
}

