package xyz.block.ftl.v1;

import static io.grpc.MethodDescriptor.generateFullMethodName;

/**
 * <pre>
 * RunnerService is the service that executes Deployments.
 * The Controller will scale the Runner horizontally as required. The Runner will
 * register itself automatically with the ControllerService, which will then
 * assign modules to it.
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.65.1)",
    comments = "Source: xyz/block/ftl/v1/ftl.proto")
@io.grpc.stub.annotations.GrpcGenerated
public final class RunnerServiceGrpc {

  private RunnerServiceGrpc() {}

  public static final java.lang.String SERVICE_NAME = "xyz.block.ftl.v1.RunnerService";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<xyz.block.ftl.v1.PingRequest,
      xyz.block.ftl.v1.PingResponse> getPingMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Ping",
      requestType = xyz.block.ftl.v1.PingRequest.class,
      responseType = xyz.block.ftl.v1.PingResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<xyz.block.ftl.v1.PingRequest,
      xyz.block.ftl.v1.PingResponse> getPingMethod() {
    io.grpc.MethodDescriptor<xyz.block.ftl.v1.PingRequest, xyz.block.ftl.v1.PingResponse> getPingMethod;
    if ((getPingMethod = RunnerServiceGrpc.getPingMethod) == null) {
      synchronized (RunnerServiceGrpc.class) {
        if ((getPingMethod = RunnerServiceGrpc.getPingMethod) == null) {
          RunnerServiceGrpc.getPingMethod = getPingMethod =
              io.grpc.MethodDescriptor.<xyz.block.ftl.v1.PingRequest, xyz.block.ftl.v1.PingResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "Ping"))
              .setSafe(true)
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  xyz.block.ftl.v1.PingRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  xyz.block.ftl.v1.PingResponse.getDefaultInstance()))
              .setSchemaDescriptor(new RunnerServiceMethodDescriptorSupplier("Ping"))
              .build();
        }
      }
    }
    return getPingMethod;
  }

  private static volatile io.grpc.MethodDescriptor<xyz.block.ftl.v1.ReserveRequest,
      xyz.block.ftl.v1.ReserveResponse> getReserveMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Reserve",
      requestType = xyz.block.ftl.v1.ReserveRequest.class,
      responseType = xyz.block.ftl.v1.ReserveResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<xyz.block.ftl.v1.ReserveRequest,
      xyz.block.ftl.v1.ReserveResponse> getReserveMethod() {
    io.grpc.MethodDescriptor<xyz.block.ftl.v1.ReserveRequest, xyz.block.ftl.v1.ReserveResponse> getReserveMethod;
    if ((getReserveMethod = RunnerServiceGrpc.getReserveMethod) == null) {
      synchronized (RunnerServiceGrpc.class) {
        if ((getReserveMethod = RunnerServiceGrpc.getReserveMethod) == null) {
          RunnerServiceGrpc.getReserveMethod = getReserveMethod =
              io.grpc.MethodDescriptor.<xyz.block.ftl.v1.ReserveRequest, xyz.block.ftl.v1.ReserveResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "Reserve"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  xyz.block.ftl.v1.ReserveRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  xyz.block.ftl.v1.ReserveResponse.getDefaultInstance()))
              .setSchemaDescriptor(new RunnerServiceMethodDescriptorSupplier("Reserve"))
              .build();
        }
      }
    }
    return getReserveMethod;
  }

  private static volatile io.grpc.MethodDescriptor<xyz.block.ftl.v1.DeployRequest,
      xyz.block.ftl.v1.DeployResponse> getDeployMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Deploy",
      requestType = xyz.block.ftl.v1.DeployRequest.class,
      responseType = xyz.block.ftl.v1.DeployResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<xyz.block.ftl.v1.DeployRequest,
      xyz.block.ftl.v1.DeployResponse> getDeployMethod() {
    io.grpc.MethodDescriptor<xyz.block.ftl.v1.DeployRequest, xyz.block.ftl.v1.DeployResponse> getDeployMethod;
    if ((getDeployMethod = RunnerServiceGrpc.getDeployMethod) == null) {
      synchronized (RunnerServiceGrpc.class) {
        if ((getDeployMethod = RunnerServiceGrpc.getDeployMethod) == null) {
          RunnerServiceGrpc.getDeployMethod = getDeployMethod =
              io.grpc.MethodDescriptor.<xyz.block.ftl.v1.DeployRequest, xyz.block.ftl.v1.DeployResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "Deploy"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  xyz.block.ftl.v1.DeployRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  xyz.block.ftl.v1.DeployResponse.getDefaultInstance()))
              .setSchemaDescriptor(new RunnerServiceMethodDescriptorSupplier("Deploy"))
              .build();
        }
      }
    }
    return getDeployMethod;
  }

  private static volatile io.grpc.MethodDescriptor<xyz.block.ftl.v1.TerminateRequest,
      xyz.block.ftl.v1.RegisterRunnerRequest> getTerminateMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Terminate",
      requestType = xyz.block.ftl.v1.TerminateRequest.class,
      responseType = xyz.block.ftl.v1.RegisterRunnerRequest.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<xyz.block.ftl.v1.TerminateRequest,
      xyz.block.ftl.v1.RegisterRunnerRequest> getTerminateMethod() {
    io.grpc.MethodDescriptor<xyz.block.ftl.v1.TerminateRequest, xyz.block.ftl.v1.RegisterRunnerRequest> getTerminateMethod;
    if ((getTerminateMethod = RunnerServiceGrpc.getTerminateMethod) == null) {
      synchronized (RunnerServiceGrpc.class) {
        if ((getTerminateMethod = RunnerServiceGrpc.getTerminateMethod) == null) {
          RunnerServiceGrpc.getTerminateMethod = getTerminateMethod =
              io.grpc.MethodDescriptor.<xyz.block.ftl.v1.TerminateRequest, xyz.block.ftl.v1.RegisterRunnerRequest>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "Terminate"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  xyz.block.ftl.v1.TerminateRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  xyz.block.ftl.v1.RegisterRunnerRequest.getDefaultInstance()))
              .setSchemaDescriptor(new RunnerServiceMethodDescriptorSupplier("Terminate"))
              .build();
        }
      }
    }
    return getTerminateMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static RunnerServiceStub newStub(io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<RunnerServiceStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<RunnerServiceStub>() {
        @java.lang.Override
        public RunnerServiceStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new RunnerServiceStub(channel, callOptions);
        }
      };
    return RunnerServiceStub.newStub(factory, channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static RunnerServiceBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<RunnerServiceBlockingStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<RunnerServiceBlockingStub>() {
        @java.lang.Override
        public RunnerServiceBlockingStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new RunnerServiceBlockingStub(channel, callOptions);
        }
      };
    return RunnerServiceBlockingStub.newStub(factory, channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static RunnerServiceFutureStub newFutureStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<RunnerServiceFutureStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<RunnerServiceFutureStub>() {
        @java.lang.Override
        public RunnerServiceFutureStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new RunnerServiceFutureStub(channel, callOptions);
        }
      };
    return RunnerServiceFutureStub.newStub(factory, channel);
  }

  /**
   * <pre>
   * RunnerService is the service that executes Deployments.
   * The Controller will scale the Runner horizontally as required. The Runner will
   * register itself automatically with the ControllerService, which will then
   * assign modules to it.
   * </pre>
   */
  public interface AsyncService {

    /**
     */
    default void ping(xyz.block.ftl.v1.PingRequest request,
        io.grpc.stub.StreamObserver<xyz.block.ftl.v1.PingResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getPingMethod(), responseObserver);
    }

    /**
     * <pre>
     * Reserve synchronously reserves a Runner for a deployment but does nothing else.
     * </pre>
     */
    default void reserve(xyz.block.ftl.v1.ReserveRequest request,
        io.grpc.stub.StreamObserver<xyz.block.ftl.v1.ReserveResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getReserveMethod(), responseObserver);
    }

    /**
     * <pre>
     * Initiate a deployment on this Runner.
     * </pre>
     */
    default void deploy(xyz.block.ftl.v1.DeployRequest request,
        io.grpc.stub.StreamObserver<xyz.block.ftl.v1.DeployResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getDeployMethod(), responseObserver);
    }

    /**
     * <pre>
     * Terminate the deployment on this Runner.
     * </pre>
     */
    default void terminate(xyz.block.ftl.v1.TerminateRequest request,
        io.grpc.stub.StreamObserver<xyz.block.ftl.v1.RegisterRunnerRequest> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getTerminateMethod(), responseObserver);
    }
  }

  /**
   * Base class for the server implementation of the service RunnerService.
   * <pre>
   * RunnerService is the service that executes Deployments.
   * The Controller will scale the Runner horizontally as required. The Runner will
   * register itself automatically with the ControllerService, which will then
   * assign modules to it.
   * </pre>
   */
  public static abstract class RunnerServiceImplBase
      implements io.grpc.BindableService, AsyncService {

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return RunnerServiceGrpc.bindService(this);
    }
  }

  /**
   * A stub to allow clients to do asynchronous rpc calls to service RunnerService.
   * <pre>
   * RunnerService is the service that executes Deployments.
   * The Controller will scale the Runner horizontally as required. The Runner will
   * register itself automatically with the ControllerService, which will then
   * assign modules to it.
   * </pre>
   */
  public static final class RunnerServiceStub
      extends io.grpc.stub.AbstractAsyncStub<RunnerServiceStub> {
    private RunnerServiceStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected RunnerServiceStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new RunnerServiceStub(channel, callOptions);
    }

    /**
     */
    public void ping(xyz.block.ftl.v1.PingRequest request,
        io.grpc.stub.StreamObserver<xyz.block.ftl.v1.PingResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getPingMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Reserve synchronously reserves a Runner for a deployment but does nothing else.
     * </pre>
     */
    public void reserve(xyz.block.ftl.v1.ReserveRequest request,
        io.grpc.stub.StreamObserver<xyz.block.ftl.v1.ReserveResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getReserveMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Initiate a deployment on this Runner.
     * </pre>
     */
    public void deploy(xyz.block.ftl.v1.DeployRequest request,
        io.grpc.stub.StreamObserver<xyz.block.ftl.v1.DeployResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getDeployMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Terminate the deployment on this Runner.
     * </pre>
     */
    public void terminate(xyz.block.ftl.v1.TerminateRequest request,
        io.grpc.stub.StreamObserver<xyz.block.ftl.v1.RegisterRunnerRequest> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getTerminateMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * A stub to allow clients to do synchronous rpc calls to service RunnerService.
   * <pre>
   * RunnerService is the service that executes Deployments.
   * The Controller will scale the Runner horizontally as required. The Runner will
   * register itself automatically with the ControllerService, which will then
   * assign modules to it.
   * </pre>
   */
  public static final class RunnerServiceBlockingStub
      extends io.grpc.stub.AbstractBlockingStub<RunnerServiceBlockingStub> {
    private RunnerServiceBlockingStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected RunnerServiceBlockingStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new RunnerServiceBlockingStub(channel, callOptions);
    }

    /**
     */
    public xyz.block.ftl.v1.PingResponse ping(xyz.block.ftl.v1.PingRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getPingMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Reserve synchronously reserves a Runner for a deployment but does nothing else.
     * </pre>
     */
    public xyz.block.ftl.v1.ReserveResponse reserve(xyz.block.ftl.v1.ReserveRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getReserveMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Initiate a deployment on this Runner.
     * </pre>
     */
    public xyz.block.ftl.v1.DeployResponse deploy(xyz.block.ftl.v1.DeployRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getDeployMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Terminate the deployment on this Runner.
     * </pre>
     */
    public xyz.block.ftl.v1.RegisterRunnerRequest terminate(xyz.block.ftl.v1.TerminateRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getTerminateMethod(), getCallOptions(), request);
    }
  }

  /**
   * A stub to allow clients to do ListenableFuture-style rpc calls to service RunnerService.
   * <pre>
   * RunnerService is the service that executes Deployments.
   * The Controller will scale the Runner horizontally as required. The Runner will
   * register itself automatically with the ControllerService, which will then
   * assign modules to it.
   * </pre>
   */
  public static final class RunnerServiceFutureStub
      extends io.grpc.stub.AbstractFutureStub<RunnerServiceFutureStub> {
    private RunnerServiceFutureStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected RunnerServiceFutureStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new RunnerServiceFutureStub(channel, callOptions);
    }

    /**
     */
    public com.google.common.util.concurrent.ListenableFuture<xyz.block.ftl.v1.PingResponse> ping(
        xyz.block.ftl.v1.PingRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getPingMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Reserve synchronously reserves a Runner for a deployment but does nothing else.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<xyz.block.ftl.v1.ReserveResponse> reserve(
        xyz.block.ftl.v1.ReserveRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getReserveMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Initiate a deployment on this Runner.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<xyz.block.ftl.v1.DeployResponse> deploy(
        xyz.block.ftl.v1.DeployRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getDeployMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Terminate the deployment on this Runner.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<xyz.block.ftl.v1.RegisterRunnerRequest> terminate(
        xyz.block.ftl.v1.TerminateRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getTerminateMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_PING = 0;
  private static final int METHODID_RESERVE = 1;
  private static final int METHODID_DEPLOY = 2;
  private static final int METHODID_TERMINATE = 3;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final AsyncService serviceImpl;
    private final int methodId;

    MethodHandlers(AsyncService serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_PING:
          serviceImpl.ping((xyz.block.ftl.v1.PingRequest) request,
              (io.grpc.stub.StreamObserver<xyz.block.ftl.v1.PingResponse>) responseObserver);
          break;
        case METHODID_RESERVE:
          serviceImpl.reserve((xyz.block.ftl.v1.ReserveRequest) request,
              (io.grpc.stub.StreamObserver<xyz.block.ftl.v1.ReserveResponse>) responseObserver);
          break;
        case METHODID_DEPLOY:
          serviceImpl.deploy((xyz.block.ftl.v1.DeployRequest) request,
              (io.grpc.stub.StreamObserver<xyz.block.ftl.v1.DeployResponse>) responseObserver);
          break;
        case METHODID_TERMINATE:
          serviceImpl.terminate((xyz.block.ftl.v1.TerminateRequest) request,
              (io.grpc.stub.StreamObserver<xyz.block.ftl.v1.RegisterRunnerRequest>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  public static final io.grpc.ServerServiceDefinition bindService(AsyncService service) {
    return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
        .addMethod(
          getPingMethod(),
          io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              xyz.block.ftl.v1.PingRequest,
              xyz.block.ftl.v1.PingResponse>(
                service, METHODID_PING)))
        .addMethod(
          getReserveMethod(),
          io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              xyz.block.ftl.v1.ReserveRequest,
              xyz.block.ftl.v1.ReserveResponse>(
                service, METHODID_RESERVE)))
        .addMethod(
          getDeployMethod(),
          io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              xyz.block.ftl.v1.DeployRequest,
              xyz.block.ftl.v1.DeployResponse>(
                service, METHODID_DEPLOY)))
        .addMethod(
          getTerminateMethod(),
          io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              xyz.block.ftl.v1.TerminateRequest,
              xyz.block.ftl.v1.RegisterRunnerRequest>(
                service, METHODID_TERMINATE)))
        .build();
  }

  private static abstract class RunnerServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    RunnerServiceBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return xyz.block.ftl.v1.Ftl.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("RunnerService");
    }
  }

  private static final class RunnerServiceFileDescriptorSupplier
      extends RunnerServiceBaseDescriptorSupplier {
    RunnerServiceFileDescriptorSupplier() {}
  }

  private static final class RunnerServiceMethodDescriptorSupplier
      extends RunnerServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final java.lang.String methodName;

    RunnerServiceMethodDescriptorSupplier(java.lang.String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (RunnerServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new RunnerServiceFileDescriptorSupplier())
              .addMethod(getPingMethod())
              .addMethod(getReserveMethod())
              .addMethod(getDeployMethod())
              .addMethod(getTerminateMethod())
              .build();
        }
      }
    }
    return result;
  }
}
