/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.runtime;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.quarkus.arc.Unremovable;
import io.quarkus.jackson.ObjectMapperCustomizer;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Base64;
import xyz.block.ftl.TypeAliasMapper;

@Singleton
@Unremovable
public class JsonSerializationConfig
implements ObjectMapperCustomizer {
    final Instance<TypeAliasMapper<?, ?>> instances;

    @Inject
    public JsonSerializationConfig(Instance<TypeAliasMapper<?, ?>> instances) {
        this.instances = instances;
    }

    public void customize(ObjectMapper mapper) {
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        SimpleModule module = new SimpleModule("ByteArraySerializer", new Version(1, 0, 0, ""));
        module.addSerializer(byte[].class, (JsonSerializer)new ByteArraySerializer());
        module.addDeserializer(byte[].class, (JsonDeserializer)new ByteArrayDeserializer());
        mapper.disable(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE);
        for (TypeAliasMapper i : this.instances) {
            Class<?> object = JsonSerializationConfig.extractTypeAliasParam(i.getClass(), 0);
            Class<?> serialized = JsonSerializationConfig.extractTypeAliasParam(i.getClass(), 1);
            module.addSerializer(object, new TypeAliasSerializer(object, serialized, i));
            module.addDeserializer(object, new TypeAliasDeSerializer(object, serialized, i));
        }
        mapper.registerModule((Module)module);
    }

    static Class<?> extractTypeAliasParam(Class<?> target, int no) {
        return (Class)JsonSerializationConfig.extractTypeAliasParamImpl(target, no);
    }

    static Type extractTypeAliasParamImpl(Class<?> target, int no) {
        for (Type i : target.getGenericInterfaces()) {
            if (i instanceof ParameterizedType) {
                ParameterizedType p = (ParameterizedType)i;
                if (p.getRawType().equals(TypeAliasMapper.class)) {
                    return p.getActualTypeArguments()[no];
                }
                Type result = JsonSerializationConfig.extractTypeAliasParamImpl((Class)p.getRawType(), no);
                if (result instanceof Class) {
                    return result;
                }
                if (!(result instanceof TypeVariable)) continue;
                TypeVariable<Class<T>>[] params = ((Class)p.getRawType()).getTypeParameters();
                TypeVariable tv = (TypeVariable)result;
                for (int j = 0; j < params.length; ++j) {
                    if (!params[j].getName().equals(tv.getName())) continue;
                    return p.getActualTypeArguments()[j];
                }
                return tv;
            }
            if (!(i instanceof Class)) continue;
            return JsonSerializationConfig.extractTypeAliasParamImpl((Class)i, no);
        }
        throw new RuntimeException("Could not extract type params from " + target);
    }

    public static class ByteArraySerializer
    extends StdSerializer<byte[]> {
        public ByteArraySerializer() {
            super(byte[].class);
        }

        public void serialize(byte[] value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeString(Base64.getEncoder().encodeToString(value));
        }
    }

    public static class ByteArrayDeserializer
    extends StdDeserializer<byte[]> {
        public ByteArrayDeserializer() {
            super(byte[].class);
        }

        public byte[] deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            String base64 = node.asText();
            return Base64.getDecoder().decode(base64);
        }
    }

    public static class TypeAliasSerializer<T, S>
    extends StdSerializer<T> {
        final TypeAliasMapper<T, S> mapper;
        final Class<S> serializedType;

        public TypeAliasSerializer(Class<T> type, Class<S> serializedType, TypeAliasMapper<T, S> mapper) {
            super(type);
            this.mapper = mapper;
            this.serializedType = serializedType;
        }

        public void serialize(T value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            S s = this.mapper.encode(value);
            gen.writeObject(s);
        }
    }

    public static class TypeAliasDeSerializer<T, S>
    extends StdDeserializer<T> {
        final TypeAliasMapper<T, S> mapper;
        final Class<S> serializedType;

        public TypeAliasDeSerializer(Class<T> type, Class<S> serializedType, TypeAliasMapper<T, S> mapper) {
            super(type);
            this.mapper = mapper;
            this.serializedType = serializedType;
        }

        public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            Object s = ctxt.readValue(p, this.serializedType);
            return this.mapper.decode(s);
        }
    }
}

