/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.java.test.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.ByteString;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.stub.StreamObserver;
import io.quarkus.arc.Arc;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import xyz.block.ftl.v1.CallRequest;
import xyz.block.ftl.v1.CallResponse;
import xyz.block.ftl.v1.PingRequest;
import xyz.block.ftl.v1.PingResponse;
import xyz.block.ftl.v1.VerbServiceGrpc;

public class TestVerbServer
extends VerbServiceGrpc.VerbServiceImplBase {
    final VerbServiceGrpc.VerbServiceStub verbService;
    static final Map<Key, Function<?, ?>> fakeVerbs = new HashMap();

    public TestVerbServer() {
        ManagedChannelBuilder channelBuilder = ManagedChannelBuilder.forAddress((String)"127.0.0.1", (int)8081);
        channelBuilder.usePlaintext();
        ManagedChannel channel = channelBuilder.build();
        this.verbService = VerbServiceGrpc.newStub((Channel)channel);
    }

    public void call(CallRequest request, StreamObserver<CallResponse> responseObserver) {
        Key key = new Key(request.getVerb().getModule(), request.getVerb().getName());
        if (fakeVerbs.containsKey(key)) {
            Method m;
            ObjectMapper mapper = (ObjectMapper)Arc.container().instance(ObjectMapper.class, new Annotation[0]).get();
            Function<?, ?> function = fakeVerbs.get(key);
            Class<?> type = null;
            Method[] methodArray = function.getClass().getMethods();
            int n = methodArray.length;
            for (int i = 0; !(i >= n || (m = methodArray[i]).getName().equals("apply") && m.getParameterCount() == 1 && (type = m.getParameterTypes()[0]) != Object.class); ++i) {
            }
            try {
                Object result = function.apply(mapper.readerFor(type).readValue(request.getBody().newInput()));
                responseObserver.onNext((Object)CallResponse.newBuilder().setBody(ByteString.copyFrom((byte[])mapper.writeValueAsBytes(result))).build());
                responseObserver.onCompleted();
            }
            catch (IOException e) {
                responseObserver.onError((Throwable)e);
            }
            return;
        }
        this.verbService.call(request, responseObserver);
    }

    public void ping(PingRequest request, StreamObserver<PingResponse> responseObserver) {
        responseObserver.onNext((Object)PingResponse.newBuilder().build());
        responseObserver.onCompleted();
    }

    public static <P, R> void registerFakeVerb(String module, String verb, Function<P, R> verbFunction) {
        fakeVerbs.put(new Key(module, verb), verbFunction);
    }

    record Key(String module, String verb) {
    }
}

