/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.kotlin.deployment;

import com.squareup.kotlinpoet.AnnotationSpec;
import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.CodeBlock;
import com.squareup.kotlinpoet.FileSpec;
import com.squareup.kotlinpoet.FunSpec;
import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.ParameterizedTypeName;
import com.squareup.kotlinpoet.PropertySpec;
import com.squareup.kotlinpoet.TypeName;
import com.squareup.kotlinpoet.TypeSpec;
import com.squareup.kotlinpoet.TypeVariableName;
import com.squareup.kotlinpoet.WildcardTypeName;
import java.io.IOException;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import xyz.block.ftl.GeneratedRef;
import xyz.block.ftl.Subscription;
import xyz.block.ftl.TypeAlias;
import xyz.block.ftl.TypeAliasMapper;
import xyz.block.ftl.VerbClient;
import xyz.block.ftl.deployment.JVMCodeGenerator;
import xyz.block.ftl.v1.schema.Data;
import xyz.block.ftl.v1.schema.Enum;
import xyz.block.ftl.v1.schema.EnumVariant;
import xyz.block.ftl.v1.schema.Field;
import xyz.block.ftl.v1.schema.Module;
import xyz.block.ftl.v1.schema.Topic;
import xyz.block.ftl.v1.schema.Type;
import xyz.block.ftl.v1.schema.Verb;

public class KotlinCodeGenerator
extends JVMCodeGenerator {
    public static final String CLIENT = "Client";
    public static final String PACKAGE_PREFIX = "ftl.";
    protected static final Set<String> JAVA_KEYWORDS = Set.of("abstract", "continue", "for", "new", "switch", "assert", "default", "goto", "package", "synchronized", "boolean", "do", "if", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while");

    protected void generateTypeAliasMapper(String module, xyz.block.ftl.v1.schema.TypeAlias typeAlias, String packageName, Optional<String> nativeTypeAlias, Path outputDir) throws IOException {
        String thisType = KotlinCodeGenerator.className((String)typeAlias.getName()) + "TypeAliasMapper";
        TypeSpec.Builder typeBuilder = TypeSpec.interfaceBuilder((String)thisType).addAnnotation(AnnotationSpec.builder(TypeAlias.class).addMember("name=\"" + typeAlias.getName() + "\"", new Object[0]).addMember("module=\"" + module + "\"", new Object[0]).build()).addModifiers(new KModifier[]{KModifier.PUBLIC}).addKdoc(String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)typeAlias.getCommentsList()), new Object[0]);
        if (nativeTypeAlias.isEmpty()) {
            TypeVariableName finalType = TypeVariableName.get((String)"T");
            typeBuilder.addTypeVariable(finalType);
            typeBuilder.addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.bestGuess((String)TypeAliasMapper.class.getName()), (TypeName[])new TypeName[]{finalType, new ClassName("kotlin", new String[]{"String"})}), CodeBlock.of((String)"", (Object[])new Object[0]));
        } else {
            typeBuilder.addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.bestGuess((String)TypeAliasMapper.class.getName()), (TypeName[])new TypeName[]{ClassName.bestGuess((String)nativeTypeAlias.get()), new ClassName("kotlin", new String[]{"String"})}), CodeBlock.of((String)"", (Object[])new Object[0]));
        }
        FileSpec javaFile = FileSpec.builder((String)packageName, (String)thisType).addType(typeBuilder.build()).build();
        javaFile.writeTo(outputDir);
    }

    protected void generateTopicSubscription(Module module, Topic data, String packageName, Map<JVMCodeGenerator.DeclRef, Type> typeAliasMap, Map<JVMCodeGenerator.DeclRef, String> nativeTypeAliasMap, Path outputDir) throws IOException {
        String thisType = KotlinCodeGenerator.className((String)(data.getName() + "Subscription"));
        TypeSpec.Builder dataBuilder = TypeSpec.annotationBuilder((ClassName)ClassName.bestGuess((String)thisType));
        dataBuilder.addModifiers(new KModifier[]{KModifier.PUBLIC});
        if (data.getEvent().hasRef()) {
            dataBuilder.addKdoc("Subscription to the topic of type {@link $L}", new Object[]{data.getEvent().getRef().getName()});
        }
        dataBuilder.addAnnotation(AnnotationSpec.builder(Subscription.class).addMember("topic=\"" + data.getName() + "\"", new Object[0]).addMember("module=\"" + module.getName() + "\"", new Object[0]).addMember("name=\"" + data.getName() + "Subscription\"", new Object[0]).build());
        FileSpec javaFile = FileSpec.builder((String)packageName, (String)thisType).addType(dataBuilder.build()).build();
        javaFile.writeTo(outputDir);
    }

    protected void generateEnum(Module module, Enum data, String packageName, Map<JVMCodeGenerator.DeclRef, Type> typeAliasMap, Map<JVMCodeGenerator.DeclRef, String> nativeTypeAliasMap, Map<JVMCodeGenerator.DeclRef, List<JVMCodeGenerator.EnumInfo>> enumVariantInfoMap, Path outputDir) throws IOException {
        String thisType = KotlinCodeGenerator.className((String)data.getName());
        TypeSpec.Builder dataBuilder = TypeSpec.enumBuilder((String)thisType).addAnnotation(AnnotationSpec.builder(GeneratedRef.class).addMember("name=\"" + data.getName() + "\"", new Object[0]).addMember("module=\"" + module.getName() + "\"", new Object[0]).build()).addModifiers(new KModifier[]{KModifier.PUBLIC}).addKdoc(String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)data.getCommentsList()), new Object[0]);
        for (EnumVariant i : data.getVariantsList()) {
            dataBuilder.addEnumConstant(i.getName());
        }
        FileSpec javaFile = FileSpec.builder((String)packageName, (String)thisType).addType(dataBuilder.build()).build();
        javaFile.writeTo(outputDir);
    }

    protected void generateDataObject(Module module, Data data, String packageName, Map<JVMCodeGenerator.DeclRef, Type> typeAliasMap, Map<JVMCodeGenerator.DeclRef, String> nativeTypeAliasMap, Map<JVMCodeGenerator.DeclRef, List<JVMCodeGenerator.EnumInfo>> enumVariantInfoMap, Path outputDir) throws IOException {
        String thisType = KotlinCodeGenerator.className((String)data.getName());
        TypeSpec.Builder dataBuilder = TypeSpec.classBuilder((String)thisType).addAnnotation(AnnotationSpec.builder(GeneratedRef.class).addMember("name=\"" + data.getName() + "\"", new Object[0]).addMember("module=\"" + module.getName() + "\"", new Object[0]).build()).addModifiers(new KModifier[]{KModifier.PUBLIC}).addKdoc(String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)data.getCommentsList()), new Object[0]);
        if (!data.getFieldsList().isEmpty()) {
            dataBuilder.addModifiers(new KModifier[]{KModifier.DATA});
        }
        for (Object param : data.getTypeParametersList()) {
            dataBuilder.addTypeVariable(TypeVariableName.get((String)param.getName()));
        }
        FunSpec.Builder constructorBuilder = FunSpec.constructorBuilder();
        for (Field i : data.getFieldsList()) {
            TypeName dataType = this.toKotlinTypeName(i.getType(), typeAliasMap, nativeTypeAliasMap);
            String name = i.getName();
            String fieldName = this.toJavaName(name);
            constructorBuilder.addParameter(fieldName, dataType, new KModifier[0]);
            dataBuilder.addProperty(PropertySpec.builder((String)fieldName, (TypeName)dataType, (KModifier[])new KModifier[]{KModifier.PUBLIC}).initializer(fieldName, new Object[0]).build());
        }
        dataBuilder.primaryConstructor(constructorBuilder.build());
        FileSpec javaFile = FileSpec.builder((String)packageName, (String)thisType).addType(dataBuilder.build()).build();
        javaFile.writeTo(outputDir);
    }

    protected void generateVerb(Module module, Verb verb, String packageName, Map<JVMCodeGenerator.DeclRef, Type> typeAliasMap, Map<JVMCodeGenerator.DeclRef, String> nativeTypeAliasMap, Path outputDir) throws IOException {
        String thisType = KotlinCodeGenerator.className((String)verb.getName()) + CLIENT;
        TypeSpec.Builder typeBuilder = TypeSpec.interfaceBuilder((String)thisType).addAnnotation(AnnotationSpec.builder(VerbClient.class).addMember("name=\"" + verb.getName() + "\"", new Object[0]).addMember("module=\"" + module.getName() + "\"", new Object[0]).build()).addModifiers(new KModifier[]{KModifier.PUBLIC}).addKdoc("A client for the %L.%L verb", new Object[]{module.getName(), verb.getName()});
        String comments = String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)verb.getCommentsList());
        if (verb.getRequest().hasUnit() && verb.getResponse().hasUnit()) {
            typeBuilder.addFunction(FunSpec.builder((String)"call").addModifiers(new KModifier[]{KModifier.ABSTRACT, KModifier.PUBLIC}).addKdoc(comments, new Object[0]).build());
        } else if (verb.getRequest().hasUnit()) {
            typeBuilder.addFunction(FunSpec.builder((String)"call").returns(this.toKotlinTypeName(verb.getResponse(), typeAliasMap, nativeTypeAliasMap)).addModifiers(new KModifier[]{KModifier.PUBLIC, KModifier.ABSTRACT}).addKdoc(comments, new Object[0]).build());
        } else if (verb.getResponse().hasUnit()) {
            typeBuilder.addFunction(FunSpec.builder((String)"call").addModifiers(new KModifier[]{KModifier.ABSTRACT}).addParameter("value", this.toKotlinTypeName(verb.getRequest(), typeAliasMap, nativeTypeAliasMap), new KModifier[0]).addKdoc(comments, new Object[0]).build());
        } else {
            typeBuilder.addFunction(FunSpec.builder((String)"call").returns(this.toKotlinTypeName(verb.getResponse(), typeAliasMap, nativeTypeAliasMap)).addParameter("value", this.toKotlinTypeName(verb.getRequest(), typeAliasMap, nativeTypeAliasMap), new KModifier[0]).addModifiers(new KModifier[]{KModifier.PUBLIC, KModifier.ABSTRACT}).addKdoc(comments, new Object[0]).build());
        }
        FileSpec javaFile = FileSpec.builder((String)packageName, (String)thisType).addType(typeBuilder.build()).build();
        javaFile.writeTo(outputDir);
    }

    private String toJavaName(String name) {
        if (JAVA_KEYWORDS.contains(name)) {
            return name + "_";
        }
        return name;
    }

    private ClassName className(Class<?> clazz) {
        if (clazz.getEnclosingClass() != null) {
            return this.className(clazz.getEnclosingClass()).nestedClass(clazz.getSimpleName());
        }
        return new ClassName(clazz.getPackage().getName(), new String[]{clazz.getSimpleName()});
    }

    private TypeName toKotlinTypeName(Type type, Map<JVMCodeGenerator.DeclRef, Type> typeAliasMap, Map<JVMCodeGenerator.DeclRef, String> nativeTypeAliasMap) {
        if (type.hasArray()) {
            return ParameterizedTypeName.get((ClassName)new ClassName("kotlin.collections", new String[]{"List"}), (TypeName)this.toKotlinTypeName(type.getArray().getElement(), typeAliasMap, nativeTypeAliasMap));
        }
        if (type.hasString()) {
            return new ClassName("kotlin", new String[]{"String"});
        }
        if (type.hasOptional()) {
            return this.toKotlinTypeName(type.getOptional().getType(), typeAliasMap, nativeTypeAliasMap).copy(true, List.of());
        }
        if (type.hasRef()) {
            if (type.getRef().getModule().isEmpty()) {
                return TypeVariableName.get((String)type.getRef().getName());
            }
            JVMCodeGenerator.DeclRef key = new JVMCodeGenerator.DeclRef(type.getRef().getModule(), type.getRef().getName());
            if (nativeTypeAliasMap.containsKey(key)) {
                String className = nativeTypeAliasMap.get(key);
                int idx = className.lastIndexOf(46);
                if (idx != -1) {
                    return new ClassName(className.substring(0, idx), new String[]{className.substring(idx + 1)});
                }
                return new ClassName("", new String[]{className});
            }
            if (typeAliasMap.containsKey(key)) {
                return this.toKotlinTypeName(typeAliasMap.get(key), typeAliasMap, nativeTypeAliasMap);
            }
            List params = type.getRef().getTypeParametersList();
            ClassName className = new ClassName(PACKAGE_PREFIX + type.getRef().getModule(), new String[]{type.getRef().getName()});
            if (params.isEmpty()) {
                return className;
            }
            List<TypeName> javaTypes = params.stream().map(s -> s.hasUnit() ? WildcardTypeName.consumerOf((TypeName)new ClassName("kotlin", new String[]{"Any"})) : this.toKotlinTypeName((Type)s, typeAliasMap, nativeTypeAliasMap)).toList();
            return ParameterizedTypeName.get((ClassName)className, (TypeName[])javaTypes.toArray(new TypeName[javaTypes.size()]));
        }
        if (type.hasMap()) {
            return ParameterizedTypeName.get((ClassName)new ClassName("kotlin.collections", new String[]{"Map"}), (TypeName[])new TypeName[]{this.toKotlinTypeName(type.getMap().getKey(), typeAliasMap, nativeTypeAliasMap), this.toKotlinTypeName(type.getMap().getValue(), typeAliasMap, nativeTypeAliasMap)});
        }
        if (type.hasTime()) {
            return this.className(ZonedDateTime.class);
        }
        if (type.hasInt()) {
            return new ClassName("kotlin", new String[]{"Long"});
        }
        if (type.hasUnit()) {
            return new ClassName("kotlin", new String[]{"Unit"});
        }
        if (type.hasBool()) {
            return new ClassName("kotlin", new String[]{"Boolean"});
        }
        if (type.hasFloat()) {
            return new ClassName("kotlin", new String[]{"Double"});
        }
        if (type.hasBytes()) {
            return new ClassName("kotlin", new String[]{"ByteArray"});
        }
        if (type.hasAny()) {
            return new ClassName("kotlin", new String[]{"Any"});
        }
        throw new RuntimeException("Cannot generate Kotlin type name: " + type);
    }
}

