/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.kotlin.deployment;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.squareup.kotlinpoet.AnnotationSpec;
import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.CodeBlock;
import com.squareup.kotlinpoet.FileSpec;
import com.squareup.kotlinpoet.FunSpec;
import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.ParameterizedTypeName;
import com.squareup.kotlinpoet.PropertySpec;
import com.squareup.kotlinpoet.TypeName;
import com.squareup.kotlinpoet.TypeNames;
import com.squareup.kotlinpoet.TypeSpec;
import com.squareup.kotlinpoet.TypeVariableName;
import com.squareup.kotlinpoet.WildcardTypeName;
import java.io.IOException;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import xyz.block.ftl.ConsumableTopic;
import xyz.block.ftl.Enum;
import xyz.block.ftl.EnumHolder;
import xyz.block.ftl.GeneratedRef;
import xyz.block.ftl.Topic;
import xyz.block.ftl.TypeAlias;
import xyz.block.ftl.TypeAliasMapper;
import xyz.block.ftl.VerbClient;
import xyz.block.ftl.deployment.JVMCodeGenerator;
import xyz.block.ftl.deployment.VerbType;
import xyz.block.ftl.schema.v1.Data;
import xyz.block.ftl.schema.v1.EnumVariant;
import xyz.block.ftl.schema.v1.Field;
import xyz.block.ftl.schema.v1.Metadata;
import xyz.block.ftl.schema.v1.Module;
import xyz.block.ftl.schema.v1.Type;
import xyz.block.ftl.schema.v1.TypeParameter;
import xyz.block.ftl.schema.v1.Value;
import xyz.block.ftl.schema.v1.Verb;

public class KotlinCodeGenerator
extends JVMCodeGenerator {
    public static final String CLIENT = "Client";
    public static final String PACKAGE_PREFIX = "ftl.";
    protected static final Set<String> JAVA_KEYWORDS = Set.of("abstract", "continue", "for", "new", "switch", "assert", "default", "goto", "package", "synchronized", "boolean", "do", "if", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while");

    protected void generateTypeAliasMapper(String module, xyz.block.ftl.schema.v1.TypeAlias typeAlias, String packageName, Optional<String> nativeTypeAlias, Path outputDir) throws IOException {
        String thisType = KotlinCodeGenerator.className((String)typeAlias.getName()) + "TypeAliasMapper";
        TypeSpec.Builder typeBuilder = TypeSpec.interfaceBuilder((String)thisType).addAnnotation(AnnotationSpec.builder(TypeAlias.class).addMember("name=\"" + typeAlias.getName() + "\"", new Object[0]).addMember("module=\"" + module + "\"", new Object[0]).build()).addModifiers(new KModifier[]{KModifier.PUBLIC}).addKdoc(String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)typeAlias.getCommentsList()), new Object[0]);
        if (nativeTypeAlias.isEmpty()) {
            TypeVariableName finalType = TypeVariableName.get((String)"T");
            typeBuilder.addTypeVariable(finalType);
            typeBuilder.addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.bestGuess((String)TypeAliasMapper.class.getName()), (TypeName[])new TypeName[]{finalType, new ClassName("kotlin", new String[]{"String"})}), CodeBlock.of((String)"", (Object[])new Object[0]));
        } else {
            typeBuilder.addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.bestGuess((String)TypeAliasMapper.class.getName()), (TypeName[])new TypeName[]{ClassName.bestGuess((String)nativeTypeAlias.get()), new ClassName("kotlin", new String[]{"String"})}), CodeBlock.of((String)"", (Object[])new Object[0]));
        }
        FileSpec javaFile = FileSpec.builder((String)packageName, (String)thisType).addType(typeBuilder.build()).build();
        javaFile.writeTo(outputDir);
    }

    protected void generateTopicConsumer(Module module, xyz.block.ftl.schema.v1.Topic data, String packageName, Map<JVMCodeGenerator.DeclRef, Type> typeAliasMap, Map<JVMCodeGenerator.DeclRef, String> nativeTypeAliasMap, Path outputDir) throws IOException {
        String thisType = KotlinCodeGenerator.className((String)(data.getName() + "Topic"));
        TypeSpec.Builder dataBuilder = TypeSpec.interfaceBuilder((ClassName)ClassName.bestGuess((String)thisType));
        dataBuilder.addSuperinterface((TypeName)ClassName.bestGuess((String)ConsumableTopic.class.getName()), CodeBlock.of((String)"", (Object[])new Object[0]));
        dataBuilder.addModifiers(new KModifier[]{KModifier.PUBLIC});
        if (data.getEvent().hasRef()) {
            dataBuilder.addKdoc("Subscription to the topic of type {@link $L}", new Object[]{data.getEvent().getRef().getName()});
        }
        int partitions = 1;
        for (Metadata metadata : data.getMetadataList()) {
            if (!metadata.hasPartitions()) continue;
            partitions = (int)metadata.getPartitions().getPartitions();
            break;
        }
        dataBuilder.addAnnotation(AnnotationSpec.builder(Topic.class).addMember("name=\"" + data.getName() + "\"", new Object[0]).addMember("module=\"" + module.getName() + "\"", new Object[0]).addMember("partitions=" + String.valueOf(partitions), new Object[0]).build());
        FileSpec javaFile = FileSpec.builder((String)packageName, (String)thisType).addType(dataBuilder.build()).build();
        javaFile.writeTo(outputDir);
    }

    protected void generateEnum(Module module, xyz.block.ftl.schema.v1.Enum data, String packageName, Map<JVMCodeGenerator.DeclRef, Type> typeAliasMap, Map<JVMCodeGenerator.DeclRef, String> nativeTypeAliasMap, Map<JVMCodeGenerator.DeclRef, List<JVMCodeGenerator.EnumInfo>> enumVariantInfoMap, Path outputDir) throws IOException {
        String thisType = KotlinCodeGenerator.className((String)data.getName());
        if (data.hasType()) {
            TypeSpec.Builder dataBuilder = TypeSpec.enumBuilder((String)thisType).addAnnotation(KotlinCodeGenerator.getGeneratedRefAnnotation(module.getName(), data.getName())).addAnnotation(AnnotationSpec.builder(Enum.class).build()).addModifiers(new KModifier[]{KModifier.PUBLIC}).addKdoc(String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)data.getCommentsList()), new Object[0]);
            TypeName enumType = this.toKotlinTypeName(data.getType(), typeAliasMap, nativeTypeAliasMap);
            dataBuilder.primaryConstructor(FunSpec.constructorBuilder().addParameter("value", enumType, new KModifier[0]).build()).addProperty(PropertySpec.builder((String)"value", (TypeName)enumType, (KModifier[])new KModifier[]{KModifier.FINAL}).initializer("value", new Object[0]).build()).build();
            String format = data.getType().hasString() ? "%S" : "%L";
            for (EnumVariant i : data.getVariantsList()) {
                Object value = this.toKotlinValue(i.getValue());
                dataBuilder.addEnumConstant(i.getName(), TypeSpec.anonymousClassBuilder().addSuperclassConstructorParameter(format, new Object[]{value}).build());
            }
            FileSpec kotlinFile = FileSpec.builder((String)packageName, (String)thisType).addType(dataBuilder.build()).build();
            kotlinFile.writeTo(outputDir);
        } else {
            TypeSpec.Builder interfaceBuilder = TypeSpec.interfaceBuilder((String)thisType).addAnnotation(KotlinCodeGenerator.getGeneratedRefAnnotation(module.getName(), data.getName())).addAnnotation(AnnotationSpec.builder(Enum.class).build()).addModifiers(new KModifier[]{KModifier.PUBLIC, KModifier.SEALED}).addKdoc(String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)data.getCommentsList()), new Object[0]);
            Map<String, TypeName> variantValuesTypes = data.getVariantsList().stream().collect(Collectors.toMap(EnumVariant::getName, v -> this.toKotlinTypeName(v.getValue().getTypeValue().getValue(), typeAliasMap, nativeTypeAliasMap)));
            for (EnumVariant variant : data.getVariantsList()) {
                String name = variant.getName();
                TypeName valueTypeName = variantValuesTypes.get(name);
                interfaceBuilder.addFunction(FunSpec.builder((String)("is" + name)).addModifiers(new KModifier[]{KModifier.PUBLIC, KModifier.ABSTRACT}).addAnnotation(JsonIgnore.class).returns((TypeName)TypeNames.BOOLEAN).build());
                interfaceBuilder.addFunction(FunSpec.builder((String)("get" + name)).addModifiers(new KModifier[]{KModifier.PUBLIC, KModifier.ABSTRACT}).addAnnotation(JsonIgnore.class).returns(valueTypeName).build());
                if (variant.getValue().getTypeValue().getValue().hasRef()) {
                    JVMCodeGenerator.DeclRef key = new JVMCodeGenerator.DeclRef(module.getName(), name);
                    List variantInfos = enumVariantInfoMap.computeIfAbsent(key, k -> new ArrayList());
                    variantInfos.add(new JVMCodeGenerator.EnumInfo(thisType, variant, data.getVariantsList()));
                    continue;
                }
                TypeSpec.Builder dataBuilder = TypeSpec.classBuilder((String)KotlinCodeGenerator.className((String)name)).addAnnotation(KotlinCodeGenerator.getGeneratedRefAnnotation(module.getName(), name)).addAnnotation(AnnotationSpec.builder(EnumHolder.class).build()).addModifiers(new KModifier[]{KModifier.PUBLIC, KModifier.FINAL});
                dataBuilder.primaryConstructor(FunSpec.constructorBuilder().addParameter("value", valueTypeName, new KModifier[0]).build()).addProperty(PropertySpec.builder((String)"value", (TypeName)valueTypeName, (KModifier[])new KModifier[]{KModifier.FINAL}).initializer("value", new Object[0]).build()).build();
                KotlinCodeGenerator.addTypeEnumInterfaceMethods(packageName, thisType, dataBuilder, name, valueTypeName, variantValuesTypes, false);
                FileSpec wrapperFile = FileSpec.builder((String)packageName, (String)name).addType(dataBuilder.build()).build();
                wrapperFile.writeTo(outputDir);
            }
            FileSpec interfaceFile = FileSpec.builder((String)packageName, (String)thisType).addType(interfaceBuilder.build()).build();
            interfaceFile.writeTo(outputDir);
        }
    }

    protected void generateDataObject(Module module, Data data, String packageName, Map<JVMCodeGenerator.DeclRef, Type> typeAliasMap, Map<JVMCodeGenerator.DeclRef, String> nativeTypeAliasMap, Map<JVMCodeGenerator.DeclRef, List<JVMCodeGenerator.EnumInfo>> enumVariantInfoMap, Path outputDir) throws IOException {
        String thisType = KotlinCodeGenerator.className((String)data.getName());
        TypeSpec.Builder dataBuilder = TypeSpec.classBuilder((String)thisType).addAnnotation(KotlinCodeGenerator.getGeneratedRefAnnotation(module.getName(), data.getName())).addModifiers(new KModifier[]{KModifier.PUBLIC}).addKdoc(String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)data.getCommentsList()), new Object[0]);
        if (!data.getFieldsList().isEmpty()) {
            dataBuilder.addModifiers(new KModifier[]{KModifier.DATA});
        }
        for (TypeParameter param : data.getTypeParametersList()) {
            dataBuilder.addTypeVariable(TypeVariableName.get((String)param.getName()));
        }
        FunSpec.Builder constructorBuilder = FunSpec.constructorBuilder();
        JVMCodeGenerator.DeclRef key = new JVMCodeGenerator.DeclRef(module.getName(), data.getName());
        if (enumVariantInfoMap.containsKey(key)) {
            for (JVMCodeGenerator.EnumInfo enumVariantInfo : enumVariantInfoMap.get(key)) {
                String name = enumVariantInfo.variant().getName();
                ClassName variantTypeName = new ClassName(packageName, new String[]{name});
                Map<String, TypeName> variantValuesTypes = enumVariantInfo.otherVariants().stream().collect(Collectors.toMap(EnumVariant::getName, v -> this.toKotlinTypeName(v.getValue().getTypeValue().getValue(), typeAliasMap, nativeTypeAliasMap)));
                KotlinCodeGenerator.addTypeEnumInterfaceMethods(packageName, enumVariantInfo.interfaceType(), dataBuilder, name, (TypeName)variantTypeName, variantValuesTypes, true);
            }
        }
        for (Field i : data.getFieldsList()) {
            TypeName dataType = this.toKotlinTypeName(i.getType(), typeAliasMap, nativeTypeAliasMap);
            String name = i.getName();
            String fieldName = this.toJavaName(name);
            constructorBuilder.addParameter(fieldName, dataType, new KModifier[0]);
            dataBuilder.addProperty(PropertySpec.builder((String)fieldName, (TypeName)dataType, (KModifier[])new KModifier[]{KModifier.PUBLIC}).initializer(fieldName, new Object[0]).build());
        }
        dataBuilder.primaryConstructor(constructorBuilder.build());
        FileSpec kotlinClass = FileSpec.builder((String)packageName, (String)thisType).addType(dataBuilder.build()).build();
        kotlinClass.writeTo(outputDir);
    }

    protected void generateVerb(Module module, Verb verb, String packageName, Map<JVMCodeGenerator.DeclRef, Type> typeAliasMap, Map<JVMCodeGenerator.DeclRef, String> nativeTypeAliasMap, Path outputDir) throws IOException {
        String name = verb.getName();
        String thisType = KotlinCodeGenerator.className((String)name) + CLIENT;
        TypeSpec.Builder typeBuilder = TypeSpec.interfaceBuilder((String)thisType).addModifiers(new KModifier[]{KModifier.PUBLIC}).addKdoc("A client for the %L.%L verb", new Object[]{module.getName(), name});
        FunSpec.Builder callFunc = FunSpec.builder((String)name).addModifiers(new KModifier[]{KModifier.ABSTRACT, KModifier.PUBLIC}).addAnnotation(AnnotationSpec.builder(VerbClient.class).addMember("module=\"" + module.getName() + "\"", new Object[0]).build()).addKdoc(String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)verb.getCommentsList()), new Object[0]);
        VerbType verbType = VerbType.of((Verb)verb);
        if (verbType == VerbType.SINK || verbType == VerbType.VERB) {
            callFunc.addParameter("value", this.toKotlinTypeName(verb.getRequest(), typeAliasMap, nativeTypeAliasMap), new KModifier[0]);
        }
        if (verbType == VerbType.SOURCE || verbType == VerbType.VERB) {
            callFunc.returns(this.toKotlinTypeName(verb.getResponse(), typeAliasMap, nativeTypeAliasMap));
        }
        typeBuilder.addFunction(callFunc.build());
        FileSpec javaFile = FileSpec.builder((String)packageName, (String)thisType).addType(typeBuilder.build()).build();
        javaFile.writeTo(outputDir);
    }

    private String toJavaName(String name) {
        if (JAVA_KEYWORDS.contains(name)) {
            return name + "_";
        }
        return name;
    }

    private ClassName className(Class<?> clazz) {
        if (clazz.getEnclosingClass() != null) {
            return this.className(clazz.getEnclosingClass()).nestedClass(clazz.getSimpleName());
        }
        return new ClassName(clazz.getPackage().getName(), new String[]{clazz.getSimpleName()});
    }

    private TypeName toKotlinTypeName(Type type, Map<JVMCodeGenerator.DeclRef, Type> typeAliasMap, Map<JVMCodeGenerator.DeclRef, String> nativeTypeAliasMap) {
        if (type.hasArray()) {
            return ParameterizedTypeName.get((ClassName)new ClassName("kotlin.collections", new String[]{"List"}), (TypeName)this.toKotlinTypeName(type.getArray().getElement(), typeAliasMap, nativeTypeAliasMap));
        }
        if (type.hasString()) {
            return new ClassName("kotlin", new String[]{"String"});
        }
        if (type.hasOptional()) {
            return this.toKotlinTypeName(type.getOptional().getType(), typeAliasMap, nativeTypeAliasMap).copy(true, List.of());
        }
        if (type.hasRef()) {
            if (type.getRef().getModule().isEmpty()) {
                return TypeVariableName.get((String)type.getRef().getName());
            }
            JVMCodeGenerator.DeclRef key = new JVMCodeGenerator.DeclRef(type.getRef().getModule(), type.getRef().getName());
            if (nativeTypeAliasMap.containsKey(key)) {
                String className = nativeTypeAliasMap.get(key);
                int idx = className.lastIndexOf(46);
                if (idx != -1) {
                    return new ClassName(className.substring(0, idx), new String[]{className.substring(idx + 1)});
                }
                return new ClassName("", new String[]{className});
            }
            if (typeAliasMap.containsKey(key)) {
                return this.toKotlinTypeName(typeAliasMap.get(key), typeAliasMap, nativeTypeAliasMap);
            }
            List params = type.getRef().getTypeParametersList();
            ClassName className = new ClassName(PACKAGE_PREFIX + type.getRef().getModule(), new String[]{type.getRef().getName()});
            if (params.isEmpty()) {
                return className;
            }
            List<TypeName> javaTypes = params.stream().map(s -> s.hasUnit() ? WildcardTypeName.consumerOf((TypeName)new ClassName("kotlin", new String[]{"Any"})) : this.toKotlinTypeName((Type)s, typeAliasMap, nativeTypeAliasMap)).toList();
            return ParameterizedTypeName.get((ClassName)className, (TypeName[])javaTypes.toArray(new TypeName[javaTypes.size()]));
        }
        if (type.hasMap()) {
            return ParameterizedTypeName.get((ClassName)new ClassName("kotlin.collections", new String[]{"Map"}), (TypeName[])new TypeName[]{this.toKotlinTypeName(type.getMap().getKey(), typeAliasMap, nativeTypeAliasMap), this.toKotlinTypeName(type.getMap().getValue(), typeAliasMap, nativeTypeAliasMap)});
        }
        if (type.hasTime()) {
            return this.className(ZonedDateTime.class);
        }
        if (type.hasInt()) {
            return new ClassName("kotlin", new String[]{"Long"});
        }
        if (type.hasUnit()) {
            return new ClassName("kotlin", new String[]{"Unit"});
        }
        if (type.hasBool()) {
            return new ClassName("kotlin", new String[]{"Boolean"});
        }
        if (type.hasFloat()) {
            return new ClassName("kotlin", new String[]{"Double"});
        }
        if (type.hasBytes()) {
            return new ClassName("kotlin", new String[]{"ByteArray"});
        }
        if (type.hasAny()) {
            return new ClassName("kotlin", new String[]{"Any"});
        }
        throw new RuntimeException("Cannot generate Kotlin type name: " + String.valueOf(type));
    }

    private static void addTypeEnumInterfaceMethods(String packageName, String interfaceType, TypeSpec.Builder dataBuilder, String enumVariantName, TypeName variantTypeName, Map<String, TypeName> variantValuesTypes, boolean returnSelf) {
        dataBuilder.addSuperinterface((TypeName)new ClassName(packageName, new String[]{interfaceType}), CodeBlock.of((String)"", (Object[])new Object[0]));
        dataBuilder.addFunction(KotlinCodeGenerator.makeIsFunc(enumVariantName, true));
        dataBuilder.addFunction(KotlinCodeGenerator.makeGetFunc(enumVariantName, variantTypeName, "return " + (returnSelf ? "this" : "value")).addModifiers(new KModifier[]{KModifier.OVERRIDE}).build());
        for (Map.Entry<String, TypeName> variant : variantValuesTypes.entrySet()) {
            if (variant.getKey().equals(enumVariantName)) continue;
            dataBuilder.addFunction(KotlinCodeGenerator.makeIsFunc(variant.getKey(), false));
            dataBuilder.addFunction(KotlinCodeGenerator.makeGetFunc(variant.getKey(), variant.getValue(), "throw UnsupportedOperationException()").addModifiers(new KModifier[]{KModifier.OVERRIDE}).build());
        }
    }

    @NotNull
    private static AnnotationSpec getGeneratedRefAnnotation(String module, String name) {
        return AnnotationSpec.builder(GeneratedRef.class).addMember("name=\"" + name + "\"", new Object[0]).addMember("module=\"" + module + "\"", new Object[0]).build();
    }

    @NotNull
    private static FunSpec.Builder makeGetFunc(String name, TypeName type, String returnStatement) {
        return FunSpec.builder((String)("get" + name)).addModifiers(new KModifier[]{KModifier.PUBLIC}).addAnnotation(JsonIgnore.class).addStatement(returnStatement, new Object[0]).returns(type);
    }

    private static FunSpec makeIsFunc(String name, boolean val) {
        return FunSpec.builder((String)("is" + name)).addModifiers(new KModifier[]{KModifier.PUBLIC, KModifier.OVERRIDE}).addAnnotation(JsonIgnore.class).returns((TypeName)TypeNames.BOOLEAN).addStatement("return " + val, new Object[0]).build();
    }

    private Object toKotlinValue(Value value) {
        if (value.hasIntValue()) {
            return value.getIntValue().getValue();
        }
        if (value.hasStringValue()) {
            return value.getStringValue().getValue();
        }
        if (value.hasTypeValue()) {
            throw new RuntimeException("Cannot generate TypeValue: " + String.valueOf(value));
        }
        throw new RuntimeException("Cannot generate Java value: " + String.valueOf(value));
    }
}

