/*
 * Decompiled with CFR 0.152.
 */
package tbdex.sdk.httpclient;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tbdex.sdk.httpclient.RequestToken;
import tbdex.sdk.httpclient.TbdexHttpClient;
import tbdex.sdk.httpclient.UtilsKt;
import tbdex.sdk.httpclient.models.CreateExchangeRequest;
import tbdex.sdk.httpclient.models.GetExchangesFilter;
import tbdex.sdk.httpclient.models.GetOfferingsFilter;
import tbdex.sdk.httpclient.models.TbdexResponseException;
import tbdex.sdk.protocol.Validator;
import tbdex.sdk.protocol.models.Close;
import tbdex.sdk.protocol.models.Message;
import tbdex.sdk.protocol.models.Offering;
import tbdex.sdk.protocol.models.Order;
import tbdex.sdk.protocol.models.Rfq;
import tbdex.sdk.protocol.serialization.Json;
import web5.sdk.dids.Did;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0004J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\nH\u0002J(\u0010\u0019\u001a\f\u0012\u0004\u0012\u00020\u001b0\u001aj\u0002`\u001c2\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0004J2\u0010!\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u001b0\u001aj\u0002`\u001c0\u001a2\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001f2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#J \u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u001a2\u0006\u0010\u001d\u001a\u00020\u00042\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010&J \u0010'\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\rH\u0002J\u000e\u0010*\u001a\u00020\u00132\u0006\u0010+\u001a\u00020,J\u000e\u0010-\u001a\u00020\u00132\u0006\u0010.\u001a\u00020/J\u0010\u00100\u001a\u00020\u00132\u0006\u00101\u001a\u00020\u001bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Ltbdex/sdk/httpclient/TbdexHttpClient;", "", "()V", "JSON_HEADER", "", "client", "Lokhttp3/OkHttpClient;", "jsonMediaType", "Lokhttp3/MediaType;", "buildRequest", "Lokhttp3/Request;", "url", "body", "Lokhttp3/RequestBody;", "buildResponseException", "Ltbdex/sdk/httpclient/models/TbdexResponseException;", "response", "Lokhttp3/Response;", "createExchange", "", "rfq", "Ltbdex/sdk/protocol/models/Rfq;", "replyTo", "executeRequest", "request", "getExchange", "", "Ltbdex/sdk/protocol/models/Message;", "Ltbdex/sdk/httpclient/models/Exchange;", "pfiDid", "requesterDid", "Lweb5/sdk/dids/Did;", "exchangeId", "getExchanges", "filter", "Ltbdex/sdk/httpclient/models/GetExchangesFilter;", "getOfferings", "Ltbdex/sdk/protocol/models/Offering;", "Ltbdex/sdk/httpclient/models/GetOfferingsFilter;", "sendMessage", "path", "requestBody", "submitClose", "close", "Ltbdex/sdk/protocol/models/Close;", "submitOrder", "order", "Ltbdex/sdk/protocol/models/Order;", "validateMessage", "message", "httpclient"})
@SourceDebugExtension(value={"SMAP\nTbdexHttpClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TbdexHttpClient.kt\ntbdex/sdk/httpclient/TbdexHttpClient\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 7 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,300:1\n1#2:301\n56#3:302\n43#3:303\n494#4,7:304\n215#5,2:311\n1855#6,2:313\n32#7,2:315\n*S KotlinDebug\n*F\n+ 1 TbdexHttpClient.kt\ntbdex/sdk/httpclient/TbdexHttpClient\n*L\n49#1:302\n49#1:303\n50#1:304,7\n52#1:311,2\n224#1:313,2\n241#1:315,2\n*E\n"})
public final class TbdexHttpClient {
    @NotNull
    public static final TbdexHttpClient INSTANCE = new TbdexHttpClient();
    @NotNull
    private static final OkHttpClient client = new OkHttpClient();
    @NotNull
    private static final MediaType jsonMediaType = MediaType.Companion.get("application/json; charset=utf-8");
    @NotNull
    private static final String JSON_HEADER = "application/json";

    private TbdexHttpClient() {
    }

    @NotNull
    public final List<Offering> getOfferings(@NotNull String pfiDid, @Nullable GetOfferingsFilter filter) {
        Map map;
        Object it;
        Map queryMap;
        Map map2;
        Intrinsics.checkNotNullParameter((Object)pfiDid, (String)"pfiDid");
        String pfiServiceEndpoint = UtilsKt.getPfiServiceEndpoint(pfiDid);
        String baseUrl = pfiServiceEndpoint + "/offerings/";
        GetOfferingsFilter getOfferingsFilter = filter;
        if (getOfferingsFilter != null) {
            GetOfferingsFilter it2 = getOfferingsFilter;
            boolean bl = false;
            ObjectMapper $this$convertValue$iv = Json.INSTANCE.getJsonMapper();
            boolean $i$f$convertValue = false;
            boolean $i$f$jacksonTypeRef = false;
            map2 = (Map)$this$convertValue$iv.convertValue((Object)it2, (TypeReference)new TypeReference<Map<String, ? extends String>>(){});
        } else {
            map2 = null;
        }
        Map map3 = queryMap = map2;
        if (map3 != null) {
            Map $this$filterValues$iv = map3;
            boolean $i$f$filterValues = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
                it = (String)entry$iv.getValue();
                boolean bl = false;
                if (!(it != null)) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            map = result$iv;
        } else {
            map = null;
        }
        Map notNullQueryMap = map;
        HttpUrl.Builder httpUrlBuilder = HttpUrl.Companion.get(baseUrl).newBuilder();
        Map map4 = notNullQueryMap;
        if (map4 != null) {
            Map $this$forEach$iv = map4;
            boolean $i$f$forEach = false;
            for (Map.Entry element$iv : $this$forEach$iv.entrySet()) {
                it = element$iv;
                boolean bl = false;
                httpUrlBuilder.addQueryParameter((String)it.getKey(), (String)it.getValue());
            }
        }
        Request request = new Request.Builder().url(httpUrlBuilder.build()).get().build();
        Response response = client.newCall(request).execute();
        if (response.isSuccessful()) {
            ResponseBody responseBody = response.body();
            String responseString = responseBody != null ? responseBody.string() : null;
            JsonNode jsonNode = Json.INSTANCE.getJsonMapper().readTree(responseString);
            Iterator iterator = jsonNode.get("data").elements();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"elements(...)");
            return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.asSequence((Iterator)iterator), (Function1)getOfferings.2.INSTANCE));
        }
        throw this.buildResponseException(response);
    }

    public static /* synthetic */ List getOfferings$default(TbdexHttpClient tbdexHttpClient, String string, GetOfferingsFilter getOfferingsFilter, int n, Object object) {
        if ((n & 2) != 0) {
            getOfferingsFilter = null;
        }
        return tbdexHttpClient.getOfferings(string, getOfferingsFilter);
    }

    private final void sendMessage(String pfiDid, String path, RequestBody requestBody) {
        String pfiServiceEndpoint = UtilsKt.getPfiServiceEndpoint(pfiDid);
        String url = pfiServiceEndpoint + path;
        Request request = this.buildRequest(url, requestBody);
        System.out.println((Object)("Attempting to send rfq message to: " + request.url()));
        this.executeRequest(request);
    }

    public final void createExchange(@NotNull Rfq rfq) {
        Intrinsics.checkNotNullParameter((Object)rfq, (String)"rfq");
        this.validateMessage((Message)rfq);
        String pfiDid = rfq.getMetadata().getTo();
        String exchangeId = rfq.getMetadata().getExchangeId();
        String path = "/exchanges/" + exchangeId;
        RequestBody body = RequestBody.Companion.create(Json.INSTANCE.stringify((Object)new CreateExchangeRequest(rfq, null, 2, null)), jsonMediaType);
        this.sendMessage(pfiDid, path, body);
    }

    public final void createExchange(@NotNull Rfq rfq, @NotNull String replyTo) {
        Intrinsics.checkNotNullParameter((Object)rfq, (String)"rfq");
        Intrinsics.checkNotNullParameter((Object)replyTo, (String)"replyTo");
        this.validateMessage((Message)rfq);
        String pfiDid = rfq.getMetadata().getTo();
        String exchangeId = rfq.getMetadata().getExchangeId();
        String path = "/exchanges/" + exchangeId;
        RequestBody body = RequestBody.Companion.create(Json.INSTANCE.stringify((Object)new CreateExchangeRequest(rfq, replyTo)), jsonMediaType);
        this.sendMessage(pfiDid, path, body);
    }

    public final void submitOrder(@NotNull Order order) {
        Intrinsics.checkNotNullParameter((Object)order, (String)"order");
        this.validateMessage((Message)order);
        String pfiDid = order.getMetadata().getTo();
        String exchangeId = order.getMetadata().getExchangeId();
        String path = "/exchanges/" + exchangeId + "/order";
        RequestBody body = RequestBody.Companion.create(Json.INSTANCE.stringify((Object)order), jsonMediaType);
        this.sendMessage(pfiDid, path, body);
    }

    public final void submitClose(@NotNull Close close) {
        Intrinsics.checkNotNullParameter((Object)close, (String)"close");
        this.validateMessage((Message)close);
        String pfiDid = close.getMetadata().getTo();
        String exchangeId = close.getMetadata().getExchangeId();
        String path = "/exchanges/" + exchangeId + "/close";
        RequestBody body = RequestBody.Companion.create(Json.INSTANCE.stringify((Object)close), jsonMediaType);
        this.sendMessage(pfiDid, path, body);
    }

    @NotNull
    public final List<Message> getExchange(@NotNull String pfiDid, @NotNull Did requesterDid, @NotNull String exchangeId) {
        Intrinsics.checkNotNullParameter((Object)pfiDid, (String)"pfiDid");
        Intrinsics.checkNotNullParameter((Object)requesterDid, (String)"requesterDid");
        Intrinsics.checkNotNullParameter((Object)exchangeId, (String)"exchangeId");
        String pfiServiceEndpoint = UtilsKt.getPfiServiceEndpoint(pfiDid);
        String baseUrl = pfiServiceEndpoint + "/exchanges/" + exchangeId;
        String requestToken = RequestToken.generate$default(RequestToken.INSTANCE, requesterDid, pfiDid, null, 4, null);
        Request request = new Request.Builder().url(baseUrl).addHeader("Content-Type", JSON_HEADER).addHeader("Authorization", "Bearer " + requestToken).get().build();
        Response response = client.newCall(request).execute();
        System.out.println((Object)("attempting to get exchange: " + request.url()));
        if (response.isSuccessful()) {
            ResponseBody responseBody = response.body();
            String responseString = responseBody != null ? responseBody.string() : null;
            JsonNode jsonNode = Json.INSTANCE.getJsonMapper().readTree(responseString);
            Iterator iterator = jsonNode.get("data").elements();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"elements(...)");
            return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.asSequence((Iterator)iterator), (Function1)getExchange.1.INSTANCE));
        }
        throw this.buildResponseException(response);
    }

    @NotNull
    public final List<List<Message>> getExchanges(@NotNull String pfiDid, @NotNull Did requesterDid, @Nullable GetExchangesFilter filter) {
        Intrinsics.checkNotNullParameter((Object)pfiDid, (String)"pfiDid");
        Intrinsics.checkNotNullParameter((Object)requesterDid, (String)"requesterDid");
        String pfiServiceEndpoint = UtilsKt.getPfiServiceEndpoint(pfiDid);
        String baseUrl = pfiServiceEndpoint + "/exchanges/";
        String requestToken = RequestToken.generate$default(RequestToken.INSTANCE, requesterDid, pfiDid, null, 4, null);
        HttpUrl.Builder httpUrlBuilder = HttpUrl.Companion.get(baseUrl).newBuilder();
        Object object = filter;
        if (object != null && (object = ((GetExchangesFilter)object).getExchangeIds()) != null) {
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                httpUrlBuilder.addQueryParameter("id", it);
            }
        }
        Request request = new Request.Builder().url(httpUrlBuilder.build()).addHeader("Content-Type", JSON_HEADER).addHeader("Authorization", "Bearer " + requestToken).get().build();
        System.out.println((Object)("attempting to get exchanges: " + request.url()));
        Response response = client.newCall(request).execute();
        if (response.isSuccessful()) {
            ResponseBody responseBody = response.body();
            JsonNode jsonNode = Json.INSTANCE.getJsonMapper().readTree(responseBody != null ? responseBody.string() : null);
            List exchanges = new ArrayList();
            Iterator iterator = jsonNode.get("data").elements();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"elements(...)");
            Iterator $this$forEach$iv = iterator;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv;
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                JsonNode jsonExchange = (JsonNode)element$iv;
                boolean bl = false;
                Iterator iterator3 = jsonExchange.elements();
                Intrinsics.checkNotNullExpressionValue((Object)iterator3, (String)"elements(...)");
                List exchange2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.asSequence((Iterator)iterator3), (Function1)getExchanges.2.exchange.1.INSTANCE));
                exchanges.add(exchange2);
            }
            return exchanges;
        }
        throw this.buildResponseException(response);
    }

    public static /* synthetic */ List getExchanges$default(TbdexHttpClient tbdexHttpClient, String string, Did did, GetExchangesFilter getExchangesFilter, int n, Object object) {
        if ((n & 4) != 0) {
            getExchangesFilter = null;
        }
        return tbdexHttpClient.getExchanges(string, did, getExchangesFilter);
    }

    private final TbdexResponseException buildResponseException(Response response) {
        List list;
        String responseBody;
        ResponseBody responseBody2 = response.body();
        String string = responseBody = responseBody2 != null ? responseBody2.string() : null;
        if (responseBody == null) {
            list = CollectionsKt.emptyList();
        } else {
            List errors2;
            JsonNode jsonNode = Json.INSTANCE.getJsonMapper().readTree(responseBody);
            Iterator iterator = jsonNode.get("errors").elements();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"elements(...)");
            list = errors2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.asSequence((Iterator)iterator), (Function1)buildResponseException.errors.errors.1.INSTANCE));
        }
        List errors3 = list;
        return new TbdexResponseException("response status: " + response.code(), null, errors3, 2, null);
    }

    private final void validateMessage(Message message) {
        Validator.INSTANCE.validateMessage(message);
        message.verify();
    }

    private final Request buildRequest(String url, RequestBody body) {
        Request request = new Request.Builder().url(url).addHeader("Content-Type", JSON_HEADER).post(body).build();
        return request;
    }

    private final void executeRequest(Request request) {
        Response response = client.newCall(request).execute();
        if (!response.isSuccessful()) {
            throw this.buildResponseException(response);
        }
    }
}

