/*
 * Decompiled with CFR 0.152.
 */
package tbdex.sdk.httpclient;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tbdex.sdk.httpclient.RequestTokenAudMismatchException;
import tbdex.sdk.httpclient.RequestTokenCreateException;
import tbdex.sdk.httpclient.RequestTokenExpiredException;
import tbdex.sdk.httpclient.RequestTokenMissingClaimsException;
import tbdex.sdk.httpclient.RequestTokenVerificationException;
import web5.sdk.common.Convert;
import web5.sdk.crypto.KeyManager;
import web5.sdk.dids.Did;
import web5.sdk.dids.DidResolutionResult;
import web5.sdk.dids.DidResolvers;
import web5.sdk.dids.didcore.DIDDocument;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0005J\u0016\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Ltbdex/sdk/httpclient/RequestToken;", "", "()V", "requiredClaimKeys", "", "", "getRequiredClaimKeys", "()Ljava/util/List;", "generate", "did", "Lweb5/sdk/dids/Did;", "pfiDid", "assertionMethodId", "verify", "token", "httpclient"})
@SourceDebugExtension(value={"SMAP\nRequestToken.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RequestToken.kt\ntbdex/sdk/httpclient/RequestToken\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,129:1\n1#2:130\n1855#3,2:131\n*S KotlinDebug\n*F\n+ 1 RequestToken.kt\ntbdex/sdk/httpclient/RequestToken\n*L\n109#1:131,2\n*E\n"})
public final class RequestToken {
    @NotNull
    public static final RequestToken INSTANCE = new RequestToken();
    @NotNull
    private static final List<String> requiredClaimKeys;

    private RequestToken() {
    }

    @NotNull
    public final List<String> getRequiredClaimKeys() {
        return requiredClaimKeys;
    }

    @NotNull
    public final String generate(@NotNull Did did, @NotNull String pfiDid, @Nullable String assertionMethodId) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)did, (String)"did");
        Intrinsics.checkNotNullParameter((Object)pfiDid, (String)"pfiDid");
        DidResolutionResult didResolutionResult = DidResolvers.resolve$default((DidResolvers)DidResolvers.INSTANCE, (String)did.getUri(), null, (int)2, null);
        DIDDocument dIDDocument = didResolutionResult.getDidDocument();
        if (dIDDocument == null || (dIDDocument = dIDDocument.findAssertionMethodById(assertionMethodId)) == null) {
            throw new RequestTokenCreateException("Assertion method not found");
        }
        DIDDocument assertionMethod = dIDDocument;
        JWK publicKeyJwk = assertionMethod.getPublicKeyJwk();
        if (!(publicKeyJwk != null)) {
            boolean $i$a$-check-RequestToken$generate$22 = false;
            String $i$a$-check-RequestToken$generate$22 = "publicKeyJwk is null";
            throw new IllegalStateException($i$a$-check-RequestToken$generate$22.toString());
        }
        String keyAlias = did.getKeyManager().getDeterministicAlias(publicKeyJwk);
        Algorithm algorithm = publicKeyJwk.getAlgorithm();
        JWSAlgorithm jwsAlgorithm = JWSAlgorithm.parse((String)algorithm.toString());
        boolean bl = StringsKt.startsWith$default((String)assertionMethod.getId(), (String)"#", (boolean)false, (int)2, null);
        if (bl) {
            object = did.getUri() + assertionMethod.getId();
        } else if (!bl) {
            object = assertionMethod.getId();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Object kid = object;
        JWSHeader jwtHeader = new JWSHeader.Builder(jwsAlgorithm).type(JOSEObjectType.JWT).keyID((String)kid).build();
        Instant now = Instant.now();
        Instant exp = now.plusSeconds(60L);
        JWTClaimsSet jwtPayload = new JWTClaimsSet.Builder().audience(pfiDid).issuer(did.getUri()).expirationTime(Date.from(exp)).issueTime(Date.from(now)).jwtID(UUID.randomUUID().toString()).build();
        SignedJWT jwtObject = new SignedJWT(jwtHeader, jwtPayload);
        byte[] toSign = jwtObject.getSigningInput();
        KeyManager keyManager = did.getKeyManager();
        Intrinsics.checkNotNull((Object)toSign);
        byte[] signatureBytes = keyManager.sign(keyAlias, toSign);
        Base64URL base64UrlEncodedHeader = jwtHeader.toBase64URL();
        Base64URL base64UrlEncodedPayload = jwtPayload.toPayload().toBase64URL();
        Base64URL base64UrlEncodedSignature = new Base64URL(new Convert((Object)signatureBytes, null, 2, null).toBase64Url(false));
        return base64UrlEncodedHeader + "." + base64UrlEncodedPayload + "." + base64UrlEncodedSignature;
    }

    public static /* synthetic */ String generate$default(RequestToken requestToken, Did did, String string, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        return requestToken.generate(did, string, string2);
    }

    @NotNull
    public final String verify(@NotNull String token, @NotNull String pfiDid) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)pfiDid, (String)"pfiDid");
        JWTClaimsSet claimsSet = null;
        try {
            JWTClaimsSet jWTClaimsSet = SignedJWT.parse((String)token).getJWTClaimsSet();
            Intrinsics.checkNotNullExpressionValue((Object)jWTClaimsSet, (String)"getJWTClaimsSet(...)");
            claimsSet = jWTClaimsSet;
        }
        catch (Exception e) {
            throw new RequestTokenVerificationException(e, "Failed to parse request token");
        }
        String issuer = claimsSet.getIssuer();
        List audience = claimsSet.getAudience();
        Date expirationTime = claimsSet.getExpirationTime();
        Iterable $this$forEach$iv = requiredClaimKeys;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String key = (String)element$iv;
            boolean bl = false;
            if (claimsSet.getClaims().containsKey(key)) continue;
            throw new RequestTokenMissingClaimsException("Missing required claim for key " + key);
        }
        if (!Instant.now().isBefore(expirationTime.toInstant())) {
            boolean bl = false;
            throw new RequestTokenExpiredException("Request Token is expired.");
        }
        if (!audience.contains(pfiDid)) {
            boolean bl = false;
            throw new RequestTokenAudMismatchException("Request token contains invalid audience. Expected aud property to be PFI DID.");
        }
        Intrinsics.checkNotNull((Object)issuer);
        return issuer;
    }

    static {
        Object[] objectArray = new String[]{"aud", "iss", "exp", "jti", "iat"};
        requiredClaimKeys = CollectionsKt.listOf((Object[])objectArray);
    }
}

