/*
 * Decompiled with CFR 0.152.
 */
package tbdex.sdk.httpclient;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tbdex.sdk.httpclient.RequestToken;
import tbdex.sdk.httpclient.TbdexHttpClient;
import tbdex.sdk.httpclient.UtilsKt;
import tbdex.sdk.httpclient.models.CreateExchangeRequest;
import tbdex.sdk.httpclient.models.GetExchangesFilter;
import tbdex.sdk.httpclient.models.GetOfferingsFilter;
import tbdex.sdk.httpclient.models.TbdexResponseException;
import tbdex.sdk.protocol.Validator;
import tbdex.sdk.protocol.models.Close;
import tbdex.sdk.protocol.models.Message;
import tbdex.sdk.protocol.models.Offering;
import tbdex.sdk.protocol.models.Order;
import tbdex.sdk.protocol.models.Rfq;
import tbdex.sdk.protocol.serialization.Json;
import web5.sdk.dids.did.BearerDid;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0004J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J(\u0010\u0018\u001a\f\u0012\u0004\u0012\u00020\u001a0\u0019j\u0002`\u001b2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0004J2\u0010\u001f\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u001a0\u0019j\u0002`\u001b0\u00192\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001d2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!J \u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u00192\u0006\u0010\u000f\u001a\u00020\u00042\n\b\u0002\u0010 \u001a\u0004\u0018\u00010$J\u000e\u0010%\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020'J \u0010(\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010)\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020+J\u0010\u0010,\u001a\u00020\u000e2\u0006\u0010-\u001a\u00020\u001aH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Ltbdex/sdk/httpclient/TbdexHttpClient;", "", "()V", "JSON_HEADER", "", "client", "Lokhttp3/OkHttpClient;", "jsonMediaType", "Lokhttp3/MediaType;", "buildResponseException", "Ltbdex/sdk/httpclient/models/TbdexResponseException;", "response", "Lokhttp3/Response;", "createExchange", "", "pfiDid", "requestBody", "Lokhttp3/RequestBody;", "rfq", "Ltbdex/sdk/protocol/models/Rfq;", "replyTo", "executeRequest", "request", "Lokhttp3/Request;", "getExchange", "", "Ltbdex/sdk/protocol/models/Message;", "Ltbdex/sdk/httpclient/models/Exchange;", "requesterDid", "Lweb5/sdk/dids/did/BearerDid;", "exchangeId", "getExchanges", "filter", "Ltbdex/sdk/httpclient/models/GetExchangesFilter;", "getOfferings", "Ltbdex/sdk/protocol/models/Offering;", "Ltbdex/sdk/httpclient/models/GetOfferingsFilter;", "submitClose", "close", "Ltbdex/sdk/protocol/models/Close;", "submitMessage", "submitOrder", "order", "Ltbdex/sdk/protocol/models/Order;", "validateMessage", "message", "httpclient"})
@SourceDebugExtension(value={"SMAP\nTbdexHttpClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TbdexHttpClient.kt\ntbdex/sdk/httpclient/TbdexHttpClient\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 7 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,303:1\n1#2:304\n56#3:305\n43#3:306\n494#4,7:307\n215#5,2:314\n1855#6,2:316\n32#7,2:318\n*S KotlinDebug\n*F\n+ 1 TbdexHttpClient.kt\ntbdex/sdk/httpclient/TbdexHttpClient\n*L\n49#1:305\n49#1:306\n50#1:307,7\n52#1:314,2\n236#1:316,2\n253#1:318,2\n*E\n"})
public final class TbdexHttpClient {
    @NotNull
    public static final TbdexHttpClient INSTANCE = new TbdexHttpClient();
    @NotNull
    private static final OkHttpClient client = new OkHttpClient();
    @NotNull
    private static final MediaType jsonMediaType = MediaType.Companion.get("application/json; charset=utf-8");
    @NotNull
    private static final String JSON_HEADER = "application/json";

    private TbdexHttpClient() {
    }

    @NotNull
    public final List<Offering> getOfferings(@NotNull String pfiDid, @Nullable GetOfferingsFilter filter) {
        Map map;
        Object it;
        Map queryMap;
        Map map2;
        Intrinsics.checkNotNullParameter((Object)pfiDid, (String)"pfiDid");
        String pfiServiceEndpoint = UtilsKt.getPfiServiceEndpoint(pfiDid);
        String baseUrl = pfiServiceEndpoint + "/offerings/";
        GetOfferingsFilter getOfferingsFilter = filter;
        if (getOfferingsFilter != null) {
            GetOfferingsFilter it2 = getOfferingsFilter;
            boolean bl = false;
            ObjectMapper $this$convertValue$iv = Json.INSTANCE.getJsonMapper();
            boolean $i$f$convertValue = false;
            boolean $i$f$jacksonTypeRef = false;
            map2 = (Map)$this$convertValue$iv.convertValue((Object)it2, (TypeReference)new TypeReference<Map<String, ? extends String>>(){});
        } else {
            map2 = null;
        }
        Map map3 = queryMap = map2;
        if (map3 != null) {
            Map $this$filterValues$iv = map3;
            boolean $i$f$filterValues = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
                it = (String)entry$iv.getValue();
                boolean bl = false;
                if (!(it != null)) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            map = result$iv;
        } else {
            map = null;
        }
        Map notNullQueryMap = map;
        HttpUrl.Builder httpUrlBuilder = HttpUrl.Companion.get(baseUrl).newBuilder();
        Map map4 = notNullQueryMap;
        if (map4 != null) {
            Map $this$forEach$iv = map4;
            boolean $i$f$forEach = false;
            for (Map.Entry element$iv : $this$forEach$iv.entrySet()) {
                it = element$iv;
                boolean bl = false;
                httpUrlBuilder.addQueryParameter((String)it.getKey(), (String)it.getValue());
            }
        }
        Request request = new Request.Builder().url(httpUrlBuilder.build()).get().build();
        Response response = client.newCall(request).execute();
        if (response.isSuccessful()) {
            ResponseBody responseBody = response.body();
            String responseString = responseBody != null ? responseBody.string() : null;
            JsonNode jsonNode = Json.INSTANCE.getJsonMapper().readTree(responseString);
            Iterator iterator = jsonNode.get("data").elements();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"elements(...)");
            return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.asSequence((Iterator)iterator), (Function1)getOfferings.2.INSTANCE));
        }
        throw this.buildResponseException(response);
    }

    public static /* synthetic */ List getOfferings$default(TbdexHttpClient tbdexHttpClient, String string, GetOfferingsFilter getOfferingsFilter, int n, Object object) {
        if ((n & 2) != 0) {
            getOfferingsFilter = null;
        }
        return tbdexHttpClient.getOfferings(string, getOfferingsFilter);
    }

    public final void createExchange(@NotNull Rfq rfq) {
        Intrinsics.checkNotNullParameter((Object)rfq, (String)"rfq");
        this.validateMessage((Message)rfq);
        String pfiDid = rfq.getMetadata().getTo();
        RequestBody body = RequestBody.Companion.create(Json.INSTANCE.stringify((Object)new CreateExchangeRequest(rfq, null, 2, null)), jsonMediaType);
        this.createExchange(pfiDid, body);
    }

    public final void createExchange(@NotNull Rfq rfq, @NotNull String replyTo) {
        Intrinsics.checkNotNullParameter((Object)rfq, (String)"rfq");
        Intrinsics.checkNotNullParameter((Object)replyTo, (String)"replyTo");
        this.validateMessage((Message)rfq);
        String pfiDid = rfq.getMetadata().getTo();
        RequestBody body = RequestBody.Companion.create(Json.INSTANCE.stringify((Object)new CreateExchangeRequest(rfq, replyTo)), jsonMediaType);
        this.createExchange(pfiDid, body);
    }

    private final void createExchange(String pfiDid, RequestBody requestBody) {
        String path = "/exchanges";
        String pfiServiceEndpoint = UtilsKt.getPfiServiceEndpoint(pfiDid);
        String url = pfiServiceEndpoint + path;
        Request request = new Request.Builder().url(url).addHeader("Content-Type", JSON_HEADER).post(requestBody).build();
        System.out.println((Object)("Attempting to send rfq message to: " + request.url()));
        this.executeRequest(request);
    }

    public final void submitOrder(@NotNull Order order) {
        Intrinsics.checkNotNullParameter((Object)order, (String)"order");
        this.validateMessage((Message)order);
        String pfiDid = order.getMetadata().getTo();
        String exchangeId = order.getMetadata().getExchangeId();
        RequestBody body = RequestBody.Companion.create(Json.INSTANCE.stringify((Object)order), jsonMediaType);
        this.submitMessage(pfiDid, exchangeId, body);
    }

    public final void submitClose(@NotNull Close close) {
        Intrinsics.checkNotNullParameter((Object)close, (String)"close");
        this.validateMessage((Message)close);
        String pfiDid = close.getMetadata().getTo();
        String exchangeId = close.getMetadata().getExchangeId();
        RequestBody body = RequestBody.Companion.create(Json.INSTANCE.stringify((Object)close), jsonMediaType);
        this.submitMessage(pfiDid, exchangeId, body);
    }

    private final void submitMessage(String pfiDid, String exchangeId, RequestBody requestBody) {
        String path = "/exchanges/" + exchangeId;
        String pfiServiceEndpoint = UtilsKt.getPfiServiceEndpoint(pfiDid);
        String url = pfiServiceEndpoint + path;
        Request request = new Request.Builder().url(url).addHeader("Content-Type", JSON_HEADER).put(requestBody).build();
        System.out.println((Object)("Attempting to send message to exchange " + exchangeId + " to: " + request.url()));
        this.executeRequest(request);
    }

    @NotNull
    public final List<Message> getExchange(@NotNull String pfiDid, @NotNull BearerDid requesterDid, @NotNull String exchangeId) {
        Intrinsics.checkNotNullParameter((Object)pfiDid, (String)"pfiDid");
        Intrinsics.checkNotNullParameter((Object)requesterDid, (String)"requesterDid");
        Intrinsics.checkNotNullParameter((Object)exchangeId, (String)"exchangeId");
        String pfiServiceEndpoint = UtilsKt.getPfiServiceEndpoint(pfiDid);
        String baseUrl = pfiServiceEndpoint + "/exchanges/" + exchangeId;
        String requestToken = RequestToken.generate$default(RequestToken.INSTANCE, requesterDid, pfiDid, null, 4, null);
        Request request = new Request.Builder().url(baseUrl).addHeader("Content-Type", JSON_HEADER).addHeader("Authorization", "Bearer " + requestToken).get().build();
        Response response = client.newCall(request).execute();
        System.out.println((Object)("attempting to get exchange: " + request.url()));
        if (response.isSuccessful()) {
            ResponseBody responseBody = response.body();
            String responseString = responseBody != null ? responseBody.string() : null;
            JsonNode jsonNode = Json.INSTANCE.getJsonMapper().readTree(responseString);
            Iterator iterator = jsonNode.get("data").elements();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"elements(...)");
            return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.asSequence((Iterator)iterator), (Function1)getExchange.1.INSTANCE));
        }
        throw this.buildResponseException(response);
    }

    @NotNull
    public final List<List<Message>> getExchanges(@NotNull String pfiDid, @NotNull BearerDid requesterDid, @Nullable GetExchangesFilter filter) {
        Intrinsics.checkNotNullParameter((Object)pfiDid, (String)"pfiDid");
        Intrinsics.checkNotNullParameter((Object)requesterDid, (String)"requesterDid");
        String pfiServiceEndpoint = UtilsKt.getPfiServiceEndpoint(pfiDid);
        String baseUrl = pfiServiceEndpoint + "/exchanges/";
        String requestToken = RequestToken.generate$default(RequestToken.INSTANCE, requesterDid, pfiDid, null, 4, null);
        HttpUrl.Builder httpUrlBuilder = HttpUrl.Companion.get(baseUrl).newBuilder();
        Object object = filter;
        if (object != null && (object = ((GetExchangesFilter)object).getExchangeIds()) != null) {
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                httpUrlBuilder.addQueryParameter("id", it);
            }
        }
        Request request = new Request.Builder().url(httpUrlBuilder.build()).addHeader("Content-Type", JSON_HEADER).addHeader("Authorization", "Bearer " + requestToken).get().build();
        System.out.println((Object)("attempting to get exchanges: " + request.url()));
        Response response = client.newCall(request).execute();
        if (response.isSuccessful()) {
            ResponseBody responseBody = response.body();
            JsonNode jsonNode = Json.INSTANCE.getJsonMapper().readTree(responseBody != null ? responseBody.string() : null);
            List exchanges = new ArrayList();
            Iterator iterator = jsonNode.get("data").elements();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"elements(...)");
            Iterator $this$forEach$iv = iterator;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv;
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                JsonNode jsonExchange = (JsonNode)element$iv;
                boolean bl = false;
                Iterator iterator3 = jsonExchange.elements();
                Intrinsics.checkNotNullExpressionValue((Object)iterator3, (String)"elements(...)");
                List exchange2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.asSequence((Iterator)iterator3), (Function1)getExchanges.2.exchange.1.INSTANCE));
                exchanges.add(exchange2);
            }
            return exchanges;
        }
        throw this.buildResponseException(response);
    }

    public static /* synthetic */ List getExchanges$default(TbdexHttpClient tbdexHttpClient, String string, BearerDid bearerDid, GetExchangesFilter getExchangesFilter, int n, Object object) {
        if ((n & 4) != 0) {
            getExchangesFilter = null;
        }
        return tbdexHttpClient.getExchanges(string, bearerDid, getExchangesFilter);
    }

    private final TbdexResponseException buildResponseException(Response response) {
        List list;
        String responseBody;
        ResponseBody responseBody2 = response.body();
        String string = responseBody = responseBody2 != null ? responseBody2.string() : null;
        if (responseBody == null) {
            list = CollectionsKt.emptyList();
        } else {
            List errors2;
            JsonNode jsonNode = Json.INSTANCE.getJsonMapper().readTree(responseBody);
            Iterator iterator = jsonNode.get("errors").elements();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"elements(...)");
            list = errors2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.asSequence((Iterator)iterator), (Function1)buildResponseException.errors.errors.1.INSTANCE));
        }
        List errors3 = list;
        return new TbdexResponseException("response status: " + response.code(), null, errors3, 2, null);
    }

    private final void validateMessage(Message message) {
        Validator.INSTANCE.validateMessage(message);
        message.verify();
    }

    private final void executeRequest(Request request) {
        Response response = client.newCall(request).execute();
        if (!response.isSuccessful()) {
            throw this.buildResponseException(response);
        }
    }
}

