/*
 * Decompiled with CFR 0.152.
 */
package tbdex.sdk.protocol;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.util.Base64URL;
import foundation.identity.did.DIDDocument;
import foundation.identity.did.DIDURL;
import foundation.identity.did.VerificationMethod;
import java.security.MessageDigest;
import java.security.SignatureException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.erdtman.jcs.JsonCanonicalizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tbdex.sdk.protocol.models.Data;
import tbdex.sdk.protocol.models.Metadata;
import tbdex.sdk.protocol.serialization.Json;
import web5.sdk.common.Convert;
import web5.sdk.crypto.Crypto;
import web5.sdk.crypto.KeyManager;
import web5.sdk.dids.Did;
import web5.sdk.dids.DidResolutionResult;
import web5.sdk.dids.DidResolvers;

@kotlin.Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\"\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00042\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eJ \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000b\u001a\u00020\u000e\u00a8\u0006\u0015"}, d2={"Ltbdex/sdk/protocol/CryptoUtils;", "", "()V", "digestOf", "", "metadata", "Ltbdex/sdk/protocol/models/Metadata;", "data", "Ltbdex/sdk/protocol/models/Data;", "getAssertionMethod", "Lfoundation/identity/did/VerificationMethod;", "did", "Lweb5/sdk/dids/Did;", "assertionMethodId", "", "sign", "payload", "verify", "", "detachedPayload", "signature", "protocol"})
@SourceDebugExtension(value={"SMAP\nCryptoUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CryptoUtils.kt\ntbdex/sdk/protocol/CryptoUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,182:1\n288#2,2:183\n1#3:185\n*S KotlinDebug\n*F\n+ 1 CryptoUtils.kt\ntbdex/sdk/protocol/CryptoUtils\n*L\n82#1:183,2\n*E\n"})
public final class CryptoUtils {
    @NotNull
    public static final CryptoUtils INSTANCE = new CryptoUtils();

    private CryptoUtils() {
    }

    @NotNull
    public final byte[] digestOf(@NotNull Metadata metadata, @NotNull Data data) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"metadata", (Object)metadata), TuplesKt.to((Object)"data", (Object)data)};
        Map payload = MapsKt.mapOf((Pair[])pairArray);
        JsonCanonicalizer canonicalJsonSerializedPayload = new JsonCanonicalizer(Json.INSTANCE.stringify(payload));
        MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
        byte[] byArray = sha256.digest(canonicalJsonSerializedPayload.getEncodedUTF8());
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
        return byArray;
    }

    public final void verify(@NotNull byte[] detachedPayload, @Nullable String signature, @NotNull String did) {
        VerificationMethod assertionMethod;
        VerificationMethod verificationMethod;
        List assertionMethods;
        Intrinsics.checkNotNullParameter((Object)detachedPayload, (String)"detachedPayload");
        Intrinsics.checkNotNullParameter((Object)did, (String)"did");
        if (!(signature != null)) {
            boolean bl = false;
            throw new IllegalArgumentException("Signature verification failed: Expected signature property to exist");
        }
        JWSObject jws = JWSObject.parse((String)signature, (Payload)new Payload(detachedPayload));
        if (!(jws.getHeader().getAlgorithm() != null && jws.getHeader().getKeyID() != null)) {
            boolean $i$a$-require-CryptoUtils$verify$52 = false;
            String $i$a$-require-CryptoUtils$verify$52 = "Signature verification failed: Expected JWS header to contain alg and kid";
            throw new IllegalArgumentException($i$a$-require-CryptoUtils$verify$52.toString());
        }
        String verificationMethodId = jws.getHeader().getKeyID();
        DIDURL parsedDidUrl = DIDURL.fromString((String)verificationMethodId);
        String string = parsedDidUrl.getUriWithoutFragment().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String signingDid = string;
        if (!Intrinsics.areEqual((Object)signingDid, (Object)did)) {
            throw new SignatureException("Signature verification failed: Was not signed by the expected DID. Expected DID: " + did + ". Actual DID: " + signingDid);
        }
        String string2 = parsedDidUrl.getDid().getDidString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDidString(...)");
        DidResolutionResult didResolutionResult = DidResolvers.resolve$default((DidResolvers)DidResolvers.INSTANCE, (String)string2, null, (int)2, null);
        if (didResolutionResult.getDidResolutionMetadata().getError() != null) {
            throw new SignatureException("Signature verification failed: Failed to resolve DID " + parsedDidUrl.getDid().getDidString() + ". Error: " + didResolutionResult.getDidResolutionMetadata().getError());
        }
        Object[] objectArray = new String[]{parsedDidUrl.getDidUrlString(), "#" + parsedDidUrl.getFragment()};
        Set verificationMethodIds = SetsKt.setOf((Object[])objectArray);
        DIDDocument dIDDocument = didResolutionResult.getDidDocument();
        List list = assertionMethods = dIDDocument != null ? dIDDocument.getAssertionMethodVerificationMethodsDereferenced() : null;
        if (list != null) {
            Object v4;
            block9: {
                Iterable $this$firstOrNull$iv = list;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    String id;
                    VerificationMethod it = (VerificationMethod)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it.getId().toString(), (String)"toString(...)");
                    if (!verificationMethodIds.contains(id)) continue;
                    v4 = element$iv;
                    break block9;
                }
                v4 = null;
            }
            verificationMethod = v4;
        } else {
            verificationMethod = assertionMethod = null;
        }
        if (!(assertionMethod != null)) {
            boolean bl = false;
            throw new SignatureException("Signature verification failed: Expected kid in JWS header to dereference a DID Document Verification Method with an Assertion verification relationship");
        }
        if (!((assertionMethod.isType("JsonWebKey2020") || assertionMethod.isType("JsonWebKey")) && assertionMethod.getPublicKeyJwk() != null)) {
            boolean bl = false;
            throw new SignatureException("Signature verification failed: Expected kid in JWS header to dereference a DID Document Verification Method of type JsonWebKey2020 with a publicKeyJwk");
        }
        Map publicKeyMap = assertionMethod.getPublicKeyJwk();
        JWK publicKeyJwk = JWK.parse((Map)publicKeyMap);
        Intrinsics.checkNotNull((Object)publicKeyJwk);
        byte[] byArray = jws.getSigningInput();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getSigningInput(...)");
        byte[] byArray2 = jws.getSignature().decode();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"decode(...)");
        Crypto.INSTANCE.verify(publicKeyJwk, byArray, byArray2, (Algorithm)jws.getHeader().getAlgorithm());
    }

    @NotNull
    public final String sign(@NotNull Did did, @NotNull byte[] payload, @Nullable String assertionMethodId) {
        Intrinsics.checkNotNullParameter((Object)did, (String)"did");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        VerificationMethod assertionMethod = this.getAssertionMethod(did, assertionMethodId);
        JWK publicKeyJwk = JWK.parse((Map)assertionMethod.getPublicKeyJwk());
        KeyManager keyManager = did.getKeyManager();
        Intrinsics.checkNotNull((Object)publicKeyJwk);
        String keyAlias = keyManager.getDeterministicAlias(publicKeyJwk);
        JWK publicKey = did.getKeyManager().getPublicKey(keyAlias);
        Algorithm algorithm = publicKey.getAlgorithm();
        JWSAlgorithm jwsAlgorithm = JWSAlgorithm.parse((String)algorithm.toString());
        String string = assertionMethod.getId().isAbsolute() ? assertionMethod.getId().toString() : did.getUri() + assertionMethod.getId();
        Intrinsics.checkNotNull((Object)string);
        String selectedAssertionMethodId = string;
        JWSHeader jwsHeader = new JWSHeader.Builder(jwsAlgorithm).keyID(selectedAssertionMethodId).build();
        Payload jwsPayload = new Payload(payload);
        JWSObject jwsObject = new JWSObject(jwsHeader, jwsPayload);
        byte[] toSign = jwsObject.getSigningInput();
        KeyManager keyManager2 = did.getKeyManager();
        Intrinsics.checkNotNull((Object)toSign);
        byte[] signatureBytes = keyManager2.sign(keyAlias, toSign);
        String base64UrlEncodedSignature = new Convert((Object)signatureBytes, null, 2, null).toBase64Url(false);
        Base64URL base64UrlEncodedHeader = jwsHeader.toBase64URL();
        return base64UrlEncodedHeader + ".." + base64UrlEncodedSignature;
    }

    public static /* synthetic */ String sign$default(CryptoUtils cryptoUtils, Did did, byte[] byArray, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        return cryptoUtils.sign(did, byArray, string);
    }

    @NotNull
    public final VerificationMethod getAssertionMethod(@NotNull Did did, @Nullable String assertionMethodId) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)did, (String)"did");
        DidResolutionResult didResolutionResult = DidResolvers.resolve$default((DidResolvers)DidResolvers.INSTANCE, (String)did.getUri(), null, (int)2, null);
        DIDDocument dIDDocument = didResolutionResult.getDidDocument();
        List assertionMethods = dIDDocument != null ? dIDDocument.getAssertionMethodVerificationMethodsDereferenced() : null;
        if (assertionMethodId != null) {
            List list = assertionMethods;
            if (list != null) {
                Object v2;
                block6: {
                    Iterable iterable = list;
                    for (Object t : iterable) {
                        VerificationMethod it = (VerificationMethod)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getId().toString(), (Object)assertionMethodId)) continue;
                        v2 = t;
                        break block6;
                    }
                    v2 = null;
                }
                object = v2;
            } else {
                object = null;
            }
        } else {
            List list = assertionMethods;
            object = list != null ? (VerificationMethod)CollectionsKt.firstOrNull((List)list) : null;
        }
        if (object == null) {
            throw new SignatureException("assertion method " + assertionMethodId + " not found");
        }
        VerificationMethod assertionMethod = object;
        return assertionMethod;
    }
}

