/*
 * Decompiled with CFR 0.152.
 */
package tbdex.sdk.protocol.models;

import de.fxlae.typeid.TypeId;
import java.time.OffsetDateTime;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tbdex.sdk.protocol.Validator;
import tbdex.sdk.protocol.models.Message;
import tbdex.sdk.protocol.models.MessageKind;
import tbdex.sdk.protocol.models.MessageMetadata;
import tbdex.sdk.protocol.models.QuoteData;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B#\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0017"}, d2={"Ltbdex/sdk/protocol/models/Quote;", "Ltbdex/sdk/protocol/models/Message;", "metadata", "Ltbdex/sdk/protocol/models/MessageMetadata;", "data", "Ltbdex/sdk/protocol/models/QuoteData;", "signature", "", "(Ltbdex/sdk/protocol/models/MessageMetadata;Ltbdex/sdk/protocol/models/QuoteData;Ljava/lang/String;)V", "getData", "()Ltbdex/sdk/protocol/models/QuoteData;", "getMetadata", "()Ltbdex/sdk/protocol/models/MessageMetadata;", "getSignature", "()Ljava/lang/String;", "setSignature", "(Ljava/lang/String;)V", "validNext", "", "Ltbdex/sdk/protocol/models/MessageKind;", "getValidNext", "()Ljava/util/Set;", "Companion", "protocol"})
public final class Quote
extends Message {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MessageMetadata metadata;
    @NotNull
    private final QuoteData data;
    @Nullable
    private String signature;
    @NotNull
    private final Set<MessageKind> validNext;

    private Quote(MessageMetadata metadata, QuoteData data, String signature) {
        super(null);
        this.metadata = metadata;
        this.data = data;
        this.signature = signature;
        MessageKind[] messageKindArray = new MessageKind[]{MessageKind.order, MessageKind.close};
        this.validNext = SetsKt.setOf((Object[])messageKindArray);
    }

    /* synthetic */ Quote(MessageMetadata messageMetadata, QuoteData quoteData, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = null;
        }
        this(messageMetadata, quoteData, string);
    }

    @Override
    @NotNull
    public MessageMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    @NotNull
    public QuoteData getData() {
        return this.data;
    }

    @Override
    @Nullable
    public String getSignature() {
        return this.signature;
    }

    @Override
    public void setSignature(@Nullable String string) {
        this.signature = string;
    }

    @Override
    @NotNull
    public Set<MessageKind> getValidNext() {
        return this.validNext;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0006\u00a8\u0006\r"}, d2={"Ltbdex/sdk/protocol/models/Quote$Companion;", "", "()V", "create", "Ltbdex/sdk/protocol/models/Quote;", "to", "", "from", "exchangeId", "Lde/fxlae/typeid/TypeId;", "quoteData", "Ltbdex/sdk/protocol/models/QuoteData;", "externalId", "protocol"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Quote create(@NotNull String to, @NotNull String from, @NotNull TypeId exchangeId, @NotNull QuoteData quoteData, @Nullable String externalId) {
            Intrinsics.checkNotNullParameter((Object)to, (String)"to");
            Intrinsics.checkNotNullParameter((Object)from, (String)"from");
            Intrinsics.checkNotNullParameter((Object)exchangeId, (String)"exchangeId");
            Intrinsics.checkNotNullParameter((Object)quoteData, (String)"quoteData");
            TypeId typeId = TypeId.generate((String)"quote");
            Intrinsics.checkNotNullExpressionValue((Object)typeId, (String)"generate(...)");
            OffsetDateTime offsetDateTime = OffsetDateTime.now();
            Intrinsics.checkNotNullExpressionValue((Object)offsetDateTime, (String)"now(...)");
            MessageMetadata metadata = new MessageMetadata(MessageKind.quote, to, from, typeId, exchangeId, offsetDateTime, externalId);
            Validator.INSTANCE.validateData(quoteData, "quote");
            return new Quote(metadata, quoteData, null, 4, null);
        }

        public static /* synthetic */ Quote create$default(Companion companion, String string, String string2, TypeId typeId, QuoteData quoteData, String string3, int n, Object object) {
            if ((n & 0x10) != 0) {
                string3 = null;
            }
            return companion.create(string, string2, typeId, quoteData, string3);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

