/*
 * Decompiled with CFR 0.152.
 */
package tbdex.sdk.protocol;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.util.Base64URL;
import java.security.MessageDigest;
import java.security.SignatureException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.erdtman.jcs.JsonCanonicalizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tbdex.sdk.protocol.models.Data;
import tbdex.sdk.protocol.models.Metadata;
import tbdex.sdk.protocol.serialization.Json;
import web5.sdk.common.Convert;
import web5.sdk.crypto.Crypto;
import web5.sdk.crypto.KeyManager;
import web5.sdk.dids.Did;
import web5.sdk.dids.DidResolutionResult;
import web5.sdk.dids.DidResolvers;
import web5.sdk.dids.didcore.DIDDocument;
import web5.sdk.dids.didcore.DidUri;
import web5.sdk.dids.didcore.VerificationMethod;

@kotlin.Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\nJ \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\n\u00a8\u0006\u0013"}, d2={"Ltbdex/sdk/protocol/CryptoUtils;", "", "()V", "digestOf", "", "metadata", "Ltbdex/sdk/protocol/models/Metadata;", "data", "Ltbdex/sdk/protocol/models/Data;", "sign", "", "did", "Lweb5/sdk/dids/Did;", "payload", "assertionMethodId", "verify", "", "detachedPayload", "signature", "protocol"})
@SourceDebugExtension(value={"SMAP\nCryptoUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CryptoUtils.kt\ntbdex/sdk/protocol/CryptoUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,154:1\n288#2,2:155\n1#3:157\n*S KotlinDebug\n*F\n+ 1 CryptoUtils.kt\ntbdex/sdk/protocol/CryptoUtils\n*L\n80#1:155,2\n*E\n"})
public final class CryptoUtils {
    @NotNull
    public static final CryptoUtils INSTANCE = new CryptoUtils();

    private CryptoUtils() {
    }

    @NotNull
    public final byte[] digestOf(@NotNull Metadata metadata, @NotNull Data data) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"metadata", (Object)metadata), TuplesKt.to((Object)"data", (Object)data)};
        Map payload = MapsKt.mapOf((Pair[])pairArray);
        JsonCanonicalizer canonicalJsonSerializedPayload = new JsonCanonicalizer(Json.INSTANCE.stringify(payload));
        MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
        byte[] byArray = sha256.digest(canonicalJsonSerializedPayload.getEncodedUTF8());
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
        return byArray;
    }

    public final void verify(@NotNull byte[] detachedPayload, @Nullable String signature, @NotNull String did) {
        String assertionMethodId;
        String string;
        List assertionMethodIds;
        Intrinsics.checkNotNullParameter((Object)detachedPayload, (String)"detachedPayload");
        Intrinsics.checkNotNullParameter((Object)did, (String)"did");
        if (!(signature != null)) {
            boolean bl = false;
            throw new IllegalArgumentException("Signature verification failed: Expected signature property to exist");
        }
        JWSObject jws = JWSObject.parse((String)signature, (Payload)new Payload(detachedPayload));
        if (!(jws.getHeader().getAlgorithm() != null && jws.getHeader().getKeyID() != null)) {
            boolean $i$a$-require-CryptoUtils$verify$52 = false;
            String $i$a$-require-CryptoUtils$verify$52 = "Signature verification failed: Expected JWS header to contain alg and kid";
            throw new IllegalArgumentException($i$a$-require-CryptoUtils$verify$52.toString());
        }
        String verificationMethodId = jws.getHeader().getKeyID();
        Intrinsics.checkNotNull((Object)verificationMethodId);
        DidUri parsedDidUrl = DidUri.Parser.parse(verificationMethodId);
        String signingDid = parsedDidUrl.getUri();
        if (!Intrinsics.areEqual((Object)signingDid, (Object)did)) {
            throw new SignatureException("Signature verification failed: Was not signed by the expected DID. Expected DID: " + did + ". Actual DID: " + signingDid);
        }
        DidResolutionResult didResolutionResult = DidResolvers.resolve$default((DidResolvers)DidResolvers.INSTANCE, (String)parsedDidUrl.getUri(), null, (int)2, null);
        if (didResolutionResult.getDidResolutionMetadata().getError() != null) {
            throw new SignatureException("Signature verification failed: Failed to resolve DID " + parsedDidUrl.getUrl() + ". Error: " + didResolutionResult.getDidResolutionMetadata().getError());
        }
        Object[] objectArray = new String[]{parsedDidUrl.getUrl(), "#" + parsedDidUrl.getFragment()};
        Set verificationMethodIds = SetsKt.setOf((Object[])objectArray);
        DIDDocument dIDDocument = didResolutionResult.getDidDocument();
        List list = assertionMethodIds = dIDDocument != null ? dIDDocument.getAssertionMethod() : null;
        if (list != null) {
            Object v2;
            block9: {
                Iterable $this$firstOrNull$iv = list;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    String id = (String)element$iv;
                    boolean bl = false;
                    if (!verificationMethodIds.contains(id)) continue;
                    v2 = element$iv;
                    break block9;
                }
                v2 = null;
            }
            string = v2;
        } else {
            string = assertionMethodId = null;
        }
        if (!(assertionMethodId != null)) {
            boolean bl = false;
            throw new SignatureException("Signature verification failed: Expected kid in JWS header to dereference a DID Document Verification Method with an Assertion verification relationship");
        }
        DIDDocument dIDDocument2 = didResolutionResult.getDidDocument();
        Object assertionVerificationMethod = dIDDocument2 != null ? dIDDocument2.findAssertionMethodById(assertionMethodId) : null;
        if (!(assertionVerificationMethod != null && (assertionVerificationMethod.isType("JsonWebKey2020") || assertionVerificationMethod.isType("JsonWebKey")) && assertionVerificationMethod.getPublicKeyJwk() != null)) {
            boolean bl = false;
            throw new SignatureException("Signature verification failed: Expected kid in JWS header to dereference a DID Document Verification Method of type JsonWebKey2020 with a publicKeyJwk");
        }
        JWK jWK = assertionVerificationMethod.getPublicKeyJwk();
        Intrinsics.checkNotNull((Object)jWK);
        byte[] byArray = jws.getSigningInput();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getSigningInput(...)");
        byte[] byArray2 = jws.getSignature().decode();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"decode(...)");
        Crypto.INSTANCE.verify(jWK, byArray, byArray2);
    }

    @NotNull
    public final String sign(@NotNull Did did, @NotNull byte[] payload, @Nullable String assertionMethodId) {
        VerificationMethod assertionMethod;
        Intrinsics.checkNotNullParameter((Object)did, (String)"did");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        DidResolutionResult didResolutionResult = DidResolvers.resolve$default((DidResolvers)DidResolvers.INSTANCE, (String)did.getUri(), null, (int)2, null);
        DIDDocument dIDDocument = didResolutionResult.getDidDocument();
        VerificationMethod verificationMethod = assertionMethod = dIDDocument != null ? dIDDocument.findAssertionMethodById(assertionMethodId) : null;
        if (!((verificationMethod != null ? verificationMethod.getPublicKeyJwk() : null) != null)) {
            boolean $i$a$-check-CryptoUtils$sign$22 = false;
            String $i$a$-check-CryptoUtils$sign$22 = "publicKeyJwk is null";
            throw new IllegalStateException($i$a$-check-CryptoUtils$sign$22.toString());
        }
        KeyManager keyManager = did.getKeyManager();
        VerificationMethod verificationMethod2 = assertionMethod;
        Object object = verificationMethod2 != null ? verificationMethod2.getPublicKeyJwk() : null;
        Intrinsics.checkNotNull((Object)object);
        String keyAlias = keyManager.getDeterministicAlias(object);
        JWK publicKey = did.getKeyManager().getPublicKey(keyAlias);
        Algorithm algorithm = publicKey.getAlgorithm();
        JWSAlgorithm jwsAlgorithm = JWSAlgorithm.parse((String)algorithm.toString());
        String selectedAssertionMethodId = StringsKt.startsWith$default((String)assertionMethod.getId(), (String)"#", (boolean)false, (int)2, null) ? did.getUri() + assertionMethod.getId() : assertionMethod.getId();
        JWSHeader jwsHeader = new JWSHeader.Builder(jwsAlgorithm).keyID(selectedAssertionMethodId).build();
        Payload jwsPayload = new Payload(payload);
        JWSObject jwsObject = new JWSObject(jwsHeader, jwsPayload);
        byte[] toSign = jwsObject.getSigningInput();
        KeyManager keyManager2 = did.getKeyManager();
        Intrinsics.checkNotNull((Object)toSign);
        byte[] signatureBytes = keyManager2.sign(keyAlias, toSign);
        String base64UrlEncodedSignature = new Convert((Object)signatureBytes, null, 2, null).toBase64Url(false);
        Base64URL base64UrlEncodedHeader = jwsHeader.toBase64URL();
        return base64UrlEncodedHeader + ".." + base64UrlEncodedSignature;
    }

    public static /* synthetic */ String sign$default(CryptoUtils cryptoUtils, Did did, byte[] byArray, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        return cryptoUtils.sign(did, byArray, string);
    }
}

