/*
 * Decompiled with CFR 0.152.
 */
package tbdex.sdk.protocol.models;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonNode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tbdex.sdk.protocol.CryptoUtils;
import tbdex.sdk.protocol.Validator;
import tbdex.sdk.protocol.models.Offering;
import tbdex.sdk.protocol.models.ResourceData;
import tbdex.sdk.protocol.models.ResourceKind;
import tbdex.sdk.protocol.models.ResourceMetadata;
import tbdex.sdk.protocol.serialization.Json;
import web5.sdk.dids.Did;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u001a\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\fJ\b\u0010\u0018\u001a\u00020\fH\u0016J\u0006\u0010\u0019\u001a\u00020\u0014R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u0004\u0018\u00010\fX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u0082\u0001\u0001\u001b\u00a8\u0006\u001c"}, d2={"Ltbdex/sdk/protocol/models/Resource;", "", "()V", "data", "Ltbdex/sdk/protocol/models/ResourceData;", "getData", "()Ltbdex/sdk/protocol/models/ResourceData;", "metadata", "Ltbdex/sdk/protocol/models/ResourceMetadata;", "getMetadata", "()Ltbdex/sdk/protocol/models/ResourceMetadata;", "signature", "", "getSignature", "()Ljava/lang/String;", "setSignature", "(Ljava/lang/String;)V", "digest", "", "sign", "", "did", "Lweb5/sdk/dids/Did;", "keyAlias", "toString", "verify", "Companion", "Ltbdex/sdk/protocol/models/Offering;", "protocol"})
public abstract class Resource {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private Resource() {
    }

    @NotNull
    public abstract ResourceMetadata getMetadata();

    @NotNull
    public abstract ResourceData getData();

    @Nullable
    public abstract String getSignature();

    public abstract void setSignature(@Nullable String var1);

    public final void sign(@NotNull Did did, @Nullable String keyAlias) {
        Intrinsics.checkNotNullParameter((Object)did, (String)"did");
        this.setSignature(CryptoUtils.INSTANCE.sign(did, this.digest(), keyAlias));
    }

    public static /* synthetic */ void sign$default(Resource resource, Did did, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: sign");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        resource.sign(did, string);
    }

    public final void verify() {
        CryptoUtils.INSTANCE.verify(this.digest(), this.getSignature(), this.getMetadata().getFrom());
    }

    private final byte[] digest() {
        return CryptoUtils.INSTANCE.digestOf(this.getMetadata(), this.getData());
    }

    @NotNull
    public String toString() {
        return Json.INSTANCE.stringify(this);
    }

    public /* synthetic */ Resource(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Ltbdex/sdk/protocol/models/Resource$Companion;", "", "()V", "parse", "Ltbdex/sdk/protocol/models/Resource;", "payload", "", "protocol"})
    @SourceDebugExtension(value={"SMAP\nResource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Resource.kt\ntbdex/sdk/protocol/models/Resource$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,128:1\n1#2:129\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Resource parse(@NotNull String payload) {
            JsonNode jsonNode;
            Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
            try {
                jsonNode = Json.INSTANCE.getJsonMapper().readTree(payload);
                Intrinsics.checkNotNull((Object)jsonNode);
            }
            catch (JsonParseException e) {
                throw new IllegalArgumentException("unexpected character at offset " + e.getLocation().getCharOffset());
            }
            JsonNode jsonResource = jsonNode;
            if (!jsonResource.isObject()) {
                boolean $i$a$-require-Resource$Companion$parse$22 = false;
                String $i$a$-require-Resource$Companion$parse$22 = "expected payload to be a json object";
                throw new IllegalArgumentException($i$a$-require-Resource$Companion$parse$22.toString());
            }
            Validator.INSTANCE.validate(jsonResource, "resource");
            JsonNode dataJson = jsonResource.get("data");
            String kind = jsonResource.get("metadata").get("kind").asText();
            Intrinsics.checkNotNull((Object)dataJson);
            Intrinsics.checkNotNull((Object)kind);
            Validator.INSTANCE.validate(dataJson, kind);
            if (WhenMappings.$EnumSwitchMapping$0[ResourceKind.valueOf(kind).ordinal()] != 1) {
                throw new NoWhenBranchMatchedException();
            }
            Class<Offering> resourceType = Offering.class;
            Offering resource = (Offering)Json.INSTANCE.getJsonMapper().convertValue((Object)jsonResource, resourceType);
            resource.verify();
            Intrinsics.checkNotNull((Object)resource);
            return resource;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ResourceKind.values().length];
                try {
                    nArray[ResourceKind.offering.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

