/*
 * Decompiled with CFR 0.152.
 */
package tbdex.sdk.protocol.models;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.JsonSchema;
import de.fxlae.typeid.TypeId;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tbdex.sdk.protocol.Validator;
import tbdex.sdk.protocol.models.Message;
import tbdex.sdk.protocol.models.MessageKind;
import tbdex.sdk.protocol.models.MessageMetadata;
import tbdex.sdk.protocol.models.Offering;
import tbdex.sdk.protocol.models.PaymentMethod;
import tbdex.sdk.protocol.models.RfqData;
import tbdex.sdk.protocol.models.SelectedPaymentMethod;
import tbdex.sdk.protocol.serialization.Json;
import web5.sdk.credentials.PresentationExchange;
import web5.sdk.credentials.model.PresentationDefinitionV2;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u000b\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 &2\u00020\u0001:\u0001&B;\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0016\b\u0002\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u0007\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\u000bJ\u001e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002J\u0010\u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\"H\u0002J\u000e\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020%R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\n\u001a\u0004\u0018\u00010\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006'"}, d2={"Ltbdex/sdk/protocol/models/Rfq;", "Ltbdex/sdk/protocol/models/Message;", "metadata", "Ltbdex/sdk/protocol/models/MessageMetadata;", "data", "Ltbdex/sdk/protocol/models/RfqData;", "private", "", "", "", "signature", "(Ltbdex/sdk/protocol/models/MessageMetadata;Ltbdex/sdk/protocol/models/RfqData;Ljava/util/Map;Ljava/lang/String;)V", "getData", "()Ltbdex/sdk/protocol/models/RfqData;", "getMetadata", "()Ltbdex/sdk/protocol/models/MessageMetadata;", "getSignature", "()Ljava/lang/String;", "setSignature", "(Ljava/lang/String;)V", "validNext", "", "Ltbdex/sdk/protocol/models/MessageKind;", "getValidNext", "()Ljava/util/Set;", "validatePaymentMethod", "", "selectedMethod", "Ltbdex/sdk/protocol/models/SelectedPaymentMethod;", "offeringMethods", "", "Ltbdex/sdk/protocol/models/PaymentMethod;", "verifyClaims", "requiredClaims", "Lweb5/sdk/credentials/model/PresentationDefinitionV2;", "verifyOfferingRequirements", "offering", "Ltbdex/sdk/protocol/models/Offering;", "Companion", "protocol"})
@SourceDebugExtension(value={"SMAP\nRfq.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Rfq.kt\ntbdex/sdk/protocol/models/Rfq\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,108:1\n1#2:109\n223#3,2:110\n*S KotlinDebug\n*F\n+ 1 Rfq.kt\ntbdex/sdk/protocol/models/Rfq\n*L\n55#1:110,2\n*E\n"})
public final class Rfq
extends Message {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MessageMetadata metadata;
    @NotNull
    private final RfqData data;
    @Nullable
    private String signature;
    @NotNull
    private final Set<MessageKind> validNext;

    private Rfq(MessageMetadata metadata, RfqData data, Map<String, ? extends Object> map, String signature) {
        super(null);
        this.metadata = metadata;
        this.data = data;
        this.signature = signature;
        MessageKind[] messageKindArray = new MessageKind[]{MessageKind.quote, MessageKind.close};
        this.validNext = SetsKt.setOf((Object[])messageKindArray);
    }

    /* synthetic */ Rfq(MessageMetadata messageMetadata, RfqData rfqData, Map map, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            map = null;
        }
        if ((n & 8) != 0) {
            string = null;
        }
        this(messageMetadata, rfqData, map, string);
    }

    @Override
    @NotNull
    public MessageMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    @NotNull
    public RfqData getData() {
        return this.data;
    }

    @Override
    @Nullable
    public String getSignature() {
        return this.signature;
    }

    @Override
    public void setSignature(@Nullable String string) {
        this.signature = string;
    }

    @Override
    @NotNull
    public Set<MessageKind> getValidNext() {
        return this.validNext;
    }

    public final void verifyOfferingRequirements(@NotNull Offering offering) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)offering, (String)"offering");
            if (!Intrinsics.areEqual((Object)this.getData().getOfferingId(), (Object)offering.getMetadata().getId())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (offering.getData().getPayinCurrency().getMinAmount() != null && !(offering.getData().getPayinCurrency().getMinAmount().compareTo(this.getData().getPayinAmount()) <= 0)) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            if (offering.getData().getPayinCurrency().getMaxAmount() != null && !(this.getData().getPayinAmount().compareTo(offering.getData().getPayinCurrency().getMaxAmount()) <= 0)) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            this.validatePaymentMethod(this.getData().getPayinMethod(), offering.getData().getPayinMethods());
            this.validatePaymentMethod(this.getData().getPayoutMethod(), offering.getData().getPayoutMethods());
            PresentationDefinitionV2 presentationDefinitionV2 = offering.getData().getRequiredClaims();
            if (presentationDefinitionV2 == null) break block3;
            PresentationDefinitionV2 it = presentationDefinitionV2;
            boolean bl = false;
            this.verifyClaims(it);
        }
    }

    private final void validatePaymentMethod(SelectedPaymentMethod selectedMethod, List<PaymentMethod> offeringMethods) {
        block3: {
            Object element$iv2;
            block2: {
                Iterable $this$first$iv = offeringMethods;
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    PaymentMethod it = (PaymentMethod)element$iv2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getKind(), (Object)selectedMethod.getKind())) continue;
                    break block2;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            PaymentMethod matchedOfferingMethod = (PaymentMethod)element$iv2;
            JsonNode jsonNode = matchedOfferingMethod.getRequiredPaymentDetails();
            if (jsonNode == null) break block3;
            JsonNode it = jsonNode;
            boolean bl = false;
            JsonSchema schema = matchedOfferingMethod.getRequiredPaymentDetailsSchema();
            JsonNode jsonNodePaymentDetails = Json.INSTANCE.getJsonMapper().valueToTree(selectedMethod.getPaymentDetails());
            JsonSchema jsonSchema = schema;
            if (jsonSchema != null) {
                jsonSchema.validate(jsonNodePaymentDetails);
            }
        }
    }

    private final void verifyClaims(PresentationDefinitionV2 requiredClaims) {
        try {
            PresentationExchange.INSTANCE.satisfiesPresentationDefinition((Iterable)this.getData().getClaims(), requiredClaims);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("No matching claim for Offering requirements: " + requiredClaims.getId());
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JB\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u00062\u0016\b\u0002\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0001\u0018\u00010\f\u00a8\u0006\r"}, d2={"Ltbdex/sdk/protocol/models/Rfq$Companion;", "", "()V", "create", "Ltbdex/sdk/protocol/models/Rfq;", "to", "", "from", "rfqData", "Ltbdex/sdk/protocol/models/RfqData;", "externalId", "private", "", "protocol"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Rfq create(@NotNull String to, @NotNull String from, @NotNull RfqData rfqData, @Nullable String externalId, @Nullable Map<String, ? extends Object> map) {
            Intrinsics.checkNotNullParameter((Object)to, (String)"to");
            Intrinsics.checkNotNullParameter((Object)from, (String)"from");
            Intrinsics.checkNotNullParameter((Object)rfqData, (String)"rfqData");
            String string = TypeId.generate((String)"rfq").toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String id = string;
            OffsetDateTime offsetDateTime = OffsetDateTime.now();
            Intrinsics.checkNotNullExpressionValue((Object)offsetDateTime, (String)"now(...)");
            MessageMetadata metadata = new MessageMetadata(MessageKind.rfq, to, from, id, id, offsetDateTime, externalId);
            Validator.INSTANCE.validateData(rfqData, "rfq");
            return new Rfq(metadata, rfqData, map, null, 8, null);
        }

        public static /* synthetic */ Rfq create$default(Companion companion, String string, String string2, RfqData rfqData, String string3, Map map, int n, Object object) {
            if ((n & 8) != 0) {
                string3 = null;
            }
            if ((n & 0x10) != 0) {
                map = null;
            }
            return companion.create(string, string2, rfqData, string3, map);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

