/*
 * Decompiled with CFR 0.152.
 */
package tbdex.sdk.protocol.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tbdex.sdk.protocol.CryptoUtils;
import tbdex.sdk.protocol.Validator;
import tbdex.sdk.protocol.models.Close;
import tbdex.sdk.protocol.models.MessageData;
import tbdex.sdk.protocol.models.MessageKind;
import tbdex.sdk.protocol.models.MessageMetadata;
import tbdex.sdk.protocol.models.Order;
import tbdex.sdk.protocol.models.OrderStatus;
import tbdex.sdk.protocol.models.Quote;
import tbdex.sdk.protocol.models.Rfq;
import tbdex.sdk.protocol.serialization.Json;
import web5.sdk.dids.Did;

@JsonIgnoreProperties(value={"validNext"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u001a\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\fJ\b\u0010\u001d\u001a\u00020\fH\u0016J\u0006\u0010\u001e\u001a\u00020\u0019R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u0004\u0018\u00010\fX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u0082\u0001\u0005 !\"#$\u00a8\u0006%"}, d2={"Ltbdex/sdk/protocol/models/Message;", "", "()V", "data", "Ltbdex/sdk/protocol/models/MessageData;", "getData", "()Ltbdex/sdk/protocol/models/MessageData;", "metadata", "Ltbdex/sdk/protocol/models/MessageMetadata;", "getMetadata", "()Ltbdex/sdk/protocol/models/MessageMetadata;", "signature", "", "getSignature", "()Ljava/lang/String;", "setSignature", "(Ljava/lang/String;)V", "validNext", "", "Ltbdex/sdk/protocol/models/MessageKind;", "getValidNext", "()Ljava/util/Set;", "digest", "", "sign", "", "did", "Lweb5/sdk/dids/Did;", "keyAlias", "toString", "verify", "Companion", "Ltbdex/sdk/protocol/models/Close;", "Ltbdex/sdk/protocol/models/Order;", "Ltbdex/sdk/protocol/models/OrderStatus;", "Ltbdex/sdk/protocol/models/Quote;", "Ltbdex/sdk/protocol/models/Rfq;", "protocol"})
public abstract class Message {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private Message() {
    }

    @NotNull
    public abstract Set<MessageKind> getValidNext();

    @NotNull
    public abstract MessageMetadata getMetadata();

    @NotNull
    public abstract MessageData getData();

    @Nullable
    public abstract String getSignature();

    public abstract void setSignature(@Nullable String var1);

    public final void sign(@NotNull Did did, @Nullable String keyAlias) {
        Intrinsics.checkNotNullParameter((Object)did, (String)"did");
        this.setSignature(CryptoUtils.INSTANCE.sign(did, this.digest(), keyAlias));
    }

    public static /* synthetic */ void sign$default(Message message, Did did, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: sign");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        message.sign(did, string);
    }

    public final void verify() {
        CryptoUtils.INSTANCE.verify(this.digest(), this.getSignature(), this.getMetadata().getFrom());
    }

    private final byte[] digest() {
        return CryptoUtils.INSTANCE.digestOf(this.getMetadata(), this.getData());
    }

    @NotNull
    public String toString() {
        return Json.INSTANCE.stringify(this);
    }

    public /* synthetic */ Message(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Ltbdex/sdk/protocol/models/Message$Companion;", "", "()V", "parse", "Ltbdex/sdk/protocol/models/Message;", "payload", "", "protocol"})
    @SourceDebugExtension(value={"SMAP\nMessage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Message.kt\ntbdex/sdk/protocol/models/Message$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,136:1\n1#2:137\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Message parse(@NotNull String payload) {
            Class clazz;
            Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
            JsonNode jsonMessage = null;
            try {
                JsonNode jsonNode = Json.INSTANCE.getJsonMapper().readTree(payload);
                Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"readTree(...)");
                jsonMessage = jsonNode;
            }
            catch (JsonParseException e) {
                throw new IllegalArgumentException("unexpected character at offset " + e.getLocation().getCharOffset());
            }
            if (!jsonMessage.isObject()) {
                boolean $i$a$-require-Message$Companion$parse$22 = false;
                String $i$a$-require-Message$Companion$parse$22 = "expected payload to be a json object";
                throw new IllegalArgumentException($i$a$-require-Message$Companion$parse$22.toString());
            }
            Validator.INSTANCE.validate(jsonMessage, "message");
            JsonNode jsonMessageData = jsonMessage.get("data");
            String kind = jsonMessage.get("metadata").get("kind").asText();
            Intrinsics.checkNotNull((Object)jsonMessageData);
            Intrinsics.checkNotNull((Object)kind);
            Validator.INSTANCE.validate(jsonMessageData, kind);
            switch (WhenMappings.$EnumSwitchMapping$0[MessageKind.valueOf(kind).ordinal()]) {
                case 1: {
                    clazz = Rfq.class;
                    break;
                }
                case 2: {
                    clazz = Order.class;
                    break;
                }
                case 3: {
                    clazz = OrderStatus.class;
                    break;
                }
                case 4: {
                    clazz = Quote.class;
                    break;
                }
                case 5: {
                    clazz = Close.class;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Class messageType = clazz;
            Message message = (Message)Json.INSTANCE.getJsonMapper().convertValue((Object)jsonMessage, messageType);
            message.verify();
            Intrinsics.checkNotNull((Object)message);
            return message;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[MessageKind.values().length];
                try {
                    nArray[MessageKind.rfq.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[MessageKind.order.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[MessageKind.orderstatus.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[MessageKind.quote.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[MessageKind.close.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

