/*
 * Decompiled with CFR 0.152.
 */
package tbdex.sdk.protocol;

import java.security.MessageDigest;
import java.security.SignatureException;
import java.util.Map;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.erdtman.jcs.JsonCanonicalizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tbdex.sdk.protocol.models.Data;
import tbdex.sdk.protocol.models.Metadata;
import tbdex.sdk.protocol.serialization.Json;
import web5.sdk.jose.jws.DecodedJws;
import web5.sdk.jose.jws.Jws;

@kotlin.Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0001J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u000e\u00a8\u0006\u0010"}, d2={"Ltbdex/sdk/protocol/SignatureVerifier;", "", "()V", "digestOf", "", "payload", "metadata", "Ltbdex/sdk/protocol/models/Metadata;", "data", "Ltbdex/sdk/protocol/models/Data;", "verify", "", "detachedPayload", "signature", "", "did", "tbdex-protocol"})
public final class SignatureVerifier {
    @NotNull
    public static final SignatureVerifier INSTANCE = new SignatureVerifier();

    private SignatureVerifier() {
    }

    @NotNull
    public final byte[] digestOf(@NotNull Metadata metadata, @NotNull Data data) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"metadata", (Object)metadata), TuplesKt.to((Object)"data", (Object)data)};
        Map payload = MapsKt.mapOf((Pair[])pairArray);
        return this.digestOf(payload);
    }

    @NotNull
    public final byte[] digestOf(@NotNull Object payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        JsonCanonicalizer canonicalJsonSerializedPayload = new JsonCanonicalizer(Json.INSTANCE.stringify(payload));
        MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
        byte[] byArray = sha256.digest(canonicalJsonSerializedPayload.getEncodedUTF8());
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
        return byArray;
    }

    public final void verify(@NotNull byte[] detachedPayload, @Nullable String signature, @NotNull String did) {
        Intrinsics.checkNotNullParameter((Object)detachedPayload, (String)"detachedPayload");
        Intrinsics.checkNotNullParameter((Object)did, (String)"did");
        if (!(signature != null)) {
            boolean bl = false;
            throw new IllegalArgumentException("Signature verification failed: Expected signature property to exist");
        }
        DecodedJws decodedJws = Jws.INSTANCE.decode(signature, detachedPayload);
        String signerDid = decodedJws.getSignerDid();
        if (!Intrinsics.areEqual((Object)signerDid, (Object)did)) {
            throw new SignatureException("Signature verification failed: Was not signed by the expected DID. Expected DID: " + did + ". Actual DID: " + signerDid);
        }
        decodedJws.verify();
    }
}

