/*
 * Decompiled with CFR 0.152.
 */
package tbdex.sdk.protocol;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SchemaValidatorsConfig;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.ValidationMessage;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import tbdex.sdk.protocol.ValidatorException;
import tbdex.sdk.protocol.models.Data;
import tbdex.sdk.protocol.models.Message;
import tbdex.sdk.protocol.models.MessageKind;
import tbdex.sdk.protocol.models.ResourceKind;
import tbdex.sdk.protocol.serialization.Json;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0007J\u0016\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007J\u000e\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ltbdex/sdk/protocol/Validator;", "", "()V", "config", "Lcom/networknt/schema/SchemaValidatorsConfig;", "schemaMap", "", "", "Lcom/networknt/schema/JsonSchema;", "validate", "", "jsonMessage", "Lcom/fasterxml/jackson/databind/JsonNode;", "schemaName", "validateData", "data", "Ltbdex/sdk/protocol/models/Data;", "messageKind", "validateMessage", "message", "Ltbdex/sdk/protocol/models/Message;", "tbdex-protocol"})
@SourceDebugExtension(value={"SMAP\nValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Validator.kt\ntbdex/sdk/protocol/Validator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n1549#2:106\n1620#2,3:107\n1549#2:110\n1620#2,3:111\n1549#2:114\n1620#2,3:115\n*S KotlinDebug\n*F\n+ 1 Validator.kt\ntbdex/sdk/protocol/Validator\n*L\n76#1:106\n76#1:107,3\n54#1:110\n54#1:111,3\n55#1:114\n55#1:115,3\n*E\n"})
public final class Validator {
    @NotNull
    public static final Validator INSTANCE;
    @NotNull
    private static final Map<String, JsonSchema> schemaMap;
    @NotNull
    private static final SchemaValidatorsConfig config;

    private Validator() {
    }

    /*
     * WARNING - void declaration
     */
    public final void validate(@NotNull JsonNode jsonMessage, @NotNull String schemaName) {
        Intrinsics.checkNotNullParameter((Object)jsonMessage, (String)"jsonMessage");
        Intrinsics.checkNotNullParameter((Object)schemaName, (String)"schemaName");
        JsonSchema jsonSchema = schemaMap.get(schemaName);
        if (jsonSchema == null) {
            throw new ValidatorException("No schema with name " + schemaName + " exists", null, 2, null);
        }
        JsonSchema schema = jsonSchema;
        Set validationMessages = schema.validate(jsonMessage);
        Intrinsics.checkNotNull((Object)validationMessages);
        if (!((Collection)validationMessages).isEmpty()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = validationMessages;
            String string = "invalid payload";
            boolean $i$f$map = false;
            void var7_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ValidationMessage validationMessage = (ValidationMessage)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getMessage());
            }
            List list = (List)destination$iv$iv;
            String string2 = string;
            throw new ValidatorException(string2, list);
        }
    }

    public final void validateMessage(@NotNull Message message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        JsonNode messageJsonNode = Json.INSTANCE.getJsonMapper().readTree(message.toString());
        Intrinsics.checkNotNull((Object)messageJsonNode);
        this.validate(messageJsonNode, "message");
        this.validateData(message.getData(), message.getMetadata().getKind().toString());
    }

    public final void validateData(@NotNull Data data, @NotNull String messageKind) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)messageKind, (String)"messageKind");
        String json = Json.INSTANCE.stringify(data);
        JsonNode jsonNode = Json.INSTANCE.getJsonMapper().readTree(json);
        Intrinsics.checkNotNull((Object)jsonNode);
        this.validate(jsonNode, messageKind);
    }

    private static final URI _init_$lambda$0(ClassLoader $loader, URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        String string = uri.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String uriStr = string;
        String prefix = "https://tbdex.dev/";
        if (StringsKt.startsWith$default((String)uriStr, (String)prefix, (boolean)false, (int)2, null)) {
            String string2 = uriStr.substring(prefix.length());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String resourceName = string2;
            URL uRL = $loader.getResource(resourceName);
            URI resourceUri = uRL != null ? uRL.toURI() : null;
            return resourceUri;
        }
        return uri;
    }

    static {
        ResourceKind it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        INSTANCE = new Validator();
        schemaMap = new LinkedHashMap();
        config = new SchemaValidatorsConfig();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        config.addUriTranslator(arg_0 -> Validator._init_$lambda$0(loader, arg_0));
        JsonSchemaFactory factory = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V7);
        InputStream definitionsStream = loader.getResourceAsStream("definitions.json");
        factory.getSchema(definitionsStream, config);
        Object object = new Pair[]{TuplesKt.to((Object)"message", (Object)"message.schema.json"), TuplesKt.to((Object)"resource", (Object)"resource.schema.json")};
        Collection collection2 = CollectionsKt.listOf((Object[])object);
        object = (Iterable)MessageKind.getEntries();
        Collection collection3 = collection2;
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            MessageKind messageKind = (MessageKind)((Object)item$iv$iv);
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it.name(), (Object)(it.name() + ".schema.json")));
        }
        $this$map$iv = (Iterable)ResourceKind.getEntries();
        collection3 = CollectionsKt.plus((Collection)collection3, (Iterable)((List)destination$iv$iv));
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ResourceKind)((Object)item$iv$iv);
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it.name(), (Object)(it.name() + ".schema.json")));
        }
        List schemaNames = CollectionsKt.plus((Collection)collection3, (Iterable)((List)destination$iv$iv));
        for (Pair schemaName : schemaNames) {
            JsonSchema jsonSchema;
            String name = (String)schemaName.component1();
            String fileName = (String)schemaName.component2();
            InputStream schemaStream = loader.getResourceAsStream(fileName);
            Map<String, JsonSchema> map = schemaMap;
            Intrinsics.checkNotNullExpressionValue((Object)factory.getSchema(schemaStream, config), (String)"getSchema(...)");
            map.put(name, jsonSchema);
        }
    }
}

