/*
 * Decompiled with CFR 0.152.
 */
package tbdex.sdk.protocol.models;

import com.fasterxml.jackson.databind.JsonNode;
import de.fxlae.typeid.TypeId;
import java.time.OffsetDateTime;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tbdex.sdk.protocol.Parser;
import tbdex.sdk.protocol.Validator;
import tbdex.sdk.protocol.models.OfferingData;
import tbdex.sdk.protocol.models.Resource;
import tbdex.sdk.protocol.models.ResourceKind;
import tbdex.sdk.protocol.models.ResourceMetadata;
import tbdex.sdk.protocol.serialization.Json;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B#\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0012"}, d2={"Ltbdex/sdk/protocol/models/Offering;", "Ltbdex/sdk/protocol/models/Resource;", "metadata", "Ltbdex/sdk/protocol/models/ResourceMetadata;", "data", "Ltbdex/sdk/protocol/models/OfferingData;", "signature", "", "(Ltbdex/sdk/protocol/models/ResourceMetadata;Ltbdex/sdk/protocol/models/OfferingData;Ljava/lang/String;)V", "getData", "()Ltbdex/sdk/protocol/models/OfferingData;", "getMetadata", "()Ltbdex/sdk/protocol/models/ResourceMetadata;", "getSignature", "()Ljava/lang/String;", "setSignature", "(Ljava/lang/String;)V", "Companion", "tbdex-protocol"})
public final class Offering
extends Resource {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResourceMetadata metadata;
    @NotNull
    private final OfferingData data;
    @Nullable
    private String signature;

    private Offering(ResourceMetadata metadata, OfferingData data, String signature) {
        super(null);
        this.metadata = metadata;
        this.data = data;
        this.signature = signature;
    }

    /* synthetic */ Offering(ResourceMetadata resourceMetadata, OfferingData offeringData, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = null;
        }
        this(resourceMetadata, offeringData, string);
    }

    @Override
    @NotNull
    public ResourceMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    @NotNull
    public OfferingData getData() {
        return this.data;
    }

    @Override
    @Nullable
    public String getSignature() {
        return this.signature;
    }

    @Override
    public void setSignature(@Nullable String string) {
        this.signature = string;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u0006J\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0006\u00a8\u0006\f"}, d2={"Ltbdex/sdk/protocol/models/Offering$Companion;", "", "()V", "create", "Ltbdex/sdk/protocol/models/Offering;", "from", "", "data", "Ltbdex/sdk/protocol/models/OfferingData;", "protocol", "parse", "payload", "tbdex-protocol"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Offering create(@NotNull String from, @NotNull OfferingData data, @NotNull String protocol) {
            Intrinsics.checkNotNullParameter((Object)from, (String)"from");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
            OffsetDateTime now = OffsetDateTime.now();
            String string = TypeId.generate((String)"offering").toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            Intrinsics.checkNotNull((Object)now);
            ResourceMetadata metadata = new ResourceMetadata(ResourceKind.offering, from, string, protocol, now, now);
            Validator.INSTANCE.validateData(data, "offering");
            return new Offering(metadata, data, null, 4, null);
        }

        public static /* synthetic */ Offering create$default(Companion companion, String string, OfferingData offeringData, String string2, int n, Object object) {
            if ((n & 4) != 0) {
                string2 = "1.0";
            }
            return companion.create(string, offeringData, string2);
        }

        @NotNull
        public final Offering parse(@NotNull String payload) {
            Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
            JsonNode jsonResource = Parser.INSTANCE.parseResourceToJsonNode(payload);
            String kind = jsonResource.get("metadata").get("kind").asText();
            if (!Intrinsics.areEqual((Object)kind, (Object)"offering")) {
                throw new IllegalArgumentException("Message must be an Offering but resource kind was " + kind);
            }
            Offering resource = (Offering)Json.INSTANCE.getJsonMapper().convertValue((Object)jsonResource, Offering.class);
            resource.verify();
            Intrinsics.checkNotNull((Object)resource);
            return resource;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

