/*
 * Decompiled with CFR 0.152.
 */
package tbdex.sdk.protocol;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonNode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import tbdex.sdk.protocol.Validator;
import tbdex.sdk.protocol.models.Balance;
import tbdex.sdk.protocol.models.Close;
import tbdex.sdk.protocol.models.Message;
import tbdex.sdk.protocol.models.MessageKind;
import tbdex.sdk.protocol.models.Offering;
import tbdex.sdk.protocol.models.Order;
import tbdex.sdk.protocol.models.OrderStatus;
import tbdex.sdk.protocol.models.Quote;
import tbdex.sdk.protocol.models.Resource;
import tbdex.sdk.protocol.models.ResourceKind;
import tbdex.sdk.protocol.models.Rfq;
import tbdex.sdk.protocol.serialization.Json;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\f"}, d2={"Ltbdex/sdk/protocol/Parser;", "", "()V", "parseMessage", "Ltbdex/sdk/protocol/models/Message;", "payload", "", "parseMessageToJsonNode", "Lcom/fasterxml/jackson/databind/JsonNode;", "parseResource", "Ltbdex/sdk/protocol/models/Resource;", "parseResourceToJsonNode", "tbdex-protocol"})
@SourceDebugExtension(value={"SMAP\nParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Parser.kt\ntbdex/sdk/protocol/Parser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,152:1\n1#2:153\n*E\n"})
public final class Parser {
    @NotNull
    public static final Parser INSTANCE = new Parser();

    private Parser() {
    }

    @NotNull
    public final Message parseMessage(@NotNull String payload) {
        Class clazz;
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        JsonNode jsonMessage = this.parseMessageToJsonNode(payload);
        String kind = jsonMessage.get("metadata").get("kind").asText();
        Intrinsics.checkNotNull((Object)kind);
        switch (WhenMappings.$EnumSwitchMapping$0[MessageKind.valueOf(kind).ordinal()]) {
            case 1: {
                clazz = Rfq.class;
                break;
            }
            case 2: {
                clazz = Order.class;
                break;
            }
            case 3: {
                clazz = OrderStatus.class;
                break;
            }
            case 4: {
                clazz = Quote.class;
                break;
            }
            case 5: {
                clazz = Close.class;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Class messageType = clazz;
        Message message = (Message)Json.INSTANCE.getJsonMapper().convertValue((Object)jsonMessage, messageType);
        message.verify();
        Intrinsics.checkNotNull((Object)message);
        return message;
    }

    @NotNull
    public final JsonNode parseMessageToJsonNode(@NotNull String payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        JsonNode jsonMessage = null;
        try {
            JsonNode jsonNode = Json.INSTANCE.getJsonMapper().readTree(payload);
            Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"readTree(...)");
            jsonMessage = jsonNode;
        }
        catch (JsonParseException e) {
            throw new IllegalArgumentException("unexpected character at offset " + e.getLocation().getCharOffset());
        }
        if (!jsonMessage.isObject()) {
            boolean $i$a$-require-Parser$parseMessageToJsonNode$22 = false;
            String $i$a$-require-Parser$parseMessageToJsonNode$22 = "expected payload to be a json object";
            throw new IllegalArgumentException($i$a$-require-Parser$parseMessageToJsonNode$22.toString());
        }
        Validator.INSTANCE.validate(jsonMessage, "message");
        JsonNode jsonMessageData = jsonMessage.get("data");
        String kind = jsonMessage.get("metadata").get("kind").asText();
        Intrinsics.checkNotNull((Object)jsonMessageData);
        Intrinsics.checkNotNull((Object)kind);
        Validator.INSTANCE.validate(jsonMessageData, kind);
        return jsonMessage;
    }

    @NotNull
    public final Resource parseResource(@NotNull String payload) {
        Class clazz;
        JsonNode jsonNode;
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        try {
            jsonNode = Json.INSTANCE.getJsonMapper().readTree(payload);
            Intrinsics.checkNotNull((Object)jsonNode);
        }
        catch (JsonParseException e) {
            throw new IllegalArgumentException("unexpected character at offset " + e.getLocation().getCharOffset());
        }
        JsonNode jsonResource = jsonNode;
        if (!jsonResource.isObject()) {
            boolean $i$a$-require-Parser$parseResource$22 = false;
            String $i$a$-require-Parser$parseResource$22 = "expected payload to be a json object";
            throw new IllegalArgumentException($i$a$-require-Parser$parseResource$22.toString());
        }
        Validator.INSTANCE.validate(jsonResource, "resource");
        JsonNode dataJson = jsonResource.get("data");
        String kind = jsonResource.get("metadata").get("kind").asText();
        Intrinsics.checkNotNull((Object)dataJson);
        Intrinsics.checkNotNull((Object)kind);
        Validator.INSTANCE.validate(dataJson, kind);
        switch (WhenMappings.$EnumSwitchMapping$1[ResourceKind.valueOf(kind).ordinal()]) {
            case 1: {
                clazz = Offering.class;
                break;
            }
            case 2: {
                clazz = Balance.class;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Class resourceType = clazz;
        Resource resource = (Resource)Json.INSTANCE.getJsonMapper().convertValue((Object)jsonResource, resourceType);
        resource.verify();
        Intrinsics.checkNotNull((Object)resource);
        return resource;
    }

    @NotNull
    public final JsonNode parseResourceToJsonNode(@NotNull String payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        JsonNode jsonResource = null;
        try {
            JsonNode jsonNode = Json.INSTANCE.getJsonMapper().readTree(payload);
            Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"readTree(...)");
            jsonResource = jsonNode;
        }
        catch (JsonParseException e) {
            throw new IllegalArgumentException("unexpected character at offset " + e.getLocation().getCharOffset());
        }
        if (!jsonResource.isObject()) {
            boolean $i$a$-require-Parser$parseResourceToJsonNode$22 = false;
            String $i$a$-require-Parser$parseResourceToJsonNode$22 = "expected payload to be a json object";
            throw new IllegalArgumentException($i$a$-require-Parser$parseResourceToJsonNode$22.toString());
        }
        Validator.INSTANCE.validate(jsonResource, "resource");
        JsonNode jsonResourceData = jsonResource.get("data");
        String kind = jsonResource.get("metadata").get("kind").asText();
        Intrinsics.checkNotNull((Object)jsonResourceData);
        Intrinsics.checkNotNull((Object)kind);
        Validator.INSTANCE.validate(jsonResourceData, kind);
        return jsonResource;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[MessageKind.values().length];
            try {
                nArray[MessageKind.rfq.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageKind.order.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageKind.orderstatus.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageKind.quote.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageKind.close.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ResourceKind.values().length];
            try {
                nArray[ResourceKind.offering.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResourceKind.balance.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

