/*
 * Decompiled with CFR 0.152.
 */
package tbdex.sdk.protocol.models;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tbdex.sdk.protocol.SignatureVerifier;
import tbdex.sdk.protocol.models.ResourceData;
import tbdex.sdk.protocol.models.ResourceMetadata;
import tbdex.sdk.protocol.serialization.Json;
import web5.sdk.dids.did.BearerDid;
import web5.sdk.jose.jws.Jws;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\fH\u0016J\u0006\u0010\u0018\u001a\u00020\u0014R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u0004\u0018\u00010\fX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u0082\u0001\u0002\u0019\u001a\u00a8\u0006\u001b"}, d2={"Ltbdex/sdk/protocol/models/Resource;", "", "()V", "data", "Ltbdex/sdk/protocol/models/ResourceData;", "getData", "()Ltbdex/sdk/protocol/models/ResourceData;", "metadata", "Ltbdex/sdk/protocol/models/ResourceMetadata;", "getMetadata", "()Ltbdex/sdk/protocol/models/ResourceMetadata;", "signature", "", "getSignature", "()Ljava/lang/String;", "setSignature", "(Ljava/lang/String;)V", "digest", "", "sign", "", "did", "Lweb5/sdk/dids/did/BearerDid;", "toString", "verify", "Ltbdex/sdk/protocol/models/Balance;", "Ltbdex/sdk/protocol/models/Offering;", "tbdex-protocol"})
public abstract class Resource {
    private Resource() {
    }

    @NotNull
    public abstract ResourceMetadata getMetadata();

    @NotNull
    public abstract ResourceData getData();

    @Nullable
    public abstract String getSignature();

    public abstract void setSignature(@Nullable String var1);

    public final void sign(@NotNull BearerDid did) {
        Intrinsics.checkNotNullParameter((Object)did, (String)"did");
        this.setSignature(Jws.INSTANCE.sign(did, this.digest(), true));
    }

    public final void verify() {
        SignatureVerifier.INSTANCE.verify(this.digest(), this.getSignature(), this.getMetadata().getFrom());
    }

    private final byte[] digest() {
        return SignatureVerifier.INSTANCE.digestOf(this.getMetadata(), this.getData());
    }

    @NotNull
    public String toString() {
        return Json.INSTANCE.stringify(this);
    }

    public /* synthetic */ Resource(DefaultConstructorMarker $constructor_marker) {
        this();
    }
}

