/*
 * Decompiled with CFR 0.152.
 */
package tbdex.sdk.protocol.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tbdex.sdk.protocol.SignatureVerifier;
import tbdex.sdk.protocol.models.MessageData;
import tbdex.sdk.protocol.models.MessageKind;
import tbdex.sdk.protocol.models.MessageMetadata;
import tbdex.sdk.protocol.serialization.Json;
import web5.sdk.dids.did.BearerDid;
import web5.sdk.jose.jws.Jws;

@JsonIgnoreProperties(value={"validNext"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u00002\u00020\u0001B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\b\u0010\u001c\u001a\u00020\fH\u0016J\u0006\u0010\u001d\u001a\u00020\u0019R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u0004\u0018\u00010\fX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u0082\u0001\u0005\u001e\u001f !\"\u00a8\u0006#"}, d2={"Ltbdex/sdk/protocol/models/Message;", "", "()V", "data", "Ltbdex/sdk/protocol/models/MessageData;", "getData", "()Ltbdex/sdk/protocol/models/MessageData;", "metadata", "Ltbdex/sdk/protocol/models/MessageMetadata;", "getMetadata", "()Ltbdex/sdk/protocol/models/MessageMetadata;", "signature", "", "getSignature", "()Ljava/lang/String;", "setSignature", "(Ljava/lang/String;)V", "validNext", "", "Ltbdex/sdk/protocol/models/MessageKind;", "getValidNext", "()Ljava/util/Set;", "digest", "", "sign", "", "did", "Lweb5/sdk/dids/did/BearerDid;", "toString", "verify", "Ltbdex/sdk/protocol/models/Close;", "Ltbdex/sdk/protocol/models/Order;", "Ltbdex/sdk/protocol/models/OrderStatus;", "Ltbdex/sdk/protocol/models/Quote;", "Ltbdex/sdk/protocol/models/Rfq;", "tbdex-protocol"})
public abstract class Message {
    private Message() {
    }

    @NotNull
    public abstract Set<MessageKind> getValidNext();

    @NotNull
    public abstract MessageMetadata getMetadata();

    @NotNull
    public abstract MessageData getData();

    @Nullable
    public abstract String getSignature();

    public abstract void setSignature(@Nullable String var1);

    public final void sign(@NotNull BearerDid did) {
        Intrinsics.checkNotNullParameter((Object)did, (String)"did");
        this.setSignature(Jws.INSTANCE.sign(did, this.digest(), true));
    }

    public final void verify() {
        SignatureVerifier.INSTANCE.verify(this.digest(), this.getSignature(), this.getMetadata().getFrom());
    }

    private final byte[] digest() {
        return SignatureVerifier.INSTANCE.digestOf(this.getMetadata(), this.getData());
    }

    @NotNull
    public String toString() {
        return Json.INSTANCE.stringify(this);
    }

    public /* synthetic */ Message(DefaultConstructorMarker $constructor_marker) {
        this();
    }
}

